/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;

public class Delete
extends AbstractDML {
    private Where where;

    public Delete(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Delete(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Delete(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.setWhere(where);
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public Where getWhere() {
        return this.where;
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (connection == null) {
            FRContext.getLogger().log(Level.WARNING, "Connection can not be null.");
            return null;
        }
        if (this.getTable() == null) {
            FRContext.getLogger().log(Level.WARNING, "Table can not be null");
            return null;
        }
        if (!this.isEmptyWhereAllowed() && this.where == null) {
            FRContext.getLogger().log(Level.WARNING, "Where can not be null");
            return null;
        }
        String string = TemplateUtils.render("DELETE FROM ${table} ${where}", new String[]{"table", "where"}, new String[]{this.getTable().toStatementSQLString(this.dialect), this.where == null ? "" : this.where.toStatementSQLString(this.dialect)});
        FRContext.getLogger().log(Level.INFO, string.toString());
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, 1);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n = preparedStatement.executeUpdate();
                return n;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

