/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.list.IntList;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class Insert
extends InsertOrUpdate {
    private Map columnNameExpressionMap = new HashMap();

    public Insert(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Insert(Table table, Dialect dialect) {
        super(table, dialect);
    }

    public void putNameExpression(String string, String string2) {
        this.columnNameExpressionMap.put(string, string2);
    }

    public boolean isSelfincreaseColumn(String string) {
        return true;
    }

    public boolean isUpdate() {
        return false;
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (connection == null || this.getTable() == null) {
            return null;
        }
        if (this.dialect == null) {
            this.dialect = DialectFactory.getDefaultDialect();
        }
        IntList intList = new IntList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (DBUtils.isNULL(this.getColumnValue(i))) continue;
            arrayList.add(this.dialect.column2SQL(this.getColumnName(i)));
            arrayList2.add("?");
            intList.add(i);
        }
        Iterator iterator = this.columnNameExpressionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(this.dialect.column2SQL((String)entry.getKey()));
            arrayList2.add((String)entry.getValue());
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        String string = "INSERT INTO " + this.getTable().toStatementSQLString(this.dialect) + " (" + BaseCoreUtils.join(arrayList, ",") + ")" + " VALUES (" + BaseCoreUtils.join(arrayList2, ",") + ")";
        FRContext.getLogger().log(Level.INFO, string.toString());
        PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
        for (int i = 0; i < intList.size(); ++i) {
            int n2 = intList.get(i);
            DBUtils.applyColumnTypeValue(this.dialect, connection, this.getTable(), this.getColumnName(n2), preparedStatement, i + 1, this.getColumnType(n2), this.getColumnValue(n2));
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n = preparedStatement.executeUpdate();
                return n;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

