/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.FRContext;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Fragment;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class Select
extends AbstractDML
implements Fragment {
    private List selectColumnNameList = new ArrayList();
    private Where where;

    public Select(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Select(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Select(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.where = where;
    }

    public void addColumnName(String string) {
        if (string != null) {
            this.selectColumnNameList.add(string);
        }
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (connection == null) {
            FRContext.getLogger().log(Level.WARNING, "Connection can not be null.");
            return null;
        }
        if (this.getTable() == null) {
            FRContext.getLogger().log(Level.WARNING, "Table can not be null");
            return null;
        }
        if (!this.isEmptyWhereAllowed() && this.where == null) {
            FRContext.getLogger().log(Level.WARNING, "Where can not be null");
            return null;
        }
        String string = this.toStatementSQLString(this.dialect);
        FRContext.getLogger().log(Level.INFO, string.toString());
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, 1);
        }
        return preparedStatement;
    }

    public String noResultSQL() {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        stringBuffer.append(" where 1=2");
        return stringBuffer.toString();
    }

    public String toStatementSQLString(Dialect dialect) {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        if (this.where != null) {
            stringBuffer.append(this.where.toStatementSQLString(dialect));
        }
        return stringBuffer.toString();
    }

    public String toNormalSQLString(Dialect dialect) {
        if (this.getTable() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genTmpSelectSQLString());
        if (this.where != null) {
            stringBuffer.append(this.where.toNormalSQLString(dialect));
        }
        return stringBuffer.toString();
    }

    private String genTmpSelectSQLString() {
        String[] stringArray;
        int n;
        if (this.dialect == null) {
            this.dialect = DialectFactory.getDefaultDialect();
        }
        if ((n = this.selectColumnNameList.size()) == 0) {
            stringArray = new String[]{"*"};
        } else {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.dialect.column2SQL((String)this.selectColumnNameList.get(i));
            }
        }
        String string = this.getTable().toStatementSQLString(this.dialect);
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" ");
        string2 = stringBuffer.toString();
        String string3 = "SELECT" + string2 + "FROM " + string;
        return string3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        ArrayList arrayList = new ArrayList();
        Table table = new Table("James", "Table");
        Dialect dialect = DialectFactory.getDefaultDialect();
        int n = arrayList.size();
        if (n == 0) {
            stringArray2 = new String[]{"*"};
        } else {
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = dialect.column2SQL((String)arrayList.get(i));
            }
        }
        String string = table.toStatementSQLString(dialect);
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray2[i]);
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" ");
        string2 = stringBuffer.toString();
        String string3 = "SELECT" + string2 + "FROM " + string;
        System.out.println(string3);
    }
}

