/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;

public class Update
extends InsertOrUpdate {
    private Where where;

    public Update(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Update(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Update(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.where = where;
    }

    public boolean isUpdate() {
        return true;
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public static boolean validate(Update update) {
        return update != null && update.getColumnCount() > 0;
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        if (connection == null) {
            FRContext.getLogger().log(Level.WARNING, "Connection can not be null.");
            return null;
        }
        if (this.getTable() == null) {
            FRContext.getLogger().log(Level.WARNING, "Table can not be null");
            return null;
        }
        if (!Update.validate(this)) {
            FRContext.getLogger().log(Level.WARNING, "Update column can not be null");
            return null;
        }
        if (!this.isEmptyWhereAllowed() && this.where == null) {
            FRContext.getLogger().log(Level.WARNING, "Where can not be null");
            return null;
        }
        if (this.dialect == null) {
            this.dialect = DialectFactory.getDefaultDialect();
        }
        int n = this.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.dialect.column2SQL(this.getColumnName(i)) + "=?";
        }
        String string = this.getTable().toStatementSQLString(this.dialect);
        String string2 = "";
        String string3 = this.where == null ? "" : this.where.toStatementSQLString(this.dialect);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" ");
        string2 = stringBuffer.toString();
        String string4 = "UPDATE " + string + " SET" + string2 + string3;
        FRContext.getLogger().log(Level.INFO, string4);
        PreparedStatement preparedStatement = connection.prepareStatement(string4.toString());
        for (int i = 0; i < n; ++i) {
            DBUtils.applyColumnTypeValue(this.dialect, connection, this.getTable(), this.getColumnName(i), preparedStatement, i + 1, this.getColumnType(i), this.getColumnValue(i));
        }
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, n + 1);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n = preparedStatement.executeUpdate();
                return n;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

