/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.core.list.IntList;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Fragment;
import com.fr.data.core.db.dml.SQLUtils;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Where
implements Fragment {
    private List columnNameList = new ArrayList();
    private IntList columnTypeList = new IntList();
    private IntList compareTypeList = new IntList();
    private List columnValueList = new ArrayList();
    private IntList relationTypeList = new IntList();

    public void addColumn(String string, Object object) {
        this.addColumn(string, 12, 0, object, 0);
    }

    public void addColumn(String string, int n, int n2, Object object) {
        this.addColumn(string, n, n2, object, 0);
    }

    public void addColumn(String string, int n, int n2, Object object, int n3) {
        if (string != null) {
            if (this.getColumnSize() > 0) {
                this.relationTypeList.add(n3);
            }
            this.columnNameList.add(string);
            this.columnTypeList.add(n);
            this.compareTypeList.add(n2);
            this.columnValueList.add(object);
        }
    }

    public int getColumnSize() {
        return this.columnNameList == null ? 0 : this.columnNameList.size();
    }

    public static boolean validate(Where where) {
        return where != null && where.getColumnSize() > 0;
    }

    public String toStatementSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getColumnSize();
        if (n > 0) {
            stringBuffer.append(" WHERE ");
            String string = "=";
            String string2 = "?";
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    int n2 = this.relationTypeList.get(i - 1);
                    stringBuffer.append(n2 == 0 ? " AND " : " OR ");
                    int n3 = this.compareTypeList.get(i);
                    String[] stringArray = SQLUtils.getOPAndValueString(n3, string2);
                    string = stringArray[0];
                    string2 = stringArray[1];
                }
                stringBuffer.append(dialect.column2SQL((String)this.columnNameList.get(i)));
                stringBuffer.append(string);
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public int applyColumnTypeValue(Dialect dialect, Connection connection, Table table, PreparedStatement preparedStatement, int n) throws SQLException {
        if (preparedStatement == null || n <= 0) {
            return n;
        }
        int n2 = this.columnNameList.size();
        for (int i = 0; i < n2; ++i) {
            DBUtils.applyColumnTypeValue(dialect, connection, table, (String)this.columnNameList.get(i), preparedStatement, n + i, this.columnTypeList.get(i), this.columnValueList.get(i));
        }
        return n + n2;
    }

    public String toNormalSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        int n = this.columnNameList.size();
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(" WHERE ");
            String string = "=";
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2;
                int n3 = this.columnTypeList.get(i);
                int n4 = DBUtils.getColumnFRType(n3);
                if (n4 == DBConstants.FR_STREAM || (string2 = (String)this.columnValueList.get(i)).indexOf("'") != -1 || string2.indexOf("\"") != -1) continue;
                int n5 = n2 = this.relationTypeList.size() > 0 ? this.relationTypeList.get(i) : 0;
                if (bl) {
                    stringBuffer.append(n2 == 0 ? " AND " : " OR ");
                }
                bl = true;
                int n6 = this.compareTypeList.get(i);
                String[] stringArray = SQLUtils.getOPAndValueString(n6, string2);
                string = stringArray[0];
                string2 = stringArray[1];
                stringBuffer.append(dialect.column2SQL((String)this.columnNameList.get(i)));
                stringBuffer.append(string);
                if (n4 == DBConstants.FR_STRING) {
                    stringBuffer.append("'");
                    stringBuffer.append(string2);
                    stringBuffer.append("'");
                    continue;
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public void clearAllColumn() {
        this.columnNameList.clear();
        this.columnTypeList.clear();
        this.compareTypeList.clear();
        this.columnValueList.clear();
        this.relationTypeList.clear();
    }

    public String toString() {
        return this.toNormalSQLString(null);
    }
}

