/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreConstants;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.report.core.UploadedImage;
import com.fr.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class BlobTypeHandler
implements SQLTypeHandler {
    public void setValue(PreparedStatement preparedStatement, int n, Object object, int n2, Dialect dialect) throws SQLException {
        Object object2;
        byte[] byArray = new byte[]{};
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof InputStream || object instanceof Blob) {
            if (object instanceof Blob) {
                object = ((Blob)object).getBinaryStream();
            }
            try {
                int n3;
                object2 = new byte[32768];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n3 = ((InputStream)object).read((byte[])object2)) != -1) {
                    byteArrayOutputStream.write((byte[])object2, 0, n3);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
        } else if (object instanceof UploadedImage) {
            byArray = ((UploadedImage)object).getBytes();
        } else if (object instanceof BufferedImage) {
            object2 = new ByteArrayOutputStream();
            try {
                if (ImageIO.write((RenderedImage)((BufferedImage)object), "png", (OutputStream)object2)) {
                    byArray = ((ByteArrayOutputStream)object2).toByteArray();
                    ((ByteArrayOutputStream)object2).close();
                }
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
        } else {
            byArray = object instanceof BinaryObject ? ((BinaryObject)object).getBytes() : ("" + object).getBytes();
        }
        object2 = new ByteArrayInputStream(byArray);
        preparedStatement.setBinaryStream(n, (InputStream)object2, byArray.length);
    }

    public Object getValue(ResultSet resultSet, int n, int n2, Dialect dialect) throws SQLException {
        if (n2 == 2004) {
            return resultSet.getBlob(n);
        }
        try {
            return new BinaryObject(Utils.inputStream2Bytes(resultSet.getBinaryStream(n)));
        }
        catch (Throwable throwable) {
            return BaseCoreConstants.getDefaultImage();
        }
    }
}

