/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.base.core.DateUtils;
import com.fr.data.core.db.YearDate;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.handler.SQLTypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTypeHandler
implements SQLTypeHandler {
    public void setValue(PreparedStatement preparedStatement, int n, Object object, int n2, Dialect dialect) throws SQLException {
        if (object instanceof java.sql.Date) {
            preparedStatement.setDate(n, (java.sql.Date)object);
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, new java.sql.Date(((Date)object).getTime()));
        } else if (object instanceof String) {
            Date date = null;
            try {
                date = DateUtils.string2Date(object.toString(), true);
            }
            catch (Exception exception) {
                preparedStatement.setNull(n, n2);
                return;
            }
            if (date != null) {
                if (dialect instanceof OracleDialect) {
                    preparedStatement.setTimestamp(n, new Timestamp(date.getTime()));
                } else {
                    preparedStatement.setDate(n, new java.sql.Date(date.getTime()));
                }
            } else {
                preparedStatement.setString(n, object.toString());
            }
        } else if (object instanceof YearDate) {
            preparedStatement.setString(n, object.toString());
        }
    }

    public Object getValue(ResultSet resultSet, int n, int n2, Dialect dialect) throws SQLException {
        if (dialect instanceof OracleDialect) {
            return resultSet.getTimestamp(n);
        }
        return resultSet.getDate(n);
    }
}

