/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.data.core.db.handler.ArrayTypeHandler;
import com.fr.data.core.db.handler.BigDecimalTypeHandler;
import com.fr.data.core.db.handler.BlobTypeHandler;
import com.fr.data.core.db.handler.BooleanTypeHandler;
import com.fr.data.core.db.handler.ByteTypeHandler;
import com.fr.data.core.db.handler.ClobTypeHandler;
import com.fr.data.core.db.handler.DBTimestampTypeHandler;
import com.fr.data.core.db.handler.DateTypeHandler;
import com.fr.data.core.db.handler.DoubleTypeHandler;
import com.fr.data.core.db.handler.FloatTypeHandler;
import com.fr.data.core.db.handler.IntegerTypeHandler;
import com.fr.data.core.db.handler.LongTypeHandler;
import com.fr.data.core.db.handler.ObjectTypeHandler;
import com.fr.data.core.db.handler.RefTypeHandler;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.core.db.handler.ShortTypeHandler;
import com.fr.data.core.db.handler.StringTypeHandler;
import com.fr.data.core.db.handler.TimeTypeHandler;
import com.fr.data.core.db.handler.URLTypeHandler;
import com.fr.data.core.db.handler.UnknownTypeHandler;
import java.util.HashMap;
import java.util.Map;

public class SQLTypeHandlerFactory {
    private Map handlerMap = new HashMap();
    private final SQLTypeHandler unknownTypeHandler = new UnknownTypeHandler();
    private static SQLTypeHandlerFactory sqlTypeHandlerFactory = new SQLTypeHandlerFactory();

    private SQLTypeHandlerFactory() {
        this.register(2003, new ArrayTypeHandler());
        this.register(-5, new LongTypeHandler());
        this.register(-2, new BlobTypeHandler());
        this.register(2004, new BlobTypeHandler());
        this.register(-7, new BooleanTypeHandler());
        this.register(16, new BooleanTypeHandler());
        this.register(1, new StringTypeHandler());
        this.register(2005, new ClobTypeHandler());
        this.register(70, new URLTypeHandler());
        this.register(91, new DateTypeHandler());
        this.register(3, new BigDecimalTypeHandler());
        this.register(8, new DoubleTypeHandler());
        this.register(2001, new ObjectTypeHandler());
        this.register(6, new FloatTypeHandler());
        this.register(4, new IntegerTypeHandler());
        this.register(2000, new ObjectTypeHandler());
        this.register(-4, new BlobTypeHandler());
        this.register(-1, new ClobTypeHandler());
        this.register(2, new BigDecimalTypeHandler());
        this.register(7, new FloatTypeHandler());
        this.register(2006, new RefTypeHandler());
        this.register(5, new ShortTypeHandler());
        this.register(2002, new ObjectTypeHandler());
        this.register(92, new TimeTypeHandler());
        this.register(93, new DBTimestampTypeHandler());
        this.register(-6, new ByteTypeHandler());
        this.register(-3, new BlobTypeHandler());
        this.register(12, new StringTypeHandler());
        this.register(1111, new ClobTypeHandler());
    }

    public static SQLTypeHandlerFactory buildSQLTypeHanderFactory() {
        return sqlTypeHandlerFactory;
    }

    public void register(int n, SQLTypeHandler sQLTypeHandler) {
        this.handlerMap.put(new Integer(n), sQLTypeHandler);
    }

    public SQLTypeHandler getTypeHandler(Integer n) {
        if (this.handlerMap.get(n) == null) {
            return this.unknownTypeHandler;
        }
        return (SQLTypeHandler)this.handlerMap.get(n);
    }
}

