/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.tableObject;

import com.fr.base.FRContext;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.CreateTable;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.core.db.tableObject.TableObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractTableObject
implements TableObject {
    protected List columnsList = new ArrayList();

    public AbstractTableObject() {
        this.initColumns();
    }

    protected Column getColumn(int n) {
        return (Column)this.columnsList.get(n);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize) {
        this.addColumn(string, n, columnSize, true);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl) {
        this.addColumn(string, n, columnSize, bl, false);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl, boolean bl2) {
        this.addColumn(string, n, columnSize, bl, bl2, false, false);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Column column = new Column(string, n, columnSize, null, bl, bl2, bl3, bl4);
        this.columnsList.add(column);
    }

    public boolean checkExist(Connection connection) {
        Select select = new Select(this.getTable(), DialectFactory.generateDialect(connection)){

            public String toStatementSQLString(Dialect dialect) {
                return this.noResultSQL();
            }
        };
        select.setEmptyWhereAllowed(true);
        int n = this.columnsList.size();
        for (int i = 0; i < n; ++i) {
            select.addColumnName(this.getColumn(i).getName());
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            preparedStatement.executeQuery();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().log(Level.WARNING, sQLException2.getMessage(), sQLException2);
            }
            return false;
        }
        return true;
    }

    public void createTable(Connection connection) {
        if (this.checkExist(connection)) {
            return;
        }
        PreparedStatement preparedStatement = null;
        this.dropTable(connection);
        Dialect dialect = DialectFactory.generateDialect(connection);
        CreateTable createTable = new CreateTable(this.getTable(), dialect);
        int n = this.columnsList.size();
        for (int i = 0; i < n; ++i) {
            createTable.addColumn(this.getColumn(i));
        }
        createTable.setEmptyWhereAllowed(true);
        createTable.setCheckFilter(this.checkFilter());
        createTable.setForeignReference(this.foreignReference());
        try {
            preparedStatement = createTable.createPreparedStatement(connection);
            preparedStatement.execute();
            connection.commit();
            FRContext.getLogger().log(Level.WARNING, "Table " + this.getTable().getName() + " has been created successfully!");
            preparedStatement.close();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
        }
        if (dialect instanceof OracleDialect) {
            ((OracleDialect)dialect).createTrigger(connection);
        }
    }

    public void dropTable(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.prepareStatement("DROP TABLE " + DialectFactory.generateDialect(connection).column2SQL(this.getTable().getName()));
            statement.execute();
            FRContext.getLogger().log(Level.WARNING, "Table " + this.getTable().getName() + " has been deleted successfully");
            statement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().log(Level.WARNING, sQLException2.getMessage(), sQLException2);
            }
        }
    }

    public String checkFilter() {
        return null;
    }
}

