/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.tableObject;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.tableObject.ColumnSize;
import java.sql.Connection;

public class Column {
    private String name = "Column";
    private boolean isPrimaryKey = false;
    private Object defaultValue = null;
    private ColumnSize columnSize = new ColumnSize();
    private boolean allowNull = true;
    private int valueType = 12;
    private boolean selfIncrease = false;
    private boolean isForeignKey = false;

    public Column() {
    }

    public Column(String string, int n, ColumnSize columnSize) {
        this.setName(string);
        this.setValueType(n);
        this.setColumnSize(columnSize);
    }

    public Column(String string, int n, ColumnSize columnSize, Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setName(string);
        this.setValueType(n);
        this.setColumnSize(columnSize);
        this.setDefaultValue(object);
        this.setPrimaryKey(bl2);
        this.setAllowNull(bl);
        this.setForeignKey(bl3);
        this.setSelfIncrease(bl4);
    }

    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public void setForeignKey(boolean bl) {
        this.isForeignKey = bl;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public ColumnSize getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(ColumnSize columnSize) {
        this.columnSize = columnSize;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean bl) {
        this.allowNull = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int n) {
        this.valueType = n;
    }

    public boolean isSelfIncrease() {
        return this.selfIncrease;
    }

    public void setSelfIncrease(boolean bl) {
        this.selfIncrease = bl;
    }

    public String toSQL(Dialect dialect, Connection connection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = dialect.columnType2SQL(this.getValueType(), this.getColumnSize().toString());
        stringBuffer.append(dialect.column2SQL(this.getName())).append(" ");
        if (this.isSelfIncrease()) {
            stringBuffer.append(dialect.createSequence(connection, string, dialect.column2SQL(this.getName()), string2));
        } else {
            stringBuffer.append(string2).append(" ");
            if (this.getDefaultValue() != null) {
                stringBuffer.append("DEFAULT").append(" ");
                if (this.getDefaultValue() instanceof String) {
                    stringBuffer.append("'").append(this.getDefaultValue()).append("'");
                } else {
                    stringBuffer.append(this.getDefaultValue());
                }
            }
            stringBuffer.append(" ").append(this.isAllowNull() ? "NULL" : "NOT NULL");
        }
        return stringBuffer.toString();
    }
}

