/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.define;

import com.fr.base.FRContext;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.ChartData;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.define.ChartSummaryColumn;
import com.fr.data.core.define.FilterDefinition;
import com.fr.data.core.define.SortColumn;
import com.fr.data.impl.TableChartData;
import com.fr.data.util.SortOrder;
import com.fr.data.util.function.DataFunction;
import java.util.ArrayList;
import java.util.logging.Level;

public class ChartDataDefinition
implements FilterDefinition {
    public static final String XML_TAG = "ChartDataDefinition";
    private TableData tableData;
    private SortColumn[] onChangeColumnArray;
    private ChartSummaryColumn[] chartSummaryColumnArray;

    public ChartDataDefinition() {
    }

    public ChartDataDefinition(TableData tableData, SortColumn[] sortColumnArray, ChartSummaryColumn[] chartSummaryColumnArray) {
        this.setTableData(tableData);
        this.setOnChangeColumnArray(sortColumnArray);
        this.setChartSummaryColumnArray(chartSummaryColumnArray);
    }

    public ChartData createChartData() {
        int n;
        Cloneable cloneable;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tableData == null) {
            return null;
        }
        try {
            int n2 = this.tableData.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                String string = this.tableData.getColumnName(i);
                arrayList.add(DataUtils.getOnlyColumnName(arrayList, string));
            }
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<SortOrder> arrayList3 = new ArrayList<SortOrder>();
        if (this.onChangeColumnArray != null) {
            for (int i = 0; i < this.onChangeColumnArray.length; ++i) {
                cloneable = this.onChangeColumnArray[i];
                n = arrayList.indexOf(((SortColumn)cloneable).getName());
                if (n < 0) continue;
                arrayList2.add(new Integer(n));
                arrayList3.add(((SortColumn)cloneable).getSortOrder());
            }
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        cloneable = new ArrayList();
        if (this.chartSummaryColumnArray != null) {
            for (n = 0; n < this.chartSummaryColumnArray.length; ++n) {
                ChartSummaryColumn chartSummaryColumn = this.chartSummaryColumnArray[n];
                int n3 = arrayList.indexOf(chartSummaryColumn.getName());
                if (n3 < 0) continue;
                arrayList4.add(new Integer(n3));
                cloneable.add(chartSummaryColumn.getFunction());
            }
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        SortOrder[] sortOrderArray = new SortOrder[arrayList3.size()];
        arrayList3.toArray(sortOrderArray);
        int[] nArray2 = new int[arrayList4.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)arrayList4.get(i);
        }
        DataFunction[] dataFunctionArray = new DataFunction[cloneable.size()];
        cloneable.toArray(dataFunctionArray);
        return new TableChartData(this.tableData, nArray, sortOrderArray, nArray2, dataFunctionArray);
    }

    public SortColumn[] getOnChangeColumnArray() {
        return this.onChangeColumnArray;
    }

    public void setOnChangeColumnArray(SortColumn[] sortColumnArray) {
        this.onChangeColumnArray = sortColumnArray;
    }

    public ChartSummaryColumn[] getChartSummaryColumnArray() {
        return this.chartSummaryColumnArray;
    }

    public void setChartSummaryColumnArray(ChartSummaryColumn[] chartSummaryColumnArray) {
        this.chartSummaryColumnArray = chartSummaryColumnArray;
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            TableData tableData;
            String string = xMLableReader.getTagName();
            if (string.equals("RowColumnArray") || string.equals("ColumnColumnArray") || string.equals("ColColumnArray") || string.equals("OnChangeColumnArray")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("SortColumn")) {
                            SortColumn sortColumn = null;
                            String string = xMLableReader.getAttr("name");
                            if (string != null) {
                                sortColumn = new SortColumn(string);
                                if (ChartDataDefinition.this.onChangeColumnArray == null) {
                                    ChartDataDefinition.access$002(ChartDataDefinition.this, new SortColumn[]{sortColumn});
                                } else {
                                    SortColumn[] sortColumnArray = ChartDataDefinition.this.onChangeColumnArray;
                                    ChartDataDefinition.access$002(ChartDataDefinition.this, new SortColumn[sortColumnArray.length + 1]);
                                    System.arraycopy(sortColumnArray, 0, ChartDataDefinition.this.onChangeColumnArray, 0, sortColumnArray.length);
                                    ((ChartDataDefinition)ChartDataDefinition.this).onChangeColumnArray[sortColumnArray.length] = sortColumn;
                                }
                            }
                            xMLableReader.readXMLObject(new XMLObject(this, sortColumn){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void readXML(XMLableReader xMLableReader) {
                                    String string;
                                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("SortOrder") && (string = xMLableReader.getAttr("order")) != null) {
                                        SortOrder sortOrder = new SortOrder(Integer.parseInt(string));
                                        ((SortColumn)this.obj).setSortOrder(sortOrder);
                                    }
                                }
                            });
                        }
                    }
                });
            } else if (string.equals("ChartSummaryColumn")) {
                ChartSummaryColumn chartSummaryColumn = null;
                String string2 = xMLableReader.getAttr("name");
                if (string2 != null) {
                    chartSummaryColumn = new ChartSummaryColumn(string2);
                    if (this.chartSummaryColumnArray == null) {
                        this.chartSummaryColumnArray = new ChartSummaryColumn[]{chartSummaryColumn};
                    } else {
                        ChartSummaryColumn[] chartSummaryColumnArray = this.chartSummaryColumnArray;
                        this.chartSummaryColumnArray = new ChartSummaryColumn[chartSummaryColumnArray.length + 1];
                        System.arraycopy(chartSummaryColumnArray, 0, this.chartSummaryColumnArray, 0, chartSummaryColumnArray.length);
                        this.chartSummaryColumnArray[chartSummaryColumnArray.length] = chartSummaryColumn;
                    }
                }
                if ((string2 = xMLableReader.getAttr("function")) != null) {
                    try {
                        chartSummaryColumn.setFunction(DataXMLUtils.readXMLDataFunction(string2));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage(), exception);
                    }
                }
            } else if (string.equals("ChartSummaryColumnArray")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ChartSummaryColumn")) {
                            ChartSummaryColumn chartSummaryColumn = null;
                            String string = xMLableReader.getAttr("name");
                            if (string != null) {
                                chartSummaryColumn = new ChartSummaryColumn(string);
                                if (ChartDataDefinition.this.chartSummaryColumnArray == null) {
                                    ChartDataDefinition.access$102(ChartDataDefinition.this, new ChartSummaryColumn[]{chartSummaryColumn});
                                } else {
                                    ChartSummaryColumn[] chartSummaryColumnArray = ChartDataDefinition.this.chartSummaryColumnArray;
                                    ChartDataDefinition.access$102(ChartDataDefinition.this, new ChartSummaryColumn[chartSummaryColumnArray.length + 1]);
                                    System.arraycopy(chartSummaryColumnArray, 0, ChartDataDefinition.this.chartSummaryColumnArray, 0, chartSummaryColumnArray.length);
                                    ((ChartDataDefinition)ChartDataDefinition.this).chartSummaryColumnArray[chartSummaryColumnArray.length] = chartSummaryColumn;
                                }
                            }
                            if ((string = xMLableReader.getAttr("function")) != null) {
                                try {
                                    chartSummaryColumn.setFunction(DataXMLUtils.readXMLDataFunction(string));
                                }
                                catch (Exception exception) {
                                    throw new RuntimeException(exception.getMessage(), exception);
                                }
                            }
                        }
                    }
                });
            } else if ("TableData".equals(string) && (tableData = DataXMLUtils.readXMLTableData(xMLableReader)) != null) {
                this.setTableData(tableData);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.tableData != null) {
            DataXMLUtils.writeXMLTableData(xMLPrintWriter, this.tableData);
        }
        if (this.onChangeColumnArray != null) {
            xMLPrintWriter.startTAG("OnChangeColumnArray");
            for (n = 0; n < this.onChangeColumnArray.length; ++n) {
                xMLPrintWriter.startTAG("SortColumn").attr("name", this.onChangeColumnArray[n].getName());
                if (this.onChangeColumnArray[n].getSortOrder() != null) {
                    xMLPrintWriter.startTAG("SortOrder").attr("order", this.onChangeColumnArray[n].getSortOrder().getOrder()).end();
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (this.chartSummaryColumnArray != null) {
            xMLPrintWriter.startTAG("ChartSummaryColumnArray");
            for (n = 0; n < this.chartSummaryColumnArray.length; ++n) {
                xMLPrintWriter.startTAG("ChartSummaryColumn").attr("name", this.chartSummaryColumnArray[n].getName());
                if (this.chartSummaryColumnArray[n].getFunction() != null) {
                    xMLPrintWriter.attr("function", this.chartSummaryColumnArray[n].getFunction().getClass().getName());
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void reset() {
        this.tableData = null;
        this.onChangeColumnArray = null;
        this.chartSummaryColumnArray = null;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        Cloneable[] cloneableArray;
        Cloneable[] cloneableArray2;
        ChartDataDefinition chartDataDefinition = (ChartDataDefinition)super.clone();
        if (this.getOnChangeColumnArray() != null) {
            cloneableArray2 = this.getOnChangeColumnArray();
            cloneableArray = new SortColumn[cloneableArray2.length];
            for (n = 0; n < cloneableArray.length; ++n) {
                cloneableArray[n] = (SortColumn)((SortColumn)cloneableArray2[n]).clone();
            }
            chartDataDefinition.setOnChangeColumnArray((SortColumn[])cloneableArray);
        }
        if (this.getChartSummaryColumnArray() != null) {
            cloneableArray2 = this.getChartSummaryColumnArray();
            cloneableArray = new ChartSummaryColumn[cloneableArray2.length];
            for (n = 0; n < cloneableArray.length; ++n) {
                cloneableArray[n] = (ChartSummaryColumn)((ChartSummaryColumn)cloneableArray2[n]).clone();
            }
            chartDataDefinition.setChartSummaryColumnArray((ChartSummaryColumn[])cloneableArray);
        }
        return chartDataDefinition;
    }

    static /* synthetic */ SortColumn[] access$002(ChartDataDefinition chartDataDefinition, SortColumn[] sortColumnArray) {
        chartDataDefinition.onChangeColumnArray = sortColumnArray;
        return sortColumnArray;
    }

    static /* synthetic */ ChartSummaryColumn[] access$102(ChartDataDefinition chartDataDefinition, ChartSummaryColumn[] chartSummaryColumnArray) {
        chartDataDefinition.chartSummaryColumnArray = chartSummaryColumnArray;
        return chartSummaryColumnArray;
    }
}

