/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.define;

import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.define.DataSource;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DirectoryConnection;
import com.fr.report.parameter.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class FileDataSource
implements DataSource {
    private DirectoryConnection directoryConnection = null;
    private String filePath = null;

    public FileDataSource() {
    }

    public FileDataSource(DirectoryConnection directoryConnection, String string) {
        this.directoryConnection = directoryConnection;
        this.filePath = string;
    }

    public DirectoryConnection getDirectoryConnection() {
        return this.directoryConnection;
    }

    public void setDirectoryConnection(DirectoryConnection directoryConnection) {
        this.directoryConnection = directoryConnection;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public InputStream getSourceStream(Parameter[] parameterArray) throws Exception {
        if (this.directoryConnection == null || StringUtils.isBlank(this.filePath)) {
            return null;
        }
        File file = new File(this.directoryConnection.getLocation());
        if (!file.isDirectory() || this.filePath == null) {
            return null;
        }
        return new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getAbsolutePath(), this.filePath}));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            Connection connection;
            String string = xMLableReader.getTagName();
            if ("FilePath".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.filePath = string2.trim();
                }
            } else if ("Connection".equals(string) && (connection = DataXMLUtils.readXMLConnection(xMLableReader)) instanceof DirectoryConnection) {
                this.directoryConnection = (DirectoryConnection)connection;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.filePath != null) {
            xMLPrintWriter.startTAG("FilePath").textNode(this.getFilePath()).end();
        }
        if (this.directoryConnection != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.directoryConnection);
        }
    }

    public boolean equals(Object object) {
        return object instanceof FileDataSource && ComparatorUtils.equals(this.directoryConnection, ((FileDataSource)object).directoryConnection) && ComparatorUtils.equals(this.filePath, ((FileDataSource)object).filePath);
    }

    public Object clone() throws CloneNotSupportedException {
        FileDataSource fileDataSource = (FileDataSource)super.clone();
        if (this.directoryConnection != null) {
            fileDataSource.setDirectoryConnection((DirectoryConnection)this.directoryConnection.clone());
        }
        return fileDataSource;
    }
}

