/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.define;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.ListSet;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.ChartData;
import com.fr.data.ChartDataModel;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.define.TableDataDefinition;
import com.fr.data.impl.ReportChartData;
import com.fr.data.util.function.DataFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class OneValueCDDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = 2093363235824337628L;
    public static final String XML_TAG = "OneValueCDDefinition";
    private String seriesColumnName;
    private String valueColumnName;
    private DataFunction dataFunction = null;

    public OneValueCDDefinition() {
    }

    public OneValueCDDefinition(TableData tableData, String string, String string2, String string3, DataFunction dataFunction) {
        super(tableData, string);
        this.setSeriesColumnName(string2);
        this.setValueColumnName(string3);
        this.setDataFunction(dataFunction);
    }

    public void reset() {
        super.reset();
        this.seriesColumnName = null;
        this.setValueColumnName(null);
        this.dataFunction = null;
    }

    protected int createSeriesNameArray(List list) throws TableDataException {
        int n = -1;
        int n2 = this.tableData.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!ComparatorUtils.tableDataColumnNameEquals(this.tableData.getColumnName(i), this.getSeriesColumnName())) continue;
            ListSet listSet = new ListSet();
            n = i;
            int n4 = this.tableData.getRowCount();
            for (n3 = 0; n3 < n4; ++n3) {
                Object object = this.tableData.getValueAt(n3, i);
                listSet.add(object);
            }
            for (n3 = 0; n3 < listSet.size(); ++n3) {
                list.add(listSet.get(n3));
            }
        }
        return n;
    }

    public ChartData createChartData() {
        if (this.tableData == null) {
            return ChartDataModel.defaultChartData;
        }
        ReportChartData reportChartData = ChartDataModel.defaultChartData;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object> arrayList2 = null;
        try {
            int n;
            int n2;
            ArrayList arrayList3 = new ArrayList();
            int n3 = this.createCategoryNameArray(arrayList3);
            Object[] objectArray = arrayList3.toArray();
            ArrayList arrayList4 = new ArrayList();
            int n4 = this.createSeriesNameArray(arrayList4);
            Object[] objectArray2 = arrayList4.toArray();
            int n5 = this.tableData.getColumnCount();
            int n6 = -1;
            for (n2 = 0; n2 < n5; ++n2) {
                if (!ComparatorUtils.tableDataColumnNameEquals(this.tableData.getColumnName(n2), this.getValueColumnName())) continue;
                n6 = n2;
            }
            n2 = this.tableData.getRowCount();
            DataFunction dataFunction = this.getDataFunction();
            if (n3 == -1) {
                if (arrayList3 != null && arrayList3.toArray().length == 1) {
                    int n7 = objectArray2.length;
                    for (n = 0; n < n7; ++n) {
                        arrayList2 = new ArrayList();
                        for (int i = 0; i < n2; ++i) {
                            if (!this.tableData.getValueAt(i, n4).equals(objectArray2[n])) continue;
                            dataFunction.addData(this.tableData.getValueAt(i, n6));
                        }
                        arrayList2.add(dataFunction.getResult());
                        dataFunction.reset();
                        arrayList.add(arrayList2.toArray());
                    }
                }
            } else {
                int n8 = objectArray2.length;
                for (n = 0; n < n8; ++n) {
                    arrayList2 = new ArrayList<Object>();
                    int n9 = objectArray.length;
                    for (int i = 0; i < n9; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            if (!this.tableData.getValueAt(j, n3).equals(objectArray[i]) || !this.tableData.getValueAt(j, n4).equals(objectArray2[n])) continue;
                            dataFunction.addData(this.tableData.getValueAt(j, n6));
                        }
                        arrayList2.add(dataFunction.getResult());
                        dataFunction.reset();
                    }
                    arrayList.add(arrayList2.toArray());
                }
            }
            Object[][] objectArray3 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
            reportChartData = new ReportChartData(objectArray, objectArray2, objectArray3);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        try {
            this.tableData.release();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return reportChartData;
    }

    public void setSeriesColumnName(String string) {
        this.seriesColumnName = string;
    }

    public String getSeriesColumnName() {
        return this.seriesColumnName;
    }

    public void setValueColumnName(String string) {
        this.valueColumnName = string;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setDataFunction(DataFunction dataFunction) {
        this.dataFunction = dataFunction;
    }

    public DataFunction getDataFunction() {
        return this.dataFunction;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.seriesColumnName != null) {
            xMLPrintWriter.attr("seriesName", this.seriesColumnName);
        }
        if (this.getValueColumnName() != null) {
            xMLPrintWriter.attr("valueName", this.getValueColumnName());
        }
        if (this.getDataFunction() != null) {
            xMLPrintWriter.attr("function", this.getDataFunction().getClass().getName());
        }
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            String string3 = xMLableReader.getAttr("seriesName");
            if (string3 != null) {
                this.seriesColumnName = string3;
            }
            if ((string3 = xMLableReader.getAttr("valueName")) != null) {
                this.setValueColumnName(string3);
            }
            if ((string3 = xMLableReader.getAttr("function")) != null) {
                try {
                    this.setDataFunction(DataXMLUtils.readXMLDataFunction(string3));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            }
        } else if (xMLableReader.isChildNode() && "SeriesColumn".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getAttr(string2)) != null) {
            this.seriesColumnName = string;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OneValueCDDefinition oneValueCDDefinition = (OneValueCDDefinition)super.clone();
        if (this.getDataFunction() != null) {
            oneValueCDDefinition.setDataFunction((DataFunction)this.getDataFunction().clone());
        }
        return oneValueCDDefinition;
    }
}

