/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.define;

import com.fr.base.FCloneable;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.define.FilterDefinition;
import com.fr.data.core.define.TopDefinition;
import com.fr.report.io.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.List;

public class ReportDataDefinition
extends TopDefinition
implements FilterDefinition {
    private static final long serialVersionUID = -7944306985328284088L;
    public static final String XML_TAG = "ReportDataDefinition";
    public static final int SERIES_IN_COLUMN = 0;
    public static final int SERIES_IN_ROW = 1;
    private boolean baseOnDataValueArea = false;
    private String seriesValueString = null;
    private String seriesNameString = null;
    private int seriesPos = 1;
    private String categoryNameString = null;
    private List seriesList = new ArrayList();

    public void setSeriesPos(int n) {
        this.seriesPos = n;
    }

    public int getSeriesPos() {
        return this.seriesPos;
    }

    public void setSeriesValueString(String string) {
        this.seriesValueString = string;
    }

    public String getSeriesValueString() {
        return this.seriesValueString;
    }

    public void setCategoryNameString(String string) {
        this.categoryNameString = string;
    }

    public String getCategoryNameString() {
        return this.categoryNameString;
    }

    public void setSeriesNameString(String string) {
        this.seriesNameString = string;
    }

    public String getSeriesNameString() {
        return this.seriesNameString;
    }

    public void setSeriesList(List list) {
        this.seriesList = list;
    }

    public List getSeriesList() {
        return this.seriesList;
    }

    public void setBaseOnDataValueArea(boolean bl) {
        this.baseOnDataValueArea = bl;
    }

    public boolean isBaseOnDataValueArea() {
        return this.baseOnDataValueArea;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("CategoryDefinition") || string.equals("CategoryDefintion")) {
                String string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    this.setCategoryNameString(string2);
                }
            } else if (string.equals("SeriesDefinition")) {
                String string3 = xMLableReader.getAttr("name");
                if (string3 != null) {
                    this.setSeriesNameString(string3);
                }
                if ((string3 = xMLableReader.getAttr("value")) != null) {
                    this.setSeriesValueString(string3);
                }
            } else if (string.equals("SeriesPos")) {
                String string4 = xMLableReader.getAttr("value");
                if (string4 != null) {
                    this.setSeriesPos(Integer.parseInt(string4));
                }
            } else if (string.equals("BaseOn")) {
                String string5 = xMLableReader.getAttr("value");
                if (string5 != null) {
                    this.setBaseOnDataValueArea(Boolean.valueOf(string5));
                }
            } else if (string.equals("SeriesList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "SeriesEntry".equals(xMLableReader.getTagName())) {
                            ReportDataDefinition.this.getSeriesList().add(xMLableReader.readXMLObject(new SeriesEntry()));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotBlank(this.getCategoryNameString())) {
            xMLPrintWriter.startTAG("CategoryDefinition").attr("value", this.getCategoryNameString()).end();
        }
        if (StringUtils.isNotBlank(this.getSeriesValueString())) {
            xMLPrintWriter.startTAG("SeriesDefinition");
            if (StringUtils.isNotBlank(this.getSeriesNameString())) {
                xMLPrintWriter.attr("name", this.getSeriesNameString());
            }
            xMLPrintWriter.attr("value", this.getSeriesValueString());
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("SeriesPos").attr("value", this.getSeriesPos()).end();
        xMLPrintWriter.startTAG("BaseOn").attr("value", this.isBaseOnDataValueArea()).end();
        if (this.getSeriesList() != null && this.getSeriesList().size() > 0) {
            xMLPrintWriter.startTAG("SeriesList");
            for (int i = 0; i < this.getSeriesList().size(); ++i) {
                ((SeriesEntry)this.getSeriesList().get(i)).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportDataDefinition reportDataDefinition = (ReportDataDefinition)super.clone();
        reportDataDefinition.setCategoryNameString(this.getCategoryNameString());
        reportDataDefinition.setSeriesValueString(this.getSeriesValueString());
        reportDataDefinition.setSeriesNameString(this.getSeriesNameString());
        reportDataDefinition.setSeriesPos(this.getSeriesPos());
        return reportDataDefinition;
    }

    public static class SeriesEntry
    implements XMLable {
        private String seriesName;
        private Object value;

        public SeriesEntry() {
        }

        public SeriesEntry(String string, Object object) {
            this.seriesName = string;
            this.value = object;
        }

        public void setSeriesName(String string) {
            this.seriesName = string;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (xMLableReader.isAttr() && (string = xMLableReader.getAttr("name")) != null) {
                this.seriesName = string;
            }
            if (xMLableReader.isChildNode() && "O".equals(xMLableReader.getTagName())) {
                this.value = ReportXMLUtils.readObject(xMLableReader);
            }
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("SeriesEntry").attr("name", this.seriesName);
            ReportXMLUtils.writeObject(xMLPrintWriter, this.value);
            xMLPrintWriter.end();
        }

        public Object clone() throws CloneNotSupportedException {
            SeriesEntry seriesEntry = (SeriesEntry)super.clone();
            if (this.value instanceof FCloneable) {
                seriesEntry.value = ((FCloneable)this.value).clone();
            }
            return seriesEntry;
        }
    }
}

