/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.define;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.ListSet;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.ChartData;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.define.FilterDefinition;
import com.fr.data.core.define.TopDefinition;
import java.util.List;

public abstract class TableDataDefinition
extends TopDefinition
implements FilterDefinition {
    private static final long serialVersionUID = 6650119421972084763L;
    protected TableData tableData;
    protected String categoryName;

    public TableDataDefinition() {
    }

    public TableDataDefinition(TableData tableData, String string) {
        this.tableData = tableData;
        this.categoryName = string;
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void reset() {
        this.tableData = null;
        this.categoryName = null;
    }

    protected int createCategoryNameArray(List list) throws TableDataException {
        int n = -1;
        int n2 = this.tableData.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!ComparatorUtils.tableDataColumnNameEquals(this.tableData.getColumnName(i), this.categoryName)) continue;
            ListSet listSet = new ListSet();
            n = i;
            int n4 = this.tableData.getRowCount();
            for (n3 = 0; n3 < n4; ++n3) {
                Object object = this.tableData.getValueAt(n3, i);
                listSet.add(object);
            }
            for (n3 = 0; n3 < listSet.size(); ++n3) {
                list.add(listSet.get(n3));
            }
        }
        if (this.categoryName != null && n == -1) {
            list.add(this.categoryName);
        }
        return n;
    }

    public abstract ChartData createChartData();

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.tableData != null) {
            DataXMLUtils.writeXMLTableData(xMLPrintWriter, this.tableData);
        }
        if (this.categoryName != null) {
            xMLPrintWriter.startTAG("CategoryName").attr("value", this.categoryName).end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("TableData".equals(string2)) {
                TableData tableData = DataXMLUtils.readXMLTableData(xMLableReader);
                if (tableData != null) {
                    this.setTableData(tableData);
                }
            } else if ("CategoryName".equals(string2) && (string = xMLableReader.getAttr("value")) != null) {
                this.setCategoryName(string);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

