/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.file.DatasourceManager;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Semantic;
import com.fr.data.TableData;
import com.fr.data.impl.ADHOCTableData;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;

public class ADHOCSQLTableData
extends ADHOCTableData {
    public static int TYPE = 1;
    private String dbConnectionName = null;
    private String query = null;

    public ADHOCSQLTableData() {
    }

    public ADHOCSQLTableData(String string, String string2, String string3, Semantic semantic) {
        this.dbConnectionName = string;
        this.query = string2;
        this.setDescription(string3);
        this.setSemantic(semantic);
    }

    protected TableData createTableData() {
        if (this.dt == null) {
            DatasourceManager datasourceManager = FRContext.getDatasourceManager();
            if (StringUtils.isNotEmpty(this.query) && StringUtils.isNotEmpty(this.dbConnectionName)) {
                this.dt = new DBTableData((DatabaseConnection)datasourceManager.getConnection(this.dbConnectionName), this.query);
            }
        }
        return this.dt;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void setDbConnectionName(String string) {
        this.dbConnectionName = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DBConnectionName".equals(string)) {
                this.setDbConnectionName(xMLableReader.getElementValue());
            } else if ("Query".equals(string)) {
                this.setQuery(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.dbConnectionName)) {
            xMLPrintWriter.startTAG("DBConnectionName").textNode(this.dbConnectionName).end();
        }
        if (StringUtils.isNotEmpty(this.query)) {
            xMLPrintWriter.startTAG("Query").textNode(this.query).end();
        }
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        super.parseJSON(jSONObject);
        if (jSONObject.has("dbConnectionName")) {
            this.setDbConnectionName(jSONObject.getString("dbConnectionName"));
        }
        if (jSONObject.has("query")) {
            this.setQuery(jSONObject.getString("query"));
        }
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        jSONObject.put("type", TYPE);
        if (StringUtils.isNotEmpty(this.dbConnectionName)) {
            jSONObject.put("dbConnectionName", this.getDbConnectionName());
        }
        if (StringUtils.isNotEmpty(this.query)) {
            jSONObject.put("query", this.getQuery());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof ADHOCSQLTableData && ComparatorUtils.equals(this.dbConnectionName, ((ADHOCSQLTableData)object).dbConnectionName) && ComparatorUtils.equals(this.query, ((ADHOCSQLTableData)object).query) && ComparatorUtils.equals(this.getDescription(), ((ADHOCSQLTableData)object).getDescription()) && ComparatorUtils.equals(this.getSemantic(), ((ADHOCSQLTableData)object).getSemantic());
    }

    public Object clone() throws CloneNotSupportedException {
        ADHOCSQLTableData aDHOCSQLTableData = (ADHOCSQLTableData)super.clone();
        aDHOCSQLTableData.setDbConnectionName(this.dbConnectionName);
        aDHOCSQLTableData.setQuery(this.query);
        return aDHOCSQLTableData;
    }
}

