/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.Semantic;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.adhoc.TransJSON;
import com.fr.report.script.Calculator;

public abstract class ADHOCTableData
extends AbstractTableData
implements TransJSON {
    private Semantic semantic = null;
    private String description = null;
    protected TableData dt = null;

    public ADHOCTableData() {
    }

    public ADHOCTableData(String string, Semantic semantic) {
        this.description = string;
        this.setSemantic(semantic);
    }

    protected abstract TableData createTableData();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Semantic getSemantic() {
        return this.semantic;
    }

    public void setSemantic(Semantic semantic) {
        this.semantic = semantic;
    }

    public int getColumnCount() throws TableDataException {
        return this.createTableData().getColumnCount();
    }

    public String getColumnName(int n) throws TableDataException {
        Object object;
        String string = this.createTableData().getColumnName(n);
        if (this.getSemantic() != null && (object = this.getSemantic().getSemanticName(string, Calculator.createCalculator())) != null) {
            return object.toString();
        }
        return string;
    }

    public int getRowCount() throws TableDataException {
        return this.createTableData().getRowCount();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.createTableData().getValueAt(n, n2);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Description".equals(string)) {
                this.setDescription(xMLableReader.getElementValue());
            } else if ("Semantic".equals(string)) {
                this.semantic = new Semantic();
                xMLableReader.readXMLObject(this.semantic);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotEmpty(this.description)) {
            xMLPrintWriter.startTAG("Description").textNode(this.description).end();
        }
        if (this.semantic != null) {
            xMLPrintWriter.startTAG("Semantic");
            this.semantic.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("description")) {
            this.setDescription(jSONObject.getString("description"));
        }
        if (jSONObject.has("semantic")) {
            Semantic semantic = new Semantic();
            semantic.parseJSON(jSONObject.getJSONObject("semantic"));
            this.setSemantic(semantic);
        }
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        if (StringUtils.isNotEmpty(this.description)) {
            jSONObject.put("description", this.getDescription());
        }
        if (this.semantic != null) {
            jSONObject.put("semantic", this.semantic.createJSON());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof ADHOCTableData && ComparatorUtils.equals(this.description, ((ADHOCTableData)object).description) && ComparatorUtils.equals(this.semantic, ((ADHOCTableData)object).semantic);
    }

    public Object clone() throws CloneNotSupportedException {
        ADHOCTableData aDHOCTableData = (ADHOCTableData)super.clone();
        aDHOCTableData.setDescription(this.description);
        if (this.getSemantic() != null) {
            aDHOCTableData.setSemantic((Semantic)this.getSemantic().clone());
        }
        return aDHOCTableData;
    }
}

