/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.DiskCacheAdapter;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.MemCachedAdapter;
import com.fr.data.impl.TableDataAdapter;
import com.fr.report.core.ParameterHelper;
import com.fr.report.core.cal.SheetExecuter;
import com.fr.report.core.cal.SynchronizedSEList;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.util.Consts;
import com.fr.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;

public class DBTableData
extends AbstractTableData
implements XMLable {
    private static boolean shareAvailable = true;
    private DatabaseConnection database;
    private String query;
    private int resultIndexOfOut;
    private boolean share = false;
    private transient TableDataAdapter adapter;
    private int maxMemRowCount = -1;
    private String pageQuerySql = null;

    public int getResultIndexOfOut() {
        return this.resultIndexOfOut;
    }

    public void setResultIndexOfOut(int n) {
        this.resultIndexOfOut = n;
    }

    public DBTableData() {
        this("sun.jdbc.odbc.JdbcOdbcDriver", "", "", "", "");
    }

    public DBTableData(String string, String string2, String string3, String string4, String string5) {
        this(new JDBCDatabaseConnection(string, string2, string3, string4), string5);
    }

    public DBTableData(DatabaseConnection databaseConnection, String string) {
        this.setDatabase(databaseConnection);
        this.setQuery(string);
    }

    public DatabaseConnection getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseConnection databaseConnection) {
        this.database = databaseConnection;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPageQuerySql() {
        return this.pageQuerySql;
    }

    public void setPageQuerySql(String string) {
        this.pageQuerySql = string;
    }

    public int getMaxMemRowCount() {
        return this.maxMemRowCount;
    }

    public void setMaxMemRowCount(int n) {
        this.maxMemRowCount = n;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean isShareTableData() {
        return shareAvailable && this.share;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    private TableDataAdapter createAdapter() {
        if (this.adapter == null) {
            String string = this.getNewQuery();
            SheetExecuter sheetExecuter = SynchronizedSEList.getSheetExecuter(Thread.currentThread());
            this.adapter = sheetExecuter != null ? sheetExecuter.createDBTableDataAdapter(this, string) : SheetExecuter.createDefaultDBTableDataAdapter(this, string);
        }
        return this.adapter;
    }

    public static TableDataAdapter createCacheableAdapter(DatabaseConnection databaseConnection, String string, int n, long l) {
        TableDataAdapter tableDataAdapter = new DiskCacheAdapter(databaseConnection, string, n);
        if (l < 0L || (long)tableDataAdapter.shortcutGetRowCount() < l) {
            tableDataAdapter = new MemCachedAdapter(databaseConnection, string, n);
        }
        return tableDataAdapter;
    }

    protected String getNewQuery() {
        String string = ParameterHelper.analyzeCurrentContextTableData4Templatee(this.getQuery(), this.parameters);
        return string;
    }

    public int getColumnCount() throws TableDataException {
        return this.createAdapter().getColumnCount();
    }

    public String getColumnName(int n) throws TableDataException {
        String string = this.createAdapter().getColumnName(n);
        return string;
    }

    public boolean hasRow(int n) throws TableDataException {
        return this.createAdapter().hasRow(n);
    }

    public int getRowCount() throws TableDataException {
        return this.createAdapter().getRowCount();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.createAdapter().getValueAt(n, n2);
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("share");
                if (string2 != null) {
                    this.setShare(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("maxMemRowCount")) != null) {
                    this.setMaxMemRowCount(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("indexOfO")) != null) {
                    this.setResultIndexOfOut(Integer.parseInt(string2));
                }
            } else if ("Connection".equals(string) || "Database".equals(string)) {
                if (xMLableReader.getAttr("class") != null) {
                    Connection connection = DataXMLUtils.readXMLConnection(xMLableReader);
                    if (connection instanceof DatabaseConnection) {
                        this.setDatabase((DatabaseConnection)connection);
                    }
                } else {
                    JDBCDatabaseConnection jDBCDatabaseConnection = new JDBCDatabaseConnection();
                    this.setDatabase(jDBCDatabaseConnection);
                    String string3 = xMLableReader.getAttr("driver");
                    if (string3 != null) {
                        jDBCDatabaseConnection.setDriver(string3);
                    }
                    if ((string3 = xMLableReader.getAttr("url")) != null) {
                        jDBCDatabaseConnection.setURL(string3);
                    }
                    if ((string3 = xMLableReader.getAttr("user")) != null) {
                        jDBCDatabaseConnection.setUser(string3);
                    }
                    if ((string3 = xMLableReader.getAttr("password")) != null) {
                        jDBCDatabaseConnection.setPassword(ReportXMLUtils.unPasswordString(string3));
                    }
                }
            } else if ("Query".equals(string)) {
                Parameter[] parameterArray;
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.setQuery(string4);
                }
                if ((parameterArray = this.getParameters()) != null && parameterArray.length > 0) {
                    for (int i = 0; i < parameterArray.length; ++i) {
                        Parameter parameter = parameterArray[i];
                        this.query = Utils.replaceAllString(this.query, "[?" + parameter.getName() + "?]", "[?" + parameter.getName() + "|" + parameter.getValue() + "?]");
                    }
                }
            } else if ("PageQuery".equals(string)) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    this.setPageQuerySql(string5);
                }
            } else if ("JDBCDatabase".equals(string)) {
                JDBCDatabaseConnection jDBCDatabaseConnection = new JDBCDatabaseConnection();
                xMLableReader.readXMLObject(jDBCDatabaseConnection);
                this.setDatabase(jDBCDatabaseConnection);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attributes");
        if (this.share) {
            xMLPrintWriter.attr("share", this.share);
        }
        if (this.resultIndexOfOut > 0) {
            xMLPrintWriter.attr("indexOfO", this.resultIndexOfOut);
        }
        xMLPrintWriter.attr("maxMemRowCount", this.getMaxMemRowCount()).end();
        if (this.database != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        if (this.pageQuerySql != null) {
            xMLPrintWriter.startTAG("PageQuery").textNode(this.pageQuerySql).end();
        }
    }

    public void release() throws Exception {
        if (this.adapter != null) {
            this.adapter.unRegister(this);
            this.adapter.tryDestroy();
            this.adapter = null;
        }
    }

    public String toString() {
        return this.database + "[Query:" + this.getQuery() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        DBTableData dBTableData = new DBTableData();
        dBTableData.setDatabase(this.getDatabase());
        dBTableData.parameters = ParameterHelper.cloneParameters(this.getParameters());
        dBTableData.setQuery(this.getQuery());
        dBTableData.setMaxMemRowCount(this.getMaxMemRowCount());
        dBTableData.setPageQuerySql(this.getPageQuerySql());
        dBTableData.setResultIndexOfOut(this.getResultIndexOfOut());
        return dBTableData;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public boolean equals(Object object) {
        return object instanceof DBTableData && super.equals(object) && ComparatorUtils.equals(this.query, ((DBTableData)object).query) && ComparatorUtils.equals(this.database, ((DBTableData)object).database) && this.maxMemRowCount == ((DBTableData)object).maxMemRowCount && ComparatorUtils.equals(this.pageQuerySql, ((DBTableData)object).pageQuerySql);
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            shareAvailable = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.PERFORMCE_OPTIMISE.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

