/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataUtils;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.report.script.Calculator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DatabaseDictionary
extends FormulaDisplayDictionary {
    protected DatabaseConnection databaseConnection;
    protected String tableName;
    protected String schema;
    private transient List kvs;

    public DatabaseDictionary() {
        this(new JDBCDatabaseConnection(), "", 1, 2);
    }

    public DatabaseDictionary(DatabaseConnection databaseConnection, String string, int n, int n2) {
        this.setDatabaseConnection(databaseConnection);
        this.setTableName(string);
        this.setKeyColumnIndex(n);
        this.setValueColumnIndex(n2);
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
        this.kvs = null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        this.kvs = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
        this.kvs = null;
    }

    public int getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    public void setKeyColumnIndex(int n) {
        if (this.keyColumnIndex != n) {
            this.keyColumnIndex = n;
            this.kvs = null;
        }
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void setValueColumnIndex(int n) {
        if (this.valueColumnIndex != n) {
            this.valueColumnIndex = n;
            this.kvs = null;
        }
    }

    public void reset() {
        this.kvs = null;
    }

    private void createKVS(Calculator calculator) {
        if (this.kvs == null) {
            this.kvs = this.databaseConnection != null ? this.createMVList(new DBTableData(this.databaseConnection, DataUtils.createSelectSQL(this.schema, this.tableName)), calculator) : Collections.EMPTY_LIST;
        }
    }

    public Object get(Object object, Calculator calculator) {
        this.createKVS(calculator);
        int n = this.kvs.size();
        for (int i = 0; i < n; ++i) {
            Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i);
            if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    public String[] getDependence() {
        return new String[0];
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DBDictAttr".equals(string) || "DBMapAttr".equals(string) || "JDBCMapAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("tableName");
                if (string2 != null) {
                    this.setTableName(string2);
                }
                if ((string2 = xMLableReader.getAttr("schemaName")) != null) {
                    this.setSchema(string2);
                }
                if ((string2 = xMLableReader.getAttr("ki")) != null) {
                    this.setKeyColumnIndex(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("vi")) != null) {
                    this.setValueColumnIndex(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("keyColumnIndex")) != null) {
                    this.setKeyColumnIndex(Integer.parseInt(string2) - 1);
                }
                if ((string2 = xMLableReader.getAttr("valueColumnIndex")) != null) {
                    this.setValueColumnIndex(Integer.parseInt(string2) - 1);
                }
            } else if ("Connection".equals(string) || "Database".equals(string)) {
                Connection connection = DataXMLUtils.readXMLConnection(xMLableReader);
                if (connection instanceof DatabaseConnection) {
                    this.setDatabaseConnection((DatabaseConnection)connection);
                }
            } else if ("JDBCDatabase".equals(string)) {
                JDBCDatabaseConnection jDBCDatabaseConnection = new JDBCDatabaseConnection();
                xMLableReader.readXMLObject(jDBCDatabaseConnection);
                this.setDatabaseConnection(jDBCDatabaseConnection);
            } else if ("Condition".equals(string)) {
                Condition condition = DataXMLUtils.readCondition(xMLableReader);
                this.setCondition(condition);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DBDictAttr").attr("tableName", this.getTableName()).attr("schemaName", this.getSchema()).attr("ki", this.getKeyColumnIndex()).attr("vi", this.getValueColumnIndex()).end();
        if (this.getDatabaseConnection() != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.getDatabaseConnection());
        }
        if (this.condition != null) {
            DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DatabaseDictionary databaseDictionary = (DatabaseDictionary)super.clone();
        if (this.databaseConnection != null) {
            this.databaseConnection = (DatabaseConnection)this.getDatabaseConnection().clone();
        }
        if (this.condition != null) {
            databaseDictionary.condition = (Condition)this.condition.clone();
        }
        return databaseDictionary;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DatabaseDictionary)) {
            return false;
        }
        return super.equals(object) && this.keyColumnIndex == ((DatabaseDictionary)object).keyColumnIndex && this.valueColumnIndex == ((DatabaseDictionary)object).valueColumnIndex && ComparatorUtils.equals(this.condition, ((DatabaseDictionary)object).condition);
    }

    public String toString() {
        return "DBDictionary" + this.databaseConnection + "[TableName:" + this.getTableName() + "]";
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("keyIndex", this.getKeyColumnIndex());
        jSONObject.put("valueIndex", this.getValueColumnIndex());
        jSONObject.put("databaseName", ((NameDatabaseConnection)this.databaseConnection).getName());
        jSONObject.put("tableName", this.tableName);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("keyIndex")) {
            this.setKeyColumnIndex(jSONObject.getInt("keyIndex"));
        }
        if (jSONObject.has("valueIndex")) {
            this.setValueColumnIndex(jSONObject.getInt("valueIndex"));
        }
        if (jSONObject.has("databaseName")) {
            this.setDatabaseConnection(new NameDatabaseConnection(jSONObject.getString("databaseName")));
        }
        if (jSONObject.has("tableName")) {
            this.setTableName(jSONObject.getString("tableName"));
        }
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < DatabaseDictionary.this.kvs.size();
        }

        public Object next() {
            Object e = DatabaseDictionary.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

