/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.core.list.MBBTable;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import java.sql.SQLException;
import java.util.logging.Level;

public final class DiskCacheAdapter
extends TableDataAdapter {
    private transient MBBTable mbb_table = null;

    public DiskCacheAdapter(DatabaseConnection databaseConnection, String string, int n) {
        super(databaseConnection, string, n);
    }

    protected void initRowValueStatus() {
        try {
            this.checkInColumn();
            this.mbb_table = new MBBTable(this.getColumnCount(), this.shortcutGetRowCount());
        }
        catch (TableDataException tableDataException) {
            tableDataException.printStackTrace();
        }
    }

    protected synchronized boolean hasRow(int n) throws TableDataException {
        if (this.mbb_table != null && this.mbb_table.columnCount() > 0 && this.mbb_table.rowCount() > n) {
            return true;
        }
        if (this.isCheckRowOver) {
            return false;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.connection == null) {
            return false;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n2 = this.getColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        int n3 = this.mbb_table.rowCount();
        try {
            while (this.resultSet.next()) {
                for (int i = 0; i < n2; ++i) {
                    try {
                        this.mbb_table.addValueAt(i, DataUtils.getResultSetObject(this.resultSet, this.columnInformations[i].getColumnType(), i + 1, string, string2, dialect));
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.mbb_table.addValueAt(i, null);
                    }
                }
                if (++n3 <= n) continue;
                return true;
            }
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                FRContext.getLogger().log(Level.WARNING, "Error happens while releaseConnection");
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "\nQuery is:" + this.sql + "\nrowIndex to get is:" + n, exception);
        }
        return n3 > n;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.hasRow(n) ? this.mbb_table.getValueAt(n2, n) : null;
    }

    public int getRowCount() throws TableDataException {
        this.hasRow(Integer.MAX_VALUE);
        return this.mbb_table.rowCount();
    }

    protected void release() throws SQLException {
        if (this.mbb_table != null) {
            this.mbb_table.clear();
        }
        super.release();
    }
}

