/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.report.core.ParameterHelper;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicSQLDict
extends FormulaDisplayDictionary {
    private DatabaseConnection databaseConnection;
    private String sqlFormula;
    private transient List kvs;
    private transient Map cachedKVMap;

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setSqlFormula(String string) {
        this.sqlFormula = string;
    }

    public String getSqlFormula() {
        return this.sqlFormula;
    }

    public Object get(Object object, Calculator calculator) {
        this.createKVS(calculator);
        return this.cachedKVMap.get(object);
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public void reset() {
        this.kvs = null;
        this.cachedKVMap = null;
    }

    private void createKVS(Calculator calculator) {
        if (this.kvs == null) {
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            this.kvs = this.createMVList(new DBTableData(this.databaseConnection, calculator.renderTpl(this.sqlFormula)), calculator);
            this.cachedKVMap = new HashMap(this.kvs.size());
            for (int i = 0; i < this.kvs.size(); ++i) {
                Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i);
                if (this.cachedKVMap.containsKey(mV.getModel())) continue;
                this.cachedKVMap.put(mV.getModel(), mV.getView());
            }
        }
    }

    public String[] getDependence() {
        return ScriptUtils.getDependenceByParameter(ParameterHelper.analyze4Parameters(this.sqlFormula));
    }

    public boolean equlas(Object object) {
        return object instanceof DynamicSQLDict && super.equals(object) && ComparatorUtils.equals(((DynamicSQLDict)object).databaseConnection, this.databaseConnection);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if ("Formula".equals(xMLableReader.getTagName())) {
                this.setSqlFormula(xMLableReader.getElementValue());
            } else if ("SQLDict".equals(xMLableReader.getTagName())) {
                this.setKeyColumnIndex(Utils.string2Number(xMLableReader.getAttr("keyColumnIndex")).intValue());
                this.setValueColumnIndex(Utils.string2Number(xMLableReader.getAttr("valueColumnIndex")).intValue());
            } else if ("Connection".equals(xMLableReader.getTagName())) {
                Connection connection = DataXMLUtils.readXMLConnection(xMLableReader);
                if (connection instanceof DatabaseConnection) {
                    this.setDatabaseConnection((DatabaseConnection)connection);
                }
            } else if ("Condition".equals(xMLableReader.getTagName())) {
                Condition condition = DataXMLUtils.readCondition(xMLableReader);
                this.setCondition(condition);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.sqlFormula)) {
            xMLPrintWriter.startTAG("Formula").textNode(this.sqlFormula).end();
        }
        if (this.getDatabaseConnection() != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.getDatabaseConnection());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicSQLDict dynamicSQLDict = (DynamicSQLDict)super.clone();
        if (this.databaseConnection != null) {
            dynamicSQLDict.databaseConnection = (DatabaseConnection)this.databaseConnection.clone();
        }
        if (this.condition != null) {
            dynamicSQLDict.condition = (Condition)this.condition.clone();
        }
        return dynamicSQLDict;
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < DynamicSQLDict.this.kvs.size();
        }

        public Object next() {
            Object e = DynamicSQLDict.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

