/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DirectoryConnection;
import com.fr.report.io.core.ExcelUtils;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExcelTableData
extends AbstractTableData
implements XMLable {
    private DirectoryConnection directoryConnection;
    private String filePath = null;
    private List columnNameList = new ArrayList();
    private boolean needColumnName;
    private List rowDataList = new ArrayList();
    private boolean isInitialed = false;

    public DirectoryConnection getDirectoryConnection() {
        return this.directoryConnection;
    }

    public void setDirectoryConnection(DirectoryConnection directoryConnection) {
        this.directoryConnection = directoryConnection;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean needColumnName() {
        return this.needColumnName;
    }

    public void setNeedColumnName(boolean bl) {
        this.needColumnName = bl;
    }

    public int getColumnCount() throws TableDataException {
        this.loadColumnName();
        return this.columnNameList.size();
    }

    public String getColumnName(int n) throws TableDataException {
        this.loadColumnName();
        String string = n < this.columnNameList.size() ? this.columnNameList.get(n).toString() : null;
        return string;
    }

    public int getRowCount() throws TableDataException {
        this.initial();
        return this.rowDataList.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        this.initial();
        List list = (List)this.rowDataList.get(n);
        return n2 < list.size() ? list.get(n2) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadColumnName() {
        File file = new File(this.directoryConnection.getLocation());
        if (!file.isDirectory()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.columnNameList.clear();
        if (this.needColumnName) {
            try {
                POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath})));
                HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
                HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(0);
                Iterator iterator = hSSFSheet.rowIterator();
                if (!iterator.hasNext()) return;
                HSSFRow hSSFRow = (HSSFRow)iterator.next();
                Iterator iterator2 = hSSFRow.cellIterator();
                while (iterator2.hasNext()) {
                    HSSFCell hSSFCell = (HSSFCell)iterator2.next();
                    this.columnNameList.add(ExcelUtils.getHSSFCellValue(hSSFCell));
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath})));
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(0);
            Iterator iterator = hSSFSheet.rowIterator();
            if (iterator.hasNext()) {
                HSSFRow hSSFRow = (HSSFRow)iterator.next();
                Iterator iterator3 = hSSFRow.cellIterator();
                while (iterator3.hasNext()) {
                    HSSFCell hSSFCell = (HSSFCell)iterator3.next();
                    this.columnNameList.add(ExcelUtils.getHSSFCellValue(hSSFCell));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            arrayList.add("#" + (i + 1));
        }
        this.columnNameList = arrayList;
    }

    private void initial() {
        if (this.isInitialed) {
            return;
        }
        File file = new File(this.directoryConnection.getLocation());
        if (!file.isDirectory()) {
            return;
        }
        this.rowDataList.clear();
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath})));
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
            int n = hSSFWorkbook.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
                Iterator iterator = hSSFSheet.rowIterator();
                while (iterator.hasNext()) {
                    HSSFRow hSSFRow = (HSSFRow)iterator.next();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Iterator iterator2 = hSSFRow.cellIterator();
                    while (iterator2.hasNext()) {
                        HSSFCell hSSFCell = (HSSFCell)iterator2.next();
                        arrayList.add(ExcelUtils.getHSSFCellValue(hSSFCell));
                    }
                    this.rowDataList.add(arrayList);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.needColumnName && this.rowDataList.size() > 0) {
            this.rowDataList.remove(0);
        }
        this.isInitialed = true;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            Connection connection;
            String string = xMLableReader.getTagName();
            if ("ExcelTableDataAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("filePath");
                if (string2 != null) {
                    this.filePath = string2;
                }
                if ((string2 = xMLableReader.getAttr("needColumnName")) != null) {
                    if (string2.equals("true")) {
                        this.setNeedColumnName(true);
                    } else {
                        this.setNeedColumnName(false);
                    }
                }
            } else if ("Connection".equals(string) && (connection = DataXMLUtils.readXMLConnection(xMLableReader)) instanceof DirectoryConnection) {
                this.directoryConnection = (DirectoryConnection)connection;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExcelTableDataAttr").attr("needColumnName", this.needColumnName()).attr("filePath", this.getFilePath()).end();
        if (this.directoryConnection != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.directoryConnection);
        }
    }

    public boolean equals(Object object) {
        return object instanceof ExcelTableData && super.equals(object) && this.needColumnName == ((ExcelTableData)object).needColumnName && ComparatorUtils.equals(this.filePath, ((ExcelTableData)object).filePath) && ComparatorUtils.equals(this.directoryConnection, ((ExcelTableData)object).directoryConnection);
    }
}

