/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractDict;
import com.fr.data.Dictionary;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.CurrentValueNameSpace;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class FormulaDictionary
extends AbstractDict {
    public static final String XML_TAG = "FormulaDict";
    public static final String E_XML_TAG = "EFormulaDict";
    private String produceFormula;
    private String excuteFormula;
    private transient List kvs;

    public String getProduceFormula() {
        return this.produceFormula;
    }

    public void setProduceFormula(String string) {
        this.produceFormula = string;
    }

    public String getExcuteFormula() {
        return this.excuteFormula;
    }

    public void setExcuteFormula(String string) {
        this.excuteFormula = string;
    }

    public String[] getDependence() {
        return (String[])ArrayUtils.addAll(super.getDependence(), ScriptUtils.getDependenceByFormula(this.produceFormula.substring(1)));
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public Object get(Object object, Calculator calculator) {
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(object);
        calculator.pushNameSpace(currentValueNameSpace);
        this.createKVS(calculator);
        calculator.removeNameSpace(currentValueNameSpace);
        int n = this.kvs.size();
        for (int i = 0; i < n; ++i) {
            Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i);
            if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    public void reset() {
        this.kvs = null;
    }

    private void createKVS(Calculator calculator) {
        List list = this.keyProduce(calculator);
        if (this.kvs == null) {
            this.kvs = new ArrayList(list.size());
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (n > 0) {
                calculator.set("$$$", e);
            }
            this.kvs.add(new Dictionary.MV(e, this.valueProduce(e, calculator)));
        }
    }

    private List keyProduce(Calculator calculator) {
        if (calculator == null) {
            calculator = Calculator.createCalculator();
        }
        FArray fArray = null;
        Object object = null;
        try {
            if (!StringUtils.isEmpty(this.produceFormula)) {
                object = calculator.eval(this.produceFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
        }
        fArray = object instanceof FArray ? (FArray)object : new FArray(new Object[]{object});
        return fArray.toList();
    }

    private Object valueProduce(Object object, Calculator calculator) {
        Object object2 = object;
        try {
            if (!StringUtils.isEmpty(this.excuteFormula)) {
                object2 = calculator.eval(this.excuteFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
        }
        return object2;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (XML_TAG.equals(xMLableReader.getTagName())) {
                this.setProduceFormula(xMLableReader.getElementValue());
            } else if (E_XML_TAG.equals(xMLableReader.getTagName())) {
                this.setExcuteFormula(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.produceFormula)) {
            xMLPrintWriter.startTAG(XML_TAG).textNode(this.produceFormula).end();
        }
        if (!StringUtils.isEmpty(this.excuteFormula)) {
            xMLPrintWriter.startTAG(E_XML_TAG).textNode(this.excuteFormula).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FormulaDictionary && ComparatorUtils.equals(((FormulaDictionary)object).excuteFormula, this.excuteFormula) && ComparatorUtils.equals(((FormulaDictionary)object).produceFormula, this.produceFormula);
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < FormulaDictionary.this.kvs.size();
        }

        public Object next() {
            Object e = FormulaDictionary.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

