/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public abstract class FormulaDisplayDictionary
implements Dictionary {
    protected Condition condition;
    protected int keyColumnIndex;
    protected int valueColumnIndex;
    protected String formula;

    public int getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    public void setKeyColumnIndex(int n) {
        this.keyColumnIndex = n;
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void setValueColumnIndex(int n) {
        this.valueColumnIndex = n;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String[] getDependence() {
        if (this.condition != null) {
            return this.condition.getDependence();
        }
        return new String[0];
    }

    public List createMVList(TableData tableData, Calculator calculator) {
        int n;
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        TableData tableData2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (calculator != null) {
            Parameter[] parameterArray = tableData.getParameters();
            for (n = 0; n < parameterArray.length; ++n) {
                Parameter parameter = parameterArray[n];
                try {
                    Object object = calculator.eval("$" + parameter.getName());
                    hashMap.put(parameter.getName(), object);
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
            }
        }
        try {
            tableData2 = FRContext.getCurrentEnv().previewTableData(tableData, hashMap, -1);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            tableData2 = TableData.EMPTY_TABLEDATA;
        }
        try {
            n = tableData2.getRowCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.createMV(tableData2, i, calculator));
            }
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        try {
            tableData2.release();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return arrayList;
    }

    protected Dictionary.MV createMV(TableData tableData, int n, Calculator calculator) throws TableDataException {
        Object object = tableData.getValueAt(n, this.keyColumnIndex);
        Object object2 = tableData.getValueAt(n, this.valueColumnIndex);
        if (this.getFormula() != null) {
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            calculator.set("$$$", object);
            try {
                object2 = calculator.eval(this.getFormula());
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
            }
        }
        return new Dictionary.MV(object, object2);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "FormulaDictAttr".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttr("ki");
            if (string2 != null) {
                this.setKeyColumnIndex(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("vi")) != null) {
                this.setValueColumnIndex(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("formula")) != null) {
                this.setFormula(string2);
            }
            if ((string2 = xMLableReader.getAttr("keyColumnIndex")) != null) {
                this.setKeyColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttr("valueColumnIndex")) != null) {
                this.setValueColumnIndex(Integer.parseInt(string2) - 1);
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
                        FormulaDisplayDictionary.this.condition = DataXMLUtils.readCondition(xMLableReader);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FormulaDictAttr").attr("ki", this.getKeyColumnIndex());
        if (this.formula != null) {
            xMLPrintWriter.attr("formula", this.getFormula());
        } else {
            xMLPrintWriter.attr("vi", this.getValueColumnIndex());
        }
        if (this.condition != null) {
            DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormulaDisplayDictionary)) {
            return false;
        }
        return this.getKeyColumnIndex() == ((FormulaDisplayDictionary)object).getKeyColumnIndex() && this.getValueColumnIndex() == ((FormulaDisplayDictionary)object).getValueColumnIndex() && ComparatorUtils.equals(this.formula, ((FormulaDisplayDictionary)object).getFormula());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaDisplayDictionary formulaDisplayDictionary = (FormulaDisplayDictionary)super.clone();
        if (this.condition != null) {
            formulaDisplayDictionary.condition = (Condition)this.condition.clone();
        }
        return formulaDisplayDictionary;
    }
}

