/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.FRCacheList;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;

public final class GroupCachedAdapter
extends TableDataAdapter {
    private static final long serialVersionUID = 1L;
    private transient List row_list;
    private transient int current_group_start_index = 0;
    private transient int next_group_start_index = 0;
    private int key_column_index = -2;
    private String key_column_name;
    private transient Object last_key_value;

    public GroupCachedAdapter(DatabaseConnection databaseConnection, String string, String string2) {
        super(databaseConnection, string, 0);
        this.key_column_name = string2;
    }

    public int getRowCount() throws TableDataException {
        int n = this.shortcutGetRowCount();
        if (n < 0) {
            this.hasRow(Integer.MAX_VALUE);
            return this.current_group_start_index + this.row_list.size();
        }
        return n;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.hasRow(n) ? ((Object[])this.row_list.get(n - this.current_group_start_index))[n2] : null;
    }

    protected boolean hasRow(int n) throws TableDataException {
        if (n < 0) {
            return false;
        }
        if (n < this.current_group_start_index) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
            this.row_list.clear();
            this.last_key_value = new TableDataException("\u6211\u662f\u4e2a\u5f02\u5e38\uff0c\u4f60\u6562\u548c\u6211\u4e00\u6837\uff1f");
            this.current_group_start_index = 0;
            this.next_group_start_index = 0;
            this.hasRow(n);
        } else if (this.row_list != null && this.row_list.size() > n - this.current_group_start_index) {
            return true;
        }
        if (this.isCheckRowOver) {
            return false;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.connection == null) {
            return false;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n2 = this.getColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        try {
            while (this.resultSet.next()) {
                Object[] objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    try {
                        objectArray[i] = DataUtils.getResultSetObject(this.resultSet, this.columnInformations[i].getColumnType(), i + 1, string, string2, dialect);
                        if (this.key_column_index == -2) {
                            this.key_column_index = -1;
                            if (StringUtils.isNotBlank(this.key_column_name)) {
                                for (int j = 0; j < this.getColumnCount(); ++j) {
                                    if (this.getColumnName(j) == null || !this.key_column_name.equalsIgnoreCase(this.getColumnName(j))) continue;
                                    this.key_column_index = j;
                                }
                            }
                        }
                        if (i != this.key_column_index) continue;
                        if (this.current_group_start_index < this.next_group_start_index) {
                            Object e = this.row_list.get(this.row_list.size() - 1);
                            this.row_list.clear();
                            this.row_list.add(e);
                            this.current_group_start_index = this.next_group_start_index;
                        }
                        if (ComparatorUtils.equals(objectArray[i], this.last_key_value)) continue;
                        this.next_group_start_index += this.row_list.size();
                        this.last_key_value = objectArray[i];
                        continue;
                    }
                    catch (SQLException sQLException) {
                        objectArray[i] = null;
                    }
                }
                this.row_list.add(objectArray);
                if (this.row_list.size() + this.current_group_start_index <= n) continue;
                return true;
            }
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                FRContext.getLogger().log(Level.WARNING, "Error happens while releaseConnection");
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "\nQuery is:" + this.sql + "\nrowIndex to get is:" + n, exception);
        }
        return this.row_list.size() + this.current_group_start_index > n;
    }

    protected void initRowValueStatus() {
        this.row_list = new FRCacheList(5000, "GCA");
        this.last_key_value = new TableDataException("\u6211\u662f\u4e2a\u5f02\u5e38\uff0c\u4f60\u6562\u548c\u6211\u4e00\u6837\uff1f");
        this.current_group_start_index = 0;
        this.next_group_start_index = 0;
    }

    protected void release() throws SQLException {
        if (this.row_list != null) {
            this.row_list.clear();
        }
        super.release();
    }
}

