/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.impl.AbstractDatabaseConnection;
import com.fr.data.pool.ConnectionPoolManager;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.data.pool.MemoryConnection;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.util.Utils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;

public class JDBCDatabaseConnection
extends AbstractDatabaseConnection {
    private String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String url = "";
    private String user = "";
    private String password = "";
    private DBCPConnectionPoolAttr dbcpAttr = null;
    private boolean encryptPassword = true;

    public JDBCDatabaseConnection() {
        this("", "", "", "");
    }

    public JDBCDatabaseConnection(String string, String string2, String string3, String string4) {
        this.setDriver(string);
        this.setURL(string2);
        this.setUser(string3);
        this.setPassword(string4);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getURL() {
        return this.url;
    }

    private String getActualURL() {
        if (this.url != null) {
            try {
                return TemplateUtils.render(this.url, (Map)new HashMap(){
                    {
                        this.put("FR_HOME", Utils.getInstallHome());
                        if (FRContext.getCurrentEnv() != null) {
                            this.put("ENV_HOME", FRContext.getCurrentEnv().getPath());
                        }
                    }
                });
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isEncryptPassword() {
        return this.encryptPassword;
    }

    public void setEncryptPassword(boolean bl) {
        this.encryptPassword = bl;
    }

    public DBCPConnectionPoolAttr getDbcpAttr() {
        return this.dbcpAttr;
    }

    public void setDbcpAttr(DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        this.dbcpAttr = dBCPConnectionPoolAttr;
    }

    public void testConnection() throws Exception {
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManager.getConnectionPoolManager();
        DataSource dataSource = connectionPoolManager.getDataSource(this.getDriver(), this.getActualURL(), this.getUser(), this.getPassword(), this.dbcpAttr);
        Connection connection = dataSource.getConnection();
        connection.close();
    }

    public Connection createConnection() throws Exception {
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManager.getConnectionPoolManager();
        DataSource dataSource = connectionPoolManager.getDataSource(this.getDriver(), this.getActualURL(), this.getUser(), this.getPassword(), this.dbcpAttr);
        return new MemoryConnection(dataSource.getConnection());
    }

    public boolean equals(Object object) {
        return object instanceof JDBCDatabaseConnection && super.equals(object) && ComparatorUtils.equals(this.getURL(), ((JDBCDatabaseConnection)object).getURL()) && ComparatorUtils.equals(this.getDriver(), ((JDBCDatabaseConnection)object).getDriver()) && ComparatorUtils.equals(this.getUser(), ((JDBCDatabaseConnection)object).getUser()) && ComparatorUtils.equals(this.getPassword(), ((JDBCDatabaseConnection)object).getPassword()) && this.isEncryptPassword() == ((JDBCDatabaseConnection)object).isEncryptPassword();
    }

    public int hashCode() {
        int n = 0;
        n = 37 * n + this.getDriver().hashCode();
        n = 37 * n + this.getURL().hashCode();
        n = 37 * n + this.getUser().hashCode();
        n = 37 * n + this.getPassword().hashCode();
        n = 37 * n + (this.isEncryptPassword() ? 1 : 0);
        return n;
    }

    public String toString() {
        return "[JDBCDatabase][Driver:" + this.getDriver() + "][URL:" + this.getURL() + "]" + "[User:" + this.getUser() + "][Password:***]";
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "JDBCDatabaseAttr".equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttr("driver");
            if (string != null) {
                this.setDriver(string);
            }
            if ((string = xMLableReader.getAttr("url")) != null) {
                this.setURL(string);
            }
            if ((string = xMLableReader.getAttr("user")) != null) {
                this.setUser(string);
            }
            if ((string = xMLableReader.getAttr("password")) != null) {
                this.setPassword(ReportXMLUtils.unPasswordString(string));
            }
            if ((string = xMLableReader.getAttr("encryptPassword")) != null) {
                this.setEncryptPassword(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("originalCharsetName")) != null) {
                this.setOriginalCharsetName(string);
            }
            if ((string = xMLableReader.getAttr("newCharsetName")) != null) {
                this.setNewCharsetName(string);
            }
            DBCPConnectionPoolAttr dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
            this.setDbcpAttr(dBCPConnectionPoolAttr);
            xMLableReader.readXMLObject(dBCPConnectionPoolAttr);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("JDBCDatabaseAttr").attr("url", this.getURL()).attr("driver", this.getDriver()).attr("user", this.getUser());
        if (this.isEncryptPassword()) {
            xMLPrintWriter.attr("password", ReportXMLUtils.passwordString(this.getPassword()));
        } else {
            xMLPrintWriter.attr("password", this.getPassword());
        }
        xMLPrintWriter.attr("encryptPassword", this.isEncryptPassword());
        if (this.getDbcpAttr() != null) {
            this.getDbcpAttr().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }
}

