/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.impl.AbstractDatabaseConnection;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JNDIDatabaseConnection
extends AbstractDatabaseConnection {
    private String jndiName;
    private Hashtable contextHashtable = new Hashtable();

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String string) {
        this.jndiName = string;
    }

    public Hashtable getContextHashtable() {
        return this.contextHashtable;
    }

    public void setContextHashtable(Hashtable hashtable) {
        this.contextHashtable = hashtable;
    }

    public void testConnection() throws Exception {
        Context context = new InitialContext(this.contextHashtable);
        if (this.contextHashtable.get("java.naming.factory.initial") == null) {
            context = (Context)context.lookup("java:comp/env");
        }
        DataSource dataSource = (DataSource)context.lookup(this.jndiName);
        Connection connection = dataSource.getConnection();
        connection.close();
    }

    public Connection createConnection() throws Exception {
        Context context = new InitialContext(this.contextHashtable);
        if (this.contextHashtable.get("java.naming.factory.initial") == null) {
            context = (Context)context.lookup("java:comp/env");
        }
        DataSource dataSource = (DataSource)context.lookup(this.jndiName);
        return dataSource.getConnection();
    }

    public boolean equals(Object object) {
        return object instanceof JNDIDatabaseConnection && super.equals(object) && ComparatorUtils.equals(this.getJNDIName(), ((JNDIDatabaseConnection)object).getJNDIName());
    }

    public String toString() {
        return "[JNDIName:" + this.getJNDIName() + "]";
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "JNDIDatabaseAttr".equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttr("jndiName");
            if (string != null) {
                this.setJNDIName(string);
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isAttr()) {
                        JNDIDatabaseConnection.this.contextHashtable.clear();
                    }
                    if (xMLableReader.isChildNode() && (string = xMLableReader.getElementValue()) != null) {
                        JNDIDatabaseConnection.this.contextHashtable.put(xMLableReader.getTagName(), string);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("JNDIDatabaseAttr").attr("jndiName", this.getJNDIName());
        Enumeration enumeration = this.contextHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = BaseXMLUtils.xmlAttrEncode((String)k);
            xMLPrintWriter.startTAG(string).textNode((String)this.contextHashtable.get(k)).end();
        }
        xMLPrintWriter.end();
    }
}

