/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import com.fr.report.core.ParameterHelper;
import com.fr.report.parameter.Parameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

public final class LayerPageQueryAdapter
extends TableDataAdapter {
    private static final long serialVersionUID = 1L;
    public static final String STARTROW_IDENTIFIER = "fr_startrow";
    public static final String PAGESIZE_IDENTIFIER = "fr_pagesize";
    public static final String PAGE_NUMBER_IDENTIFIER = "fr_pagenumber";
    public static final String ROW_COUNT_IDENTIFIER = "fr_rowcount";
    private transient int startRow;
    private int pageSize;
    private transient int currentRowIndex = -1;
    private transient Object[] currentRowValue = null;
    private String rowCountQuery = null;
    protected String pageQuery;
    private boolean bePaged = false;
    private String originalQuery;
    private Parameter[] parameters;

    public LayerPageQueryAdapter(DatabaseConnection databaseConnection, String string, String string2, Parameter[] parameterArray, int n) {
        super(databaseConnection, string, 0);
        this.originalQuery = string;
        this.pageSize = n;
        this.pageQuery = string2;
        this.parameters = parameterArray;
    }

    public int getRowCount() throws TableDataException {
        return this.shortcutGetRowCount();
    }

    /*
     * Unable to fully structure code
     */
    protected int shortcutGetRowCount() {
        if (this.shortcutRowCount == -1) {
            block13: {
                var1_1 = System.currentTimeMillis();
                var3_2 = this.rowCountQuery;
                if (var3_2 == null && DBUtils.isProcedure(this.sql)) {
                    this.shortcutRowCount = -2147483648;
                    FRContext.getLogger().log(Level.WARNING, Inter.getLocText("DBTableData_Not_Get_RowCount"));
                    throw new RuntimeException(Inter.getLocText("DBTableData_Not_Get_RowCount"));
                }
                var4_3 = null;
                try {
                    var4_3 = this.database.createConnection();
                    if (this.dialect == null) {
                        this.dialect = DialectFactory.generateDialect(var4_3);
                    }
                    if (var3_2 == null) {
                        var3_2 = this.dialect.getCountSql(this.sql);
                    }
                    FRContext.getLogger().log(Level.INFO, "RowCount SQL:\n" + var3_2);
                    var5_4 = var4_3.createStatement();
                    var6_7 = var5_4.executeQuery(var3_2);
                    var6_7.next();
                    this.shortcutRowCount = var6_7.getInt(1);
                    var6_7.close();
                    var5_4.close();
                    var8_8 = null;
                    ** if (var4_3 == null) goto lbl-1000
                }
                catch (Throwable var7_12) {
                    var8_9 = null;
                    if (var4_3 != null) {
                        try {
                            var4_3.close();
                        }
                        catch (SQLException var9_11) {
                            FRContext.getLogger().log(Level.WARNING, var9_11.getMessage(), var9_11);
                        }
                    }
                    throw var7_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var4_3.close();
                    }
                    catch (SQLException var9_10) {
                        FRContext.getLogger().log(Level.WARNING, var9_10.getMessage(), var9_10);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (Exception var5_5) {
                        this.shortcutRowCount = -2147483648;
                        FRContext.getLogger().log(Level.WARNING, var5_5.getMessage(), var5_5);
                        throw new RuntimeException(var5_5.getMessage());
                    }
                }
            }
            var5_6 = System.currentTimeMillis();
            FRContext.getLogger().log(Level.INFO, "RowCount costs " + (var5_6 - var1_1) / 1000L + " s.");
        }
        return this.shortcutRowCount;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.hasRow(n) ? this.currentRowValue[n2] : null;
    }

    protected boolean hasRow(int n) throws TableDataException {
        int n2 = n - this.startRow;
        if (n < 0) {
            return false;
        }
        if (n2 == this.currentRowIndex) {
            return true;
        }
        if (!this.bePaged || n2 < this.currentRowIndex || n2 >= this.pageSize) {
            try {
                this.releaseConnection();
            }
            catch (SQLException sQLException) {
                this.connection = null;
                this.statement = null;
                this.resultSet = null;
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
            this.createPageQuery(n);
            this.isCheckRowOver = false;
            this.bePaged = true;
        } else if (this.isCheckRowOver) {
            return false;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.connection == null) {
            return false;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n3 = this.getColumnCount();
        boolean bl = false;
        try {
            String string = this.database.getOriginalCharsetName();
            String string2 = this.database.getNewCharsetName();
            while (this.resultSet.next()) {
                ++this.currentRowIndex;
                if (this.currentRowIndex < n - this.startRow) continue;
                this.currentRowValue = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    try {
                        this.currentRowValue[i] = DataUtils.getResultSetObject(this.resultSet, this.columnInformations[i].getColumnType(), i + 1, string, string2, dialect);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                    }
                }
                if (this.currentRowIndex == this.pageSize - 1 || this.currentRowIndex + this.startRow == this.shortcutRowCount - 1) {
                    bl = true;
                    break;
                }
                return true;
            }
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "\nQuery is:" + this.sql + "\nrowIndex to get is:" + n, exception);
        }
        return bl;
    }

    protected void initRowValueStatus() {
        this.currentRowIndex = -1;
        this.currentRowValue = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean createPageQuery(int n) {
        if (StringUtils.isBlank(this.pageQuery)) {
            if (this.dialect.supportsLimitOffset()) {
                this.sql = this.dialect.getLimitString(this.originalQuery, n, this.pageSize);
                this.startRow = n;
                return true;
            }
            this.sql = this.originalQuery;
            FRContext.getLogger().log(Level.WARNING, Inter.getLocText("LayerPageReport_PageQuery_Unsupport_Msg1") + "!");
            return false;
        }
        this.startRow = n;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (!ArrayUtils.isEmpty(this.parameters)) {
            arrayList.addAll(Arrays.asList(this.parameters));
        }
        arrayList.add(new Parameter(STARTROW_IDENTIFIER, new Integer(this.startRow)));
        arrayList.add(new Parameter(PAGESIZE_IDENTIFIER, new Integer(this.pageSize)));
        arrayList.add(new Parameter(PAGE_NUMBER_IDENTIFIER, new Integer(this.startRow / this.pageSize + 1)));
        arrayList.add(new Parameter(ROW_COUNT_IDENTIFIER, new Integer(this.shortcutRowCount)));
        this.sql = ParameterHelper.analyze4Templatee(this.pageQuery, arrayList.toArray(new Parameter[0]));
        return true;
    }
}

