/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MemCachedAdapter
extends TableDataAdapter {
    private static final long serialVersionUID = 1L;
    private List row_list;

    public MemCachedAdapter(DatabaseConnection databaseConnection, String string, int n) {
        super(databaseConnection, string, n);
    }

    public int getRowCount() throws TableDataException {
        this.hasRow(Integer.MAX_VALUE);
        return this.row_list.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.hasRow(n) ? ((Object[])this.row_list.get(n))[n2] : null;
    }

    protected synchronized boolean hasRow(int n) throws TableDataException {
        if (this.row_list != null && this.row_list.size() > n) {
            return true;
        }
        if (this.isCheckRowOver) {
            return false;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.connection == null) {
            return false;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n2 = this.getColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        try {
            while (this.resultSet.next()) {
                Object[] objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    try {
                        objectArray[i] = DataUtils.getResultSetObject(this.resultSet, this.columnInformations[i].getColumnType(), i + 1, string, string2, dialect);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        objectArray[i] = null;
                    }
                }
                this.row_list.add(objectArray);
                if (this.row_list.size() <= n) continue;
                return true;
            }
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                FRContext.getLogger().log(Level.WARNING, "Error happens while releaseConnection");
            }
            if (exception.getCause() != null) {
                FRContext.getLogger().log(Level.WARNING, "Caused By:" + exception.getCause().getMessage(), exception.getCause());
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "\nQuery is:" + this.sql + "\nrowIndex to get is:" + n, exception);
        }
        return this.row_list.size() > n;
    }

    protected void initRowValueStatus() {
        this.row_list = new ArrayList();
    }

    protected synchronized void release() throws SQLException {
        if (this.row_list != null) {
            this.row_list.clear();
        }
        this.isCheckRowOver = false;
        super.release();
    }
}

