/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableDataException;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.SpecialTreeDataAdapter;
import com.fr.data.impl.TableDataAdapter;
import com.fr.report.core.ParameterHelper;
import com.fr.util.Utils;

public class RecursionTableData
extends DBTableData {
    private String[] markFields;
    private String[] parentmarkFields;
    private String[] treeFields;
    private String fieldName;
    private transient SpecialTreeDataAdapter adapter;
    private String separator = ",";
    private int limitGeneration = -1;

    private TableDataAdapter createAdapter() {
        if (this.adapter == null) {
            this.adapter = new SpecialTreeDataAdapter(this.getDatabase(), this.getNewQuery(), this.markFields, this.parentmarkFields, this.treeFields, this.limitGeneration);
            if (StringUtils.isNotBlank(this.fieldName)) {
                this.adapter.setDefaultFieldName(this.fieldName);
            }
        }
        return this.adapter;
    }

    public int getLimitGeneration() {
        return this.limitGeneration;
    }

    public void setLimitGeneration(int n) {
        this.limitGeneration = n;
    }

    public int getColumnCount() throws TableDataException {
        return this.createAdapter().getColumnCount();
    }

    public String getColumnName(int n) throws TableDataException {
        String string = this.createAdapter().getColumnName(n);
        return string;
    }

    public boolean hasRow(int n) throws TableDataException {
        return this.createAdapter().hasRow(n);
    }

    public int getRowCount() throws TableDataException {
        return this.createAdapter().getRowCount();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.createAdapter().getValueAt(n, n2);
    }

    public String[] getMarkFields() {
        return this.markFields;
    }

    public void setMarkFields(String[] stringArray) {
        this.markFields = stringArray;
    }

    public String[] getParentmarkFields() {
        return this.parentmarkFields;
    }

    public void setParentmarkFields(String[] stringArray) {
        this.parentmarkFields = stringArray;
    }

    public String[] getTreeFields() {
        return this.treeFields;
    }

    public void setTreeFields(String[] stringArray) {
        this.treeFields = stringArray;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setShare(boolean bl) {
    }

    public boolean isShare() {
        return false;
    }

    public void setMaxMemRowCount(int n) {
    }

    public int getMaxMemRowCount() {
        return -1;
    }

    public int getRealColumnCount() throws TableDataException {
        return ((SpecialTreeDataAdapter)this.createAdapter()).getRealColumnCount();
    }

    public String getRealColumnName(int n) throws TableDataException {
        return ((SpecialTreeDataAdapter)this.createAdapter()).getRealColumnName(n);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("markFields".equals(string)) {
                this.markFields = this.readArray(xMLableReader);
            }
            if ("parentmarkFields".equals(string)) {
                this.parentmarkFields = this.readArray(xMLableReader);
            }
            if ("treeFields".equals(string)) {
                this.treeFields = this.readArray(xMLableReader);
            }
            if ("fieldName".equals(string)) {
                this.fieldName = xMLableReader.getAttr("defaultName");
            }
            if ("limitGeneration".equals(string)) {
                this.limitGeneration = Integer.valueOf(xMLableReader.getAttr("value"));
            }
        }
    }

    private String[] readArray(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        String[] stringArray = null;
        if (StringUtils.isNotEmpty(string)) {
            String[] stringArray2;
            stringArray = stringArray2 = Utils.splitString(string, this.separator);
        }
        return stringArray;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!ArrayUtils.isEmpty(this.markFields)) {
            xMLPrintWriter.startTAG("markFields");
            this.writeArray(xMLPrintWriter, this.markFields);
            xMLPrintWriter.end();
        }
        if (!ArrayUtils.isEmpty(this.parentmarkFields)) {
            xMLPrintWriter.startTAG("parentmarkFields");
            this.writeArray(xMLPrintWriter, this.parentmarkFields);
            xMLPrintWriter.end();
        }
        if (!ArrayUtils.isEmpty(this.treeFields)) {
            xMLPrintWriter.startTAG("treeFields");
            this.writeArray(xMLPrintWriter, this.treeFields);
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotBlank(this.fieldName)) {
            xMLPrintWriter.startTAG("fieldName").attr("defaultName", this.fieldName).end();
        }
        if (this.limitGeneration > 0) {
            xMLPrintWriter.startTAG("limitGeneration").attr("value", this.limitGeneration).end();
        }
    }

    private void writeArray(XMLPrintWriter xMLPrintWriter, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == n - 1) continue;
            stringBuffer.append(this.separator);
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
    }

    public Object clone() throws CloneNotSupportedException {
        RecursionTableData recursionTableData = new RecursionTableData();
        recursionTableData.setDatabase(this.getDatabase());
        recursionTableData.parameters = ParameterHelper.cloneParameters(this.getParameters());
        recursionTableData.setQuery(this.getQuery());
        recursionTableData.setPageQuerySql(this.getPageQuerySql());
        recursionTableData.setFieldName(this.getFieldName());
        recursionTableData.setMarkFields(this.markFields);
        recursionTableData.setParentmarkFields(this.parentmarkFields);
        recursionTableData.setTreeFields(this.treeFields);
        recursionTableData.separator = this.separator;
        recursionTableData.limitGeneration = this.limitGeneration;
        return recursionTableData;
    }

    public void release() throws Exception {
        if (this.adapter != null) {
            this.adapter.unRegister(this);
            this.adapter.tryDestroy();
            this.adapter = null;
        }
    }
}

