/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.EmbeddedTableData;
import java.util.logging.Level;

public class RowsTableData
extends AbstractTableData {
    private TableData tableData;
    private int[] rows;

    public RowsTableData(TableData tableData, int[] nArray) {
        this.tableData = tableData;
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.rows = nArray;
    }

    public int getColumnCount() throws TableDataException {
        return this.tableData.getColumnCount();
    }

    public String getColumnName(int n) throws TableDataException {
        return this.tableData.getColumnName(n);
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        return this.tableData.getValueAt(this.rows[n], n2);
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public int[] getRows() {
        return this.rows;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("TableData")) {
            EmbeddedTableData embeddedTableData = (EmbeddedTableData)DataXMLUtils.readXMLTableData(xMLableReader);
            if (embeddedTableData != null) {
                this.rows = IntList.range(embeddedTableData.getRowCount());
            }
            this.tableData = embeddedTableData;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.tableData != null) {
            try {
                DataXMLUtils.writeXMLTableData(xMLPrintWriter, EmbeddedTableData.embedify(this));
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, "embedify failed...", exception);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof RowsTableData && super.equals(object) && ComparatorUtils.equals(this.rows, ((RowsTableData)object).rows) && ComparatorUtils.equals(this.tableData, ((RowsTableData)object).tableData);
    }
}

