/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import com.fr.data.impl.TreeAccessData;
import com.fr.report.script.Primitive;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class SpecialTreeDataAdapter
extends TableDataAdapter {
    private static final long serialVersionUID = -1391294406394533677L;
    private String[] markFields;
    private String[] parentmarkFields;
    private String[] treeField;
    private transient ColumnInformation[] columnInformations = null;
    private transient ColumnInformation[] realColumnInformations = null;
    private List databaseList;
    private List treedataList;
    private int addedFieldLength;
    private String defaultFieldName = "FR_GEN_";
    private int limitGeneration = -1;

    public SpecialTreeDataAdapter(DatabaseConnection databaseConnection, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) {
        super(databaseConnection, string, 0);
        this.setMarkFields(stringArray);
        this.setParentmarkFields(stringArray2);
        this.setTreeField(stringArray3);
        this.limitGeneration = n;
    }

    public String[] getMarkFields() {
        return this.markFields;
    }

    public void setMarkFields(String[] stringArray) {
        this.markFields = stringArray;
    }

    public String[] getParentmarkFields() {
        return this.parentmarkFields;
    }

    public void setParentmarkFields(String[] stringArray) {
        this.parentmarkFields = stringArray;
    }

    public String[] getTreeField() {
        return this.treeField;
    }

    public void setTreeField(String[] stringArray) {
        this.treeField = stringArray;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String string) {
        this.defaultFieldName = string;
    }

    public int getRealColumnCount() throws TableDataException {
        this.checkRealColumn();
        return this.realColumnInformations.length;
    }

    public String getRealColumnName(int n) throws TableDataException {
        this.checkRealColumn();
        return this.realColumnInformations[n].getColumnName();
    }

    public int getAddedFieldLength() {
        return this.addedFieldLength;
    }

    public int getColumnCount() throws TableDataException {
        this.checkInColumn();
        return this.columnInformations.length;
    }

    public String getColumnName(int n) throws TableDataException {
        this.checkInColumn();
        return this.columnInformations[n].getColumnName();
    }

    private synchronized void initData() throws TableDataException {
        if (this.isCheckRowOver) {
            return;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.databaseList.size() > 0 && this.treedataList.size() > 0) {
            return;
        }
        if (this.connection == null) {
            return;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int[] nArray = this.fields2Index(this.markFields);
        int[] nArray2 = this.fields2Index(this.parentmarkFields);
        int[] nArray3 = this.fields2Index(this.treeField);
        int n = this.getRealColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        try {
            while (this.resultSet.next()) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    try {
                        objectArray[i] = DataUtils.getResultSetObject(this.resultSet, this.realColumnInformations[i].getColumnType(), i + 1, string, string2, dialect);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        objectArray[i] = null;
                    }
                }
                TreeAccessData treeAccessData = new TreeAccessData(this.getSelectedFields(objectArray, nArray), this.getSelectedFields(objectArray, nArray2), objectArray[nArray3[0]]);
                this.databaseList.add(objectArray);
                this.treedataList.add(treeAccessData);
            }
            this.executeRelation(this.treedataList);
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                FRContext.getLogger().log(Level.WARNING, "Error happens while releaseConnection");
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "initial treeTable Error!");
        }
    }

    private void executeRelation(List list) {
        int n = list.size();
        block0: for (int i = 0; i < n; ++i) {
            TreeAccessData treeAccessData = (TreeAccessData)list.get(i);
            if (this.checkNullArray(treeAccessData.getParentmark())) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TreeAccessData treeAccessData2 = (TreeAccessData)iterator.next();
                if (treeAccessData == treeAccessData2 || !this.checkMark(treeAccessData2.getMark(), treeAccessData.getParentmark())) continue;
                treeAccessData.setParentData(treeAccessData2);
                continue block0;
            }
        }
        this.fireAddedFieldLength(list);
    }

    public boolean checkNullArray(String[] stringArray) {
        if (ArrayUtils.isEmpty(stringArray)) {
            return true;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public void fireAddedFieldLength(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeAccessData treeAccessData = (TreeAccessData)iterator.next();
            if (n >= treeAccessData.extendLength()) continue;
            n = treeAccessData.extendLength();
        }
        this.addedFieldLength = n;
    }

    public boolean checkMark(String[] stringArray, String[] stringArray2) {
        if (stringArray.length == stringArray2.length) {
            boolean bl = true;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(stringArray2[i])) continue;
                bl = false;
                break;
            }
            if (bl) {
                return bl;
            }
        } else {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer = stringBuffer.append(stringArray[n]);
            }
            n2 = stringArray2.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer2 = stringBuffer2.append(stringArray2[n]);
            }
            if (stringBuffer.toString().equals(stringBuffer2.toString())) {
                return true;
            }
        }
        return false;
    }

    public String[] getSelectedFields(Object[] objectArray, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectArray[nArray[i]] == null || objectArray[nArray[i]].equals(Primitive.NULL) ? null : objectArray[nArray[i]].toString();
        }
        return stringArray;
    }

    public int[] fields2Index(String[] stringArray) throws TableDataException {
        if (this.realColumnInformations == null) {
            this.checkRealColumn();
        }
        int[] nArray = new int[stringArray.length];
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            int n2 = this.realColumnInformations.length;
            for (int j = 0; j < n2; ++j) {
                if (!string.equals(this.realColumnInformations[j].getColumnName())) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public int getRowCount() throws TableDataException {
        this.hasRow(Integer.MAX_VALUE);
        return this.databaseList.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        if (this.hasRow(n)) {
            if (n2 < this.getRealColumnCount()) {
                return ((Object[])this.databaseList.get(n))[n2];
            }
            return ((TreeAccessData)this.treedataList.get(n)).getData(n2 - this.getRealColumnCount());
        }
        return null;
    }

    protected boolean hasRow(int n) throws TableDataException {
        this.initData();
        return n < this.databaseList.size();
    }

    protected void initRowValueStatus() {
        this.databaseList = new ArrayList();
        this.treedataList = new ArrayList();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void checkRealColumn() throws TableDataException {
        if (this.realColumnInformations != null) {
            return;
        }
        Object[] objectArray = new Object[]{new String[0], new int[0], new String[0]};
        Connection connection = null;
        connection = this.database.createConnection();
        this.realColumnInformations = DBUtils.checkInColumnInformation(connection, this.sql, 0);
        Object var5_3 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.INFO, sQLException.getMessage(), sQLException);
        }
        return;
        {
            catch (Exception exception) {
                this.realColumnInformations = new ColumnInformation[0];
                throw new TableDataException("Query: \"" + this.sql + "\"\n" + exception.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.INFO, sQLException.getMessage(), sQLException);
            }
            throw throwable;
        }
    }

    protected synchronized void checkInColumn() throws TableDataException {
        if (this.columnInformations != null) {
            return;
        }
        if (this.realColumnInformations == null) {
            this.checkRealColumn();
        }
        int[] nArray = this.fields2Index(this.treeField);
        this.columnInformations = (ColumnInformation[])ArrayUtils.addAll(this.realColumnInformations, this.createAddedField(nArray[0]));
    }

    private ColumnInformation[] createAddedField(int n) throws TableDataException {
        if (this.limitGeneration <= 0 && this.addedFieldLength == 0) {
            this.initData();
        }
        int n2 = this.limitGeneration > 0 ? this.limitGeneration : this.getAddedFieldLength();
        ColumnInformation[] columnInformationArray = new ColumnInformation[n2];
        for (int i = 0; i < n2; ++i) {
            columnInformationArray[i] = new ColumnInformation(this.defaultFieldName + i, n, this.defaultFieldName + i);
        }
        return columnInformationArray;
    }

    protected synchronized void release() throws SQLException {
        if (this.databaseList != null) {
            this.databaseList.clear();
        }
        if (this.treedataList != null) {
            this.treedataList.clear();
        }
        this.isCheckRowOver = false;
        super.release();
    }
}

