/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.ListSet;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.plot.PlotUtils;
import com.fr.data.AbstractChartData;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.util.SortOrder;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.NoneFunction;
import com.fr.util.Utils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class TableChartData
extends AbstractChartData {
    private static final long serialVersionUID = -8007807601939859337L;
    public static final String XML_TAG = "TableChartData";
    private TableData baseTableData;
    private int categoryLabelIndex;
    private int seriesIndex;
    private int[] seriesIndexArray;
    private int summaryColumnIndex = -1;
    private int[] summaryColumnIndexArray = new int[]{-1};
    private DataFunction[] summaryFunctionArray;
    private ListSet categoryLabelListSet = new ListSet();
    private ListSet seriesLabelListSet = new ListSet();
    private Map valueFunctionMap = new HashMap();
    private boolean isCheckedIn = false;
    private boolean isthird = false;
    private static final String NULL_VALUE = "_N_U_L_L_V_A_L_U_E_$";
    private int null_index = 0;

    public TableChartData() {
    }

    public TableChartData(TableData tableData, int[] nArray, SortOrder[] sortOrderArray, int[] nArray2, DataFunction[] dataFunctionArray) {
        if (nArray.length > 0 && nArray2.length > 0) {
            if (nArray.length == 1) {
                if (nArray2.length == 1) {
                    this.thirdChartData(tableData, nArray[0], sortOrderArray[0], nArray2[0], dataFunctionArray[0]);
                } else {
                    this.firstChartData(tableData, nArray[0], sortOrderArray[0], nArray2, dataFunctionArray);
                }
            } else {
                this.secondChartData(tableData, nArray, sortOrderArray, nArray2[0], dataFunctionArray[0]);
            }
        }
    }

    private TableData getBaseTableData() {
        return this.baseTableData;
    }

    private void firstChartData(TableData tableData, int n, SortOrder sortOrder, int[] nArray, DataFunction[] dataFunctionArray) {
        this.baseTableData = tableData;
        this.setCategoryLabelIndex(n);
        this.setSeriesIndexArray(nArray);
        this.setSummaryColumnIndexArray(nArray);
        this.setSummaryFunctionArray(dataFunctionArray);
    }

    private void secondChartData(TableData tableData, int[] nArray, SortOrder[] sortOrderArray, int n, DataFunction dataFunction) {
        this.baseTableData = tableData;
        this.setCategoryLabelIndex(nArray[0]);
        this.setSeriesIndex(nArray[1]);
        this.setSummaryColumnIndex(n);
        this.setSummaryFunctionArray(new DataFunction[]{dataFunction});
    }

    private void thirdChartData(TableData tableData, int n, SortOrder sortOrder, int n2, DataFunction dataFunction) {
        this.isthird = true;
        this.baseTableData = tableData;
        this.setCategoryLabelIndex(n);
        this.setSeriesIndex(n2);
        this.setSummaryColumnIndex(n2);
        this.setSummaryFunctionArray(new DataFunction[]{dataFunction});
    }

    public int getCategoryLabelIndex() {
        return this.categoryLabelIndex;
    }

    public void setCategoryLabelIndex(int n) {
        this.categoryLabelIndex = n;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int n) {
        this.seriesIndex = n;
    }

    public int[] getSeriesIndexArray() {
        return this.seriesIndexArray;
    }

    public void setSeriesIndexArray(int[] nArray) {
        this.seriesIndexArray = nArray;
    }

    public int getSummaryColumnIndex() {
        return this.summaryColumnIndex;
    }

    public void setSummaryColumnIndex(int n) {
        this.summaryColumnIndex = n;
    }

    public int[] getSummaryColumnIndexArray() {
        return this.summaryColumnIndexArray;
    }

    public void setSummaryColumnIndexArray(int[] nArray) {
        this.summaryColumnIndexArray = nArray;
    }

    public DataFunction[] getSummaryFunctionArray() {
        return this.summaryFunctionArray;
    }

    public void setSummaryFunctionArray(DataFunction[] dataFunctionArray) {
        int n = dataFunctionArray.length;
        for (int i = 0; i < n; ++i) {
            if (dataFunctionArray[i] != null) continue;
            dataFunctionArray[i] = new NoneFunction();
        }
        this.summaryFunctionArray = dataFunctionArray;
    }

    public int getCategoryLabelCount() {
        this.checkInData();
        if (this.categoryLabelListSet == null) {
            return 0;
        }
        return this.categoryLabelListSet.size();
    }

    public int getSeriesCount() {
        this.checkInData();
        if (this.seriesLabelListSet == null) {
            return 0;
        }
        if (this.isthird) {
            return Math.min(this.seriesLabelListSet.size(), 1);
        }
        return this.seriesLabelListSet.size();
    }

    public Object getCategoryLabel(int n) {
        this.checkInData();
        Object object = ((ObjectName)this.categoryLabelListSet.get(n)).getObjectThing();
        return object.toString().startsWith(NULL_VALUE) ? "" : object;
    }

    public Object getSeriesLabel(int n) {
        this.checkInData();
        return ((ObjectName)this.seriesLabelListSet.get(n)).getObjectThing();
    }

    private Object innerGetValueAt(int n, int n2) {
        this.checkInData();
        ObjectName objectName = (ObjectName)this.categoryLabelListSet.get(n2);
        ObjectName objectName2 = (ObjectName)this.seriesLabelListSet.get(n);
        XlabelSeriesMultiKey xlabelSeriesMultiKey = this.getXlabelSeriesMultiKey(objectName, objectName2);
        DataFunction dataFunction = (DataFunction)this.valueFunctionMap.get(xlabelSeriesMultiKey);
        if (dataFunction == null) {
            return null;
        }
        return dataFunction.getResult();
    }

    public Number getValueAt(int n, int n2) {
        Object object = this.innerGetValueAt(n, n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        try {
            return Double.valueOf(Utils.objectToString(object));
        }
        catch (Exception exception) {
            return PlotUtils.dateToNumber(this.innerGetValueAt(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkInData() {
        block29: {
            if (this.isCheckedIn) {
                return;
            }
            this.categoryLabelListSet.clear();
            this.seriesLabelListSet.clear();
            this.valueFunctionMap.clear();
            if (this.summaryFunctionArray == null) {
                this.isCheckedIn = true;
                return;
            }
            TableData tableData = this.getBaseTableData();
            if (this.summaryFunctionArray.length == 1) {
                int n = tableData.getRowCount();
                for (int i = 0; i < n; ++i) {
                    ObjectName objectName;
                    Serializable serializable;
                    Object object = tableData.getValueAt(i, this.categoryLabelIndex);
                    Object object2 = tableData.getValueAt(i, this.seriesIndex);
                    ObjectName objectName2 = new ObjectName(object);
                    if (this.isthird) {
                        serializable = new StringBuffer();
                        if (!(this.summaryFunctionArray[0] instanceof NoneFunction)) {
                            ((StringBuffer)serializable).append(DataUtils.getFunctionDisplayName(this.summaryFunctionArray[0]));
                            ((StringBuffer)serializable).append("[");
                        }
                        ((StringBuffer)serializable).append(tableData.getColumnName(this.seriesIndex));
                        if (!(this.summaryFunctionArray[0] instanceof NoneFunction)) {
                            ((StringBuffer)serializable).append("]");
                        }
                        objectName = new ObjectName(((StringBuffer)serializable).toString());
                    } else {
                        objectName = new ObjectName(object2);
                    }
                    serializable = this.getXlabelSeriesMultiKey(objectName2, objectName);
                    DataFunction dataFunction = (DataFunction)this.valueFunctionMap.get(serializable);
                    if (dataFunction == null) {
                        this.categoryLabelListSet.add(objectName2);
                        this.seriesLabelListSet.add(objectName);
                        try {
                            dataFunction = (DataFunction)this.summaryFunctionArray[0].clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            continue;
                        }
                        this.valueFunctionMap.put(serializable, dataFunction);
                    }
                    if (this.summaryColumnIndex < 0 || this.summaryColumnIndex >= tableData.getColumnCount()) continue;
                    try {
                        dataFunction.addData(tableData.getValueAt(i, this.summaryColumnIndex));
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            } else {
                int n = this.seriesIndexArray.length;
                int n2 = tableData.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    Object object = tableData.getValueAt(i, this.categoryLabelIndex);
                    ObjectName objectName = new ObjectName(object);
                    for (int j = 0; j < n; ++j) {
                        ObjectName objectName3;
                        XlabelSeriesMultiKey xlabelSeriesMultiKey;
                        DataFunction dataFunction;
                        StringBuffer stringBuffer = new StringBuffer();
                        if (!(this.summaryFunctionArray[j] instanceof NoneFunction)) {
                            stringBuffer.append(DataUtils.getFunctionDisplayName(this.summaryFunctionArray[j]));
                            stringBuffer.append("[");
                        }
                        stringBuffer.append(tableData.getColumnName(this.seriesIndexArray[j]));
                        if (!(this.summaryFunctionArray[0] instanceof NoneFunction)) {
                            stringBuffer.append("]");
                        }
                        if ((dataFunction = (DataFunction)this.valueFunctionMap.get(xlabelSeriesMultiKey = this.getXlabelSeriesMultiKey(objectName, objectName3 = new ObjectName(stringBuffer.toString())))) == null) {
                            this.categoryLabelListSet.add(objectName);
                            this.seriesLabelListSet.add(objectName3);
                            try {
                                dataFunction = (DataFunction)this.summaryFunctionArray[j].clone();
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                continue;
                            }
                            this.valueFunctionMap.put(xlabelSeriesMultiKey, dataFunction);
                        }
                        dataFunction.addData(tableData.getValueAt(i, this.seriesIndexArray[j]));
                    }
                }
            }
            Object var14_25 = null;
            try {
                tableData.release();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
            break block29;
            {
                catch (TableDataException tableDataException) {
                    FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                    Object var14_26 = null;
                    try {
                        tableData.release();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_27 = null;
                try {
                    tableData.release();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
                throw throwable;
            }
        }
        this.isCheckedIn = true;
    }

    private XlabelSeriesMultiKey getXlabelSeriesMultiKey(ObjectName objectName, ObjectName objectName2) {
        return new XlabelSeriesMultiKey(objectName, objectName2);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = null;
            if (string.equals("TableData")) {
                this.baseTableData = DataXMLUtils.readXMLTableData(xMLableReader);
            } else if (string.equals("Attr")) {
                string2 = xMLableReader.getAttr("categoryLabelIndex");
                if (string2 != null) {
                    this.setCategoryLabelIndex(Utils.string2Number(string2).intValue());
                }
                if ((string2 = xMLableReader.getAttr("seriesIndex")) != null) {
                    this.setSeriesIndex(Utils.string2Number(string2).intValue());
                }
                if ((string2 = xMLableReader.getAttr("summaryColumnIndex")) != null) {
                    this.setSummaryColumnIndex(Utils.string2Number(string2).intValue());
                }
                if ((string2 = xMLableReader.getAttr("isCheckIn")) != null) {
                    this.isCheckedIn = Boolean.valueOf(string2);
                }
                if ((string2 = xMLableReader.getAttr("isThird")) != null) {
                    this.isthird = Boolean.valueOf(string2);
                }
            } else if (string.equals("SeriesIndexArray")) {
                if (this.seriesIndexArray == null) {
                    this.seriesIndexArray = new int[]{Integer.valueOf(xMLableReader.getAttr("value"))};
                } else {
                    int[] nArray = this.seriesIndexArray;
                    this.seriesIndexArray = new int[nArray.length + 1];
                    System.arraycopy(nArray, 0, this.seriesIndexArray, 0, nArray.length);
                    this.seriesIndexArray[nArray.length] = Integer.valueOf(xMLableReader.getAttr("value"));
                }
            } else if (string.equals("SummaryColumnIndexArray")) {
                if (this.summaryColumnIndexArray == null) {
                    this.summaryColumnIndexArray = new int[]{Integer.valueOf(xMLableReader.getAttr("value"))};
                } else {
                    int[] nArray = this.summaryColumnIndexArray;
                    this.summaryColumnIndexArray = new int[nArray.length + 1];
                    System.arraycopy(nArray, 0, this.summaryColumnIndexArray, 0, nArray.length);
                    this.summaryColumnIndexArray[nArray.length] = Integer.valueOf(xMLableReader.getAttr("value"));
                }
            } else if (string.equals("SeriesLabelListSet")) {
                this.categoryLabelListSet.add(xMLableReader.getAttr("value"));
            } else if (string.equals("CategoryLabelListSet")) {
                this.seriesLabelListSet.add(xMLableReader.getAttr("value"));
            } else if (string.equals("SummaryFunctionArray")) {
                if (this.summaryFunctionArray == null) {
                    this.summaryFunctionArray = new DataFunction[]{DataXMLUtils.readXMLDataFunction(string2)};
                } else {
                    DataFunction[] dataFunctionArray = this.summaryFunctionArray;
                    this.summaryFunctionArray = new DataFunction[dataFunctionArray.length + 1];
                    System.arraycopy(dataFunctionArray, 0, this.summaryFunctionArray, 0, dataFunctionArray.length);
                    this.summaryFunctionArray[dataFunctionArray.length] = DataXMLUtils.readXMLDataFunction(string2);
                }
            } else if (string.equals("ValueFunctionMap")) {
                int n = -1;
                string2 = xMLableReader.getAttr("key");
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
                DataFunction dataFunction = null;
                string2 = xMLableReader.getAttr("value");
                if (string2 != null) {
                    dataFunction = DataXMLUtils.readXMLDataFunction(string2);
                }
                if (n != -1) {
                    this.valueFunctionMap.put(new Integer(n), dataFunction);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.baseTableData != null) {
            DataXMLUtils.writeXMLTableData(xMLPrintWriter, this.baseTableData);
        }
        xMLPrintWriter.startTAG("Attr").attr("categoryLabelIndex", this.categoryLabelIndex).attr("seriesIndex", this.seriesIndex).attr("summaryColumnIndex", this.summaryColumnIndex).attr("isCheckIn", this.isCheckedIn).attr("isThird", this.isthird);
        if (this.seriesIndexArray != null && this.seriesIndexArray.length > 0) {
            for (n = 0; n < this.seriesIndexArray.length; ++n) {
                xMLPrintWriter.startTAG("SeriesIndexArray").attr("value", this.seriesIndexArray[n]).end();
            }
        }
        if (this.summaryColumnIndexArray != null && this.summaryColumnIndexArray.length > 0) {
            for (n = 0; n < this.summaryColumnIndexArray.length; ++n) {
                xMLPrintWriter.startTAG("SummaryColumnIndexArray").attr("value", this.summaryColumnIndexArray[n]).end();
            }
        }
        if (this.categoryLabelListSet != null && this.categoryLabelListSet.size() > 0) {
            for (n = 0; n < this.categoryLabelListSet.size(); ++n) {
                xMLPrintWriter.startTAG("CategoryLabelListSet").attr("value", this.categoryLabelListSet.get(n).toString()).end();
            }
        }
        if (this.seriesLabelListSet != null && this.seriesLabelListSet.size() > 0) {
            for (n = 0; n < this.seriesLabelListSet.size(); ++n) {
                xMLPrintWriter.startTAG("SeriesLabelListSet").attr("value", this.seriesLabelListSet.get(n).toString()).end();
            }
        }
        if (this.summaryFunctionArray != null && this.summaryFunctionArray.length > 0) {
            for (n = 0; n < this.summaryFunctionArray.length; ++n) {
                xMLPrintWriter.startTAG("SummaryFunctionArray").attr("function", this.summaryFunctionArray[n].getClass().getName()).end();
            }
        }
        if (this.valueFunctionMap != null && this.valueFunctionMap.size() > 0) {
            for (n = 0; n < this.valueFunctionMap.size(); ++n) {
                xMLPrintWriter.startTAG("ValueFunctionMap").attr("key", n).attr("value", this.valueFunctionMap.get(new Integer(n)).toString()).end();
            }
        }
        xMLPrintWriter.end();
    }

    class XlabelSeriesMultiKey
    implements Serializable {
        private ObjectName XlabelObjectName;
        private ObjectName SeriesMultiName;

        public XlabelSeriesMultiKey(ObjectName objectName, ObjectName objectName2) {
            this.setXlabelObjectName(objectName);
            this.setSeriesMultiName(objectName2);
        }

        public ObjectName getXlabelObjectName() {
            return this.XlabelObjectName;
        }

        public void setXlabelObjectName(ObjectName objectName) {
            this.XlabelObjectName = objectName;
        }

        public ObjectName getSeriesMultiName() {
            return this.SeriesMultiName;
        }

        public void setSeriesMultiName(ObjectName objectName) {
            this.SeriesMultiName = objectName;
        }

        public int hashCode() {
            return this.XlabelObjectName.hashCode() + this.SeriesMultiName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof XlabelSeriesMultiKey)) {
                return false;
            }
            XlabelSeriesMultiKey xlabelSeriesMultiKey = (XlabelSeriesMultiKey)object;
            return ComparatorUtils.equals(xlabelSeriesMultiKey.getXlabelObjectName(), this.getXlabelObjectName()) && ComparatorUtils.equals(xlabelSeriesMultiKey.getSeriesMultiName(), this.getSeriesMultiName());
        }

        public String toString() {
            return this.getXlabelObjectName().toString() + " " + this.getSeriesMultiName().toString();
        }
    }

    class ObjectName
    implements Serializable {
        private Object objectThing;

        public ObjectName(Object object) {
            this.setObjectThing(object);
        }

        public Object getObjectThing() {
            return this.objectThing;
        }

        public int hashCode() {
            return this.objectThing.hashCode();
        }

        public void setObjectThing(Object object) {
            if (object == null || object.toString().trim().length() == 0) {
                StringBuffer stringBuffer = new StringBuffer(TableChartData.NULL_VALUE);
                stringBuffer.append(TableChartData.this.null_index);
                TableChartData.this.null_index++;
                this.objectThing = stringBuffer.toString();
            } else {
                this.objectThing = object;
            }
        }

        public boolean equals(Object object) {
            return object instanceof ObjectName && ComparatorUtils.equals(((ObjectName)object).getObjectThing(), this.getObjectThing());
        }

        public String toString() {
            if (this.objectThing == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.objectThing.toString());
            return stringBuffer.toString();
        }
    }
}

