/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.cache.store.Status;
import com.fr.data.TableDataException;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseConnection;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public abstract class TableDataAdapter
implements Serializable {
    protected Set registedDBTableData = new HashSet();
    protected DatabaseConnection database;
    protected String sql;
    protected int resultIndexOfOut;
    protected transient Connection connection;
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    protected transient boolean isCheckRowOver = false;
    protected transient ColumnInformation[] columnInformations = null;
    protected Status status = Status.STATUS_UNINITIALISED;
    protected transient Dialect dialect = null;
    protected transient int shortcutRowCount = -1;

    protected TableDataAdapter() {
        this(null, null, 0);
    }

    protected TableDataAdapter(DatabaseConnection databaseConnection, String string, int n) {
        this.database = databaseConnection;
        this.sql = string;
        this.resultIndexOfOut = n;
        this.status = Status.STATUS_ALIVE;
        this.dealSQLCharset();
    }

    private void dealSQLCharset() {
        if (StringUtils.isNotBlank(this.database.getOriginalCharsetName()) && StringUtils.isNotBlank(this.database.getNewCharsetName())) {
            try {
                this.sql = new String(this.sql.getBytes(this.database.getNewCharsetName()), this.database.getOriginalCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRContext.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
    }

    public final synchronized void register(DBTableData dBTableData) {
        this.registedDBTableData.add(dBTableData);
    }

    public final synchronized void unRegister(DBTableData dBTableData) {
        this.registedDBTableData.remove(dBTableData);
    }

    public int getColumnCount() throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations.length;
    }

    public String getColumnName(int n) throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations[n].getColumnName();
    }

    protected abstract void initRowValueStatus();

    protected synchronized void initConnectionAndResultAndCheckInColumns() throws TableDataException {
        if (this.connection != null) {
            return;
        }
        this.initRowValueStatus();
        try {
            if (this.database == null) {
                throw new TableDataException(Inter.getLocText("Utils-Connection_can_not_be_null"));
            }
            this.connection = this.database.createConnection();
            if (this.connection == null) {
                throw new TableDataException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + this.database.toString());
            }
            FRContext.getLogger().log(Level.INFO, "SQL:\n" + this.sql);
            if (DBUtils.isProcedure(this.sql)) {
                Object[] objectArray = DBUtils.remoteProcedureCall(this.connection, this.sql, this.resultIndexOfOut);
                this.statement = (Statement)objectArray[0];
                this.resultSet = (ResultSet)objectArray[1];
            } else {
                Dialect dialect;
                if (this.dialect == null) {
                    this.dialect = DialectFactory.generateDialect(this.connection);
                }
                if ((dialect = DialectFactory.generateDialect(this.connection)) instanceof MSSQLDialect) {
                    this.statement = this.connection.prepareCall(this.sql);
                    this.resultSet = ((CallableStatement)this.statement).executeQuery();
                } else {
                    this.statement = this.connection.createStatement();
                    if (dialect.getFetchSize() > 0) {
                        this.statement.setFetchSize(dialect.getFetchSize());
                    }
                    this.resultSet = this.statement.executeQuery(this.sql);
                }
            }
            if (this.columnInformations == null) {
                this.columnInformations = DBUtils.checkInColumnInformationByMetaData(this.resultSet.getMetaData());
            }
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new TableDataException("Query:" + this.sql + "\n" + exception.getMessage(), exception);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void checkInColumn() throws TableDataException {
        if (this.columnInformations != null) {
            return;
        }
        Connection connection = null;
        connection = this.database.createConnection();
        this.columnInformations = DBUtils.checkInColumnInformation(connection, this.sql, this.resultIndexOfOut);
        Object var4_2 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.INFO, sQLException.getMessage(), sQLException);
        }
        return;
        {
            catch (Exception exception) {
                this.columnInformations = new ColumnInformation[0];
                throw new TableDataException("Query: \"" + this.sql + "\"\n" + exception.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.INFO, sQLException.getMessage(), sQLException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int shortcutGetRowCount() {
        if (this.shortcutRowCount != -1) return this.shortcutRowCount;
        Connection connection = null;
        connection = this.database.createConnection();
        if (this.dialect == null) {
            this.dialect = DialectFactory.generateDialect(connection);
        }
        String string = this.dialect.getCountSql(this.sql);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        this.shortcutRowCount = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        Object var6_6 = null;
        if (connection == null) return this.shortcutRowCount;
        try {
            connection.close();
            return this.shortcutRowCount;
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        return this.shortcutRowCount;
        {
            catch (Exception exception) {
                this.shortcutRowCount = Integer.MIN_VALUE;
                Object var6_7 = null;
                if (connection == null) return this.shortcutRowCount;
                try {
                    connection.close();
                    return this.shortcutRowCount;
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                }
                return this.shortcutRowCount;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
            throw throwable;
        }
    }

    public abstract int getRowCount() throws TableDataException;

    public abstract Object getValueAt(int var1, int var2) throws TableDataException;

    protected abstract boolean hasRow(int var1) throws TableDataException;

    public final synchronized void tryDestroy() throws SQLException {
        if (this.registedDBTableData.isEmpty()) {
            this.destroy();
        }
    }

    private final synchronized void destroy() throws SQLException {
        if (this.status != Status.STATUS_SHUTDOWN) {
            this.release();
            this.status = Status.STATUS_SHUTDOWN;
        }
    }

    protected void release() throws SQLException {
        this.releaseConnection();
    }

    protected synchronized void releaseConnection() throws SQLException {
        if (this.connection != null) {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
            this.connection.close();
            this.connection = null;
            this.statement = null;
            this.resultSet = null;
        }
    }

    public synchronized void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

