/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.TableData;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.data.impl.NameTableData;
import com.fr.report.script.Calculator;
import java.util.Iterator;
import java.util.List;

public class TableDataDictionary
extends FormulaDisplayDictionary {
    private TableData tableData;
    private transient List kvs;

    public TableDataDictionary() {
        this(TableData.EMPTY_TABLEDATA, 0, 1);
    }

    public TableDataDictionary(TableData tableData, int n, int n2) {
        this.setTableData(tableData);
        this.setKeyColumnIndex(n);
        this.setValueColumnIndex(n2);
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public void reset() {
        this.kvs = null;
    }

    private void createKVS(Calculator calculator) {
        if (this.kvs == null) {
            this.kvs = this.createMVList(this.getTableData(), calculator);
        }
    }

    public Object get(Object object, Calculator calculator) {
        this.createKVS(calculator);
        int n = this.kvs.size();
        for (int i = 0; i < n; ++i) {
            Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i);
            if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    public String[] getDependence() {
        return super.getDependence();
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ("TableDataDictAttr".equals(string = xMLableReader.getTagName()) || "TableDataMapAttr".equals(string))) {
            String string2 = xMLableReader.getAttr("keyColumnIndex");
            if (string2 != null) {
                this.setKeyColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttr("valueColumnIndex")) != null) {
                this.setValueColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttr("tableDataName")) != null) {
                this.setTableData(new NameTableData(string2));
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        if ("TableData".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.setTableData(DataXMLUtils.readXMLTableData(xMLableReader));
                        }
                        if ("Condition".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.condition = DataXMLUtils.readCondition(xMLableReader);
                        }
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("TableDataDictAttr");
        DataXMLUtils.writeXMLTableData(xMLPrintWriter, this.getTableData());
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableDataDictionary)) {
            return false;
        }
        return super.equals(object);
    }

    public String toString() {
        return "TableDataDict[" + this.getTableData() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        TableDataDictionary tableDataDictionary = (TableDataDictionary)super.clone();
        return tableDataDictionary;
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < TableDataDictionary.this.kvs.size();
        }

        public Object next() {
            Object e = TableDataDictionary.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

