/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DirectoryConnection;
import com.fr.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class TextTableData
extends AbstractTableData
implements XMLable {
    private DirectoryConnection directoryConnection;
    private String delimiter = null;
    private boolean isIgnoreOneMoreDelimiter = true;
    private String filePath = null;
    private List columnNameList = new ArrayList();
    private int columnCount = 0;
    private List rowValueList = new ArrayList();
    private boolean isInitialed = false;
    private boolean needColumnName = false;

    public DirectoryConnection getDirectoryConnection() {
        return this.directoryConnection;
    }

    public void setDirectoryConnection(DirectoryConnection directoryConnection) {
        this.directoryConnection = directoryConnection;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean needColumnName() {
        return this.needColumnName;
    }

    public void setNeedColumnName(boolean bl) {
        this.needColumnName = bl;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public boolean isIgnoreOneMoreDelimiter() {
        return this.isIgnoreOneMoreDelimiter;
    }

    public void setIgnoreOneMoreDelimiter(boolean bl) {
        this.isIgnoreOneMoreDelimiter = bl;
    }

    public int getColumnCount() {
        this.loadColumnName();
        return this.columnNameList.size();
    }

    public String getColumnName(int n) {
        this.loadColumnName();
        String string = n < this.columnNameList.size() ? this.columnNameList.get(n).toString() : null;
        return string;
    }

    public int getRowCount() {
        this.initial();
        return this.rowValueList.size();
    }

    public Object getValueAt(int n, int n2) {
        this.initial();
        List list = (List)this.rowValueList.get(n);
        return n2 < list.size() ? list.get(n2) : null;
    }

    private void loadColumnName() {
        File file = new File(this.directoryConnection.getLocation());
        if (!file.isDirectory()) {
            return;
        }
        this.columnNameList.clear();
        if (this.needColumnName) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath}))));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = Utils.splitString(string, this.delimiter);
                    if ((string = string.trim()) == null || string.length() <= 0) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.columnNameList.add(stringArray[i].trim());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath}))));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    ArrayList arrayList = new ArrayList();
                    String[] stringArray = Utils.splitString(string, this.delimiter);
                    if ((string = string.trim()) == null || string.length() <= 0) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.columnNameList.add("#" + (i + 1));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initial() {
        if (this.isInitialed) {
            return;
        }
        File file = new File(this.directoryConnection.getLocation());
        if (!file.isDirectory()) {
            return;
        }
        this.rowValueList.clear();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(BaseCoreUtils.pathJoin(new String[]{file.getPath(), this.filePath}))));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                string = string.trim();
                String[] stringArray = Utils.splitString(string, this.delimiter);
                if (this.isIgnoreOneMoreDelimiter()) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n].equals("")) continue;
                        arrayList.add(stringArray[n].trim());
                    }
                } else {
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList.add(stringArray[n].trim());
                    }
                }
                this.rowValueList.add(arrayList);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.columnCount = this.columnNameList.size();
        if (!this.needColumnName) {
            this.columnNameList.clear();
            for (int i = 0; i < 4; ++i) {
                this.columnNameList.add("#" + (i + 1));
            }
        } else {
            this.rowValueList.remove(0);
        }
        this.isInitialed = true;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            Connection connection;
            String string = xMLableReader.getTagName();
            if ("TextTableDataAttr".equals(string)) {
                String string2 = xMLableReader.getAttr("delimiter");
                if (string2 != null) {
                    if (string2.equals("TTT")) {
                        this.setDelimiter("\t");
                    } else {
                        this.setDelimiter(string2);
                    }
                }
                if ((string2 = xMLableReader.getAttr("filePath")) != null) {
                    this.filePath = string2;
                }
                if ((string2 = xMLableReader.getAttr("needColumnName")) != null) {
                    if (string2.equals("true")) {
                        this.setNeedColumnName(true);
                    } else {
                        this.setNeedColumnName(false);
                    }
                }
                if ((string2 = xMLableReader.getAttr("isIgnoreOneMoreDelimiter")) != null) {
                    if (string2.equals("true")) {
                        this.setIgnoreOneMoreDelimiter(true);
                    } else {
                        this.setIgnoreOneMoreDelimiter(false);
                    }
                }
            } else if ("Connection".equals(string) && (connection = DataXMLUtils.readXMLConnection(xMLableReader)) instanceof DirectoryConnection) {
                this.directoryConnection = (DirectoryConnection)connection;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        String string = this.delimiter;
        if (string.equals("\t")) {
            string = "TTT";
        }
        xMLPrintWriter.startTAG("TextTableDataAttr").attr("delimiter", string).attr("needColumnName", this.needColumnName()).attr("isIgnoreOneMoreDelimiter", this.isIgnoreOneMoreDelimiter()).attr("filePath", this.getFilePath()).end();
        if (this.directoryConnection != null) {
            DataXMLUtils.writeXMLConnection(xMLPrintWriter, this.directoryConnection);
        }
    }

    public boolean equals(Object object) {
        return object instanceof TextTableData && this.isIgnoreOneMoreDelimiter == ((TextTableData)object).isIgnoreOneMoreDelimiter && this.needColumnName == ((TextTableData)object).needColumnName && ComparatorUtils.equals(this.delimiter, ((TextTableData)object).delimiter) && ComparatorUtils.equals(this.filePath, ((TextTableData)object).filePath) && ComparatorUtils.equals(this.directoryConnection, ((TextTableData)object).directoryConnection);
    }
}

