/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.FRContext;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.TableDataAdapter;
import java.sql.SQLException;
import java.util.logging.Level;

public final class UnCacheAdapter
extends TableDataAdapter {
    private transient int currentRowIndex = -1;
    private transient int _rowCount = 0;
    private transient Object[] currentRowValue = null;
    private transient Object[] lastRowValue = null;

    public UnCacheAdapter(DatabaseConnection databaseConnection, String string) {
        super(databaseConnection, string, 0);
    }

    protected void initRowValueStatus() {
        this.currentRowIndex = -1;
        this.currentRowValue = new Object[0];
        this._rowCount = 0;
        this.lastRowValue = null;
    }

    protected boolean hasRow(int n) throws TableDataException {
        if (this.currentRowIndex >= n) {
            return true;
        }
        this.initConnectionAndResultAndCheckInColumns();
        if (this.connection == null) {
            return false;
        }
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n2 = this.getColumnCount();
        try {
            String string = this.database.getOriginalCharsetName();
            String string2 = this.database.getNewCharsetName();
            while (this.resultSet.next()) {
                ++this.currentRowIndex;
                if (this.currentRowIndex < n) continue;
                this.lastRowValue = this.currentRowValue;
                this.currentRowValue = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    try {
                        this.currentRowValue[i] = DataUtils.getResultSetObject(this.resultSet, this.columnInformations[i].getColumnType(), i + 1, string, string2, dialect);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.currentRowValue[i] = null;
                    }
                }
                return true;
            }
            this._rowCount = this.currentRowIndex + 1;
            this.currentRowIndex = -1;
            this.isCheckRowOver = true;
            this.releaseConnection();
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.isCheckRowOver = true;
            throw new TableDataException(exception.getMessage() + "\nQuery is:" + this.sql + "\nrowIndex to get is:" + n, exception);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        if (this.currentRowIndex < n) {
            this.hasRow(n);
        } else if (this.currentRowIndex - 1 > n) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
            this.currentRowIndex = -1;
            this.hasRow(n);
        }
        if (this.currentRowIndex - 1 == n && this.lastRowValue != null && this.currentRowValue.length > n2 && n2 >= 0) {
            return this.lastRowValue[n2];
        }
        if (this.currentRowIndex == n && this.currentRowValue.length > n2 && n2 >= 0) {
            return this.currentRowValue[n2];
        }
        return null;
    }

    public int getRowCount() throws TableDataException {
        int n = this.shortcutGetRowCount();
        if (n < 0) {
            FRContext.getLogger().log(Level.WARNING, "Can not get the row count!");
            return 0;
        }
        return n;
    }
}

