/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.AbstractTableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.define.DataSource;
import com.fr.data.core.define.XMLColumnNameDateType;
import com.fr.data.core.define.XMLColumnNameType;
import com.fr.util.Utils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class XMLTableData
extends AbstractTableData
implements XMLable {
    private static final long serialVersionUID = 1L;
    private DataSource dataSource = null;
    protected List row_list = null;
    private String[] xPath = null;
    private String charSet = "UTF-8";
    private XMLColumnNameType[] columns = new XMLColumnNameType[0];
    public static final int COLUMN_TYPE_STRING = 0;
    public static final int COLUMN_TYPE_NUMBER = 1;
    public static final int COLUMN_TYPE_DATE = 2;
    public static final int COLUMN_TYPE_BOOLEAN = 3;

    public String[] getXPath() {
        return this.xPath;
    }

    public void setXPath(String[] stringArray) {
        this.xPath = stringArray;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    public XMLColumnNameType[] getColumns() {
        return this.columns;
    }

    public void setColumns(XMLColumnNameType[] xMLColumnNameTypeArray) {
        this.columns = xMLColumnNameTypeArray;
    }

    public int getColumnCount() throws TableDataException {
        return this.columns.length;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getColumnName(int n) throws TableDataException {
        if (n < 0 || n >= this.columns.length) {
            return null;
        }
        String string = this.columns[n] == null ? null : this.columns[n].getName();
        return string;
    }

    public int getRowCount() throws TableDataException {
        this.init();
        return this.row_list.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        this.init();
        if (n < 0 || n >= this.row_list.size() || n2 < 0 || n2 >= this.columns.length) {
            return null;
        }
        return ((Object[])this.row_list.get(n))[n2];
    }

    protected void init() throws TableDataException {
        if (this.row_list != null) {
            return;
        }
        this.checkNameAndType();
        try {
            InputStream inputStream = this.getDataSourceStream();
            this.readerXMLSource(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            throw new TableDataException(exception.getMessage(), exception);
        }
    }

    protected InputStream getDataSourceStream() throws Exception {
        return this.dataSource.getSourceStream(this.getParameters());
    }

    protected void readerXMLSource(InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charSet);
        this.readXMLSource(inputStreamReader);
    }

    protected void readXMLSource(Reader reader) throws Exception {
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(reader);
        if (xMLableReader != null) {
            this.row_list = new ArrayList();
            xMLableReader.readXMLObject(new ReadXMLLayer(0));
        }
    }

    protected void checkNameAndType() throws TableDataException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) {
                throw new TableDataException("Column index:" + i + " is null");
            }
            if (StringUtils.isBlank(this.columns[i].getName())) {
                throw new TableDataException("ColumnName index:" + i + " is null");
            }
            if (this.columns[i].getType() != 2 || this.columns[i] instanceof XMLColumnNameDateType) continue;
            throw new TableDataException("ColumnType index:" + i + " is not a date");
        }
    }

    private static Object convertStringValue(String string, XMLColumnNameType xMLColumnNameType) throws Exception {
        if (xMLColumnNameType.getType() == 0) {
            return string;
        }
        if (xMLColumnNameType.getType() == 1) {
            return Utils.string2Number(string);
        }
        if (xMLColumnNameType.getType() == 3) {
            return new Boolean(string);
        }
        if (xMLColumnNameType.getType() == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(((XMLColumnNameDateType)xMLColumnNameType).getFormat());
            return simpleDateFormat.parse(string);
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("CharSet".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.charSet = string2.trim();
                }
            } else if ("XPath".equals(string)) {
                String string3 = xMLableReader.getAttr("length");
                if (string3 != null) {
                    this.xPath = new String[Integer.parseInt(string3.trim())];
                    xMLableReader.readXMLObject(new XMLReadable(){
                        String tmpV;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "XPathElem".equals(xMLableReader.getTagName()) && (this.tmpV = xMLableReader.getAttr("idx")) != null) {
                                int n = Integer.parseInt(this.tmpV.trim());
                                this.tmpV = xMLableReader.getElementValue();
                                if (this.tmpV != null) {
                                    ((XMLTableData)XMLTableData.this).xPath[n] = this.tmpV.trim();
                                }
                            }
                        }
                    });
                }
            } else if ("Columns".equals(string)) {
                String string4 = xMLableReader.getAttr("length");
                if (string4 != null) {
                    this.columns = new XMLColumnNameType[Integer.parseInt(string4.trim())];
                    xMLableReader.readXMLObject(new XMLReadable(){
                        String tmpV;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "ColumnElem".equals(xMLableReader.getTagName()) && (this.tmpV = xMLableReader.getAttr("idx")) != null) {
                                int n = Integer.parseInt(this.tmpV.trim());
                                boolean bl = false;
                                this.tmpV = xMLableReader.getAttr("isdate");
                                if (this.tmpV != null) {
                                    bl = new Boolean(this.tmpV.trim());
                                }
                                XMLColumnNameType xMLColumnNameType = bl ? new XMLColumnNameDateType() : new XMLColumnNameType();
                                xMLableReader.readXMLObject(xMLColumnNameType);
                                ((XMLTableData)XMLTableData.this).columns[n] = xMLColumnNameType;
                            }
                        }
                    });
                }
            } else if ("DataSource".equals(string)) {
                this.dataSource = DataXMLUtils.readXMLDataSource(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        if (!"UTF-8".equals(this.charSet)) {
            xMLPrintWriter.startTAG("CharSet").textNode(this.charSet).end();
        }
        if (this.xPath != null) {
            xMLPrintWriter.startTAG("XPath").attr("length", this.xPath.length);
            for (n = 0; n < this.xPath.length; ++n) {
                if (this.xPath[n] == null) continue;
                xMLPrintWriter.startTAG("XPathElem").attr("idx", n).textNode(this.xPath[n]).end();
            }
            xMLPrintWriter.end();
        }
        if (this.columns != null) {
            xMLPrintWriter.startTAG("Columns").attr("length", this.columns.length);
            for (n = 0; n < this.columns.length; ++n) {
                if (this.columns[n] == null) continue;
                xMLPrintWriter.startTAG("ColumnElem").attr("idx", n).attr("isdate", this.columns[n].getType() == 2);
                this.columns[n].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (this.dataSource != null) {
            DataXMLUtils.writeXMLDataSource(xMLPrintWriter, this.dataSource);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLTableData)) {
            return false;
        }
        XMLTableData xMLTableData = (XMLTableData)object;
        return object instanceof XMLTableData && super.equals(object) && ComparatorUtils.equals(this.dataSource, xMLTableData.dataSource) && ComparatorUtils.equals(this.charSet, xMLTableData.charSet) && ComparatorUtils.equals(this.columns, xMLTableData.columns) && ComparatorUtils.equals(this.xPath, xMLTableData.xPath);
    }

    public Object clone() throws CloneNotSupportedException {
        XMLTableData xMLTableData = (XMLTableData)super.clone();
        if (this.columns != null) {
            XMLColumnNameType[] xMLColumnNameTypeArray = new XMLColumnNameType[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                xMLColumnNameTypeArray[i] = (XMLColumnNameType)this.columns[i].clone();
            }
            xMLTableData.setColumns(xMLColumnNameTypeArray);
        }
        if (this.dataSource != null) {
            xMLTableData.setDataSource((DataSource)this.dataSource.clone());
        }
        if (this.xPath != null) {
            xMLTableData.setXPath((String[])this.xPath.clone());
        }
        return xMLTableData;
    }

    private class ReadXMLColumn
    implements XMLReadable {
        private Object[] objects = null;

        public ReadXMLColumn(Object[] objectArray) {
            this.objects = objectArray;
        }

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                for (int i = 0; i < XMLTableData.this.columns.length; ++i) {
                    if (!XMLTableData.this.columns[i].getName().equals(string)) continue;
                    String string2 = xMLableReader.getElementValue();
                    Object object = null;
                    if (string2 != null) {
                        try {
                            object = XMLTableData.convertStringValue(string2.trim(), XMLTableData.this.columns[i]);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Exception with ColumnName:" + string + ", Value:" + string2 + ".\n" + exception.getMessage(), exception);
                        }
                    }
                    this.objects[i] = object;
                    break;
                }
            }
        }
    }

    private class ReadXMLLayer
    implements XMLReadable {
        private int layer = -1;

        public ReadXMLLayer(int n) {
            this.layer = n;
        }

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (this.layer < 0) {
                return;
            }
            if (xMLableReader.isAttr() && !(string = XMLTableData.this.xPath[this.layer]).equals(xMLableReader.getTagName())) {
                this.layer = -1;
            }
            if (xMLableReader.isChildNode() && XMLTableData.this.xPath.length > this.layer + 1 && (string = XMLTableData.this.xPath[this.layer + 1]).equals(xMLableReader.getTagName())) {
                if (XMLTableData.this.xPath.length == this.layer + 2) {
                    Object[] objectArray = new Object[XMLTableData.this.columns.length];
                    xMLableReader.readXMLObject(new ReadXMLColumn(objectArray));
                    XMLTableData.this.row_list.add(objectArray);
                } else {
                    xMLableReader.readXMLObject(new ReadXMLLayer(this.layer + 1));
                }
            }
        }
    }
}

