/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.pool;

import com.fr.data.pool.ConnectionPoolManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class MemoryConnection
implements Connection {
    private Connection con;
    private String log;
    private ConnectionPoolManager pm;

    public MemoryConnection(Connection connection) {
        this.con = connection;
        this.log = connection.toString() + " is running!";
        if (this.pm == null) {
            this.pm = ConnectionPoolManager.getConnectionPoolManager();
        }
        this.pm.addLog(this.log);
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        this.pm.removeLog(this.log);
        this.con.close();
    }

    public void commit() throws SQLException {
        this.con.commit();
    }

    public Statement createStatement() throws SQLException {
        return this.con.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.con.createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.con.createStatement(n, n2, n3);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        return this.con.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.con.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.con.prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.con.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.con.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.con.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.con.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.con.prepareStatement(string, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.con.prepareStatement(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.con.prepareStatement(string, n, n2, n3);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.con.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.con.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.con.setCatalog(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.con.setHoldability(n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.con.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.con.setSavepoint();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.con.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }
}

