/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.data.util.function.AverageFunction;
import com.fr.data.util.function.CountFunction;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.MaxFunction;
import com.fr.data.util.function.MinFunction;
import com.fr.data.util.function.NoneFunction;
import com.fr.data.util.function.SumFunction;

public abstract class AbstractDataFunction
implements DataFunction {
    public static final int NULL = 0;
    public static final int SUM = 1;
    public static final int COUNT = 2;
    public static final int AVERAGE = 3;
    public static final int MAX = 4;
    public static final int MIN = 5;
    public static final int NONE = 6;

    public static DataFunction createDataFunction(int n) {
        switch (n) {
            case 1: {
                return new SumFunction();
            }
            case 2: {
                return new CountFunction();
            }
            case 3: {
                return new AverageFunction();
            }
            case 4: {
                return new MaxFunction();
            }
            case 5: {
                return new MinFunction();
            }
            case 6: {
                return new NoneFunction();
            }
        }
        return null;
    }

    public static int createDataFunctionIndex(DataFunction dataFunction) {
        if (dataFunction instanceof SumFunction) {
            return 1;
        }
        if (dataFunction instanceof CountFunction) {
            return 2;
        }
        if (dataFunction instanceof AverageFunction) {
            return 3;
        }
        if (dataFunction instanceof MaxFunction) {
            return 4;
        }
        if (dataFunction instanceof MinFunction) {
            return 5;
        }
        if (dataFunction instanceof NoneFunction) {
            return 6;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractDataFunction)) {
            return false;
        }
        return this.getClass().equals(object.getClass());
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDataFunction abstractDataFunction = (AbstractDataFunction)super.clone();
        abstractDataFunction.reset();
        return abstractDataFunction;
    }
}

