/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.data.util.function.AbstractDataFunction;
import com.fr.report.script.Primitive;
import com.fr.report.script.core.FunctionHelper;

public class AverageFunction
extends AbstractDataFunction {
    private double sumResult;
    private double countResult;

    public AverageFunction() {
        this.reset();
    }

    public void reset() {
        this.sumResult = 0.0;
        this.countResult = 0.0;
    }

    public void addData(Object object) {
        if (object == null || object == Primitive.NULL) {
            return;
        }
        if (object instanceof Number) {
            this.sumResult += ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.sumResult += 1.0;
            }
        } else {
            try {
                this.sumResult += Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.countResult += 1.0;
    }

    public Object getResult() {
        return FunctionHelper.parsePrimitiveDouble(this.countResult == 0.0 ? 0.0 : this.sumResult / this.countResult);
    }

    public String getFormula() {
        return "average";
    }
}

