/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.IntList;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.data.core.DataUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.GroupResultSequenceNameSpace;
import com.fr.report.script.SingleRowNameSpace;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.ConditionalOrExpression;
import com.fr.report.script.core.parser.DatasetFunctionCall;
import com.fr.report.script.core.parser.InterpreterError;
import com.fr.report.script.core.parser.UtilEvalError;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class DataSetFunction {
    public Object resolveDatasetFunction(DatasetFunctionCall datasetFunctionCall) {
        String string = datasetFunctionCall.getFnName().toLowerCase();
        Object object = null;
        if ("select".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("selectfirst".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("group".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'G');
        } else if ("xselect".equals(string)) {
            object = this.resolveXFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("xselectfirst".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("xgroup".equals(string)) {
            object = this.resolveXFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'G');
        } else {
            if ("colcount".equals(string)) {
                return this.resolveColumnCount(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            }
            if ("colname".equals(string)) {
                return this.resolveColumnName(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            }
            if ("column".equals(string)) {
                object = this.resolveColumn(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            } else {
                if ("value".equals(string)) {
                    return this.resolveValue(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
                }
                FRContext.getLogger().log(Level.WARNING, "not supported function name: " + string);
                return null;
            }
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            if (string.endsWith("selectfirst")) {
                return fArray.length() > 0 ? fArray.elementAt(0) : null;
            }
            return fArray.length() == 1 ? fArray.elementAt(0) : fArray;
        }
        return object;
    }

    protected int[] fn_source_filter(ConditionalOrExpression conditionalOrExpression, int[] nArray, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        if (conditionalOrExpression != null) {
            IntList intList = new IntList();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                singleRowNameSpace.setRowIndex(n);
                try {
                    if (!Boolean.TRUE.equals(conditionalOrExpression.eval(calculator))) continue;
                    intList.add(n);
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    String string = "error happens at calculate formula\nformula expression is " + conditionalOrExpression + "\nerror message is " + utilEvalError.getMessage();
                    FRContext.getLogger().log(Level.WARNING, string, utilEvalError);
                }
            }
            nArray = intList.toArray();
        }
        return nArray;
    }

    protected Object[] fn_cc_ex_result(ConditionalOrExpression conditionalOrExpression, int[] nArray, TableData tableData, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        Object[] objectArray = new Object[nArray.length];
        String string = conditionalOrExpression.toString();
        int n = Integer.MIN_VALUE;
        n = this.col_name_2_col_index(tableData, string);
        if (n >= -1) {
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = DataUtils.getTableDataValue(tableData, nArray[i], n);
            }
            return objectArray;
        }
        try {
            string = conditionalOrExpression.eval(calculator).toString();
            n = this.col_name_2_col_index(tableData, string);
            if (n >= -1) {
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = DataUtils.getTableDataValue(tableData, nArray[i], n);
                }
                return objectArray;
            }
        }
        catch (UtilEvalError utilEvalError) {
        }
        catch (InterpreterError interpreterError) {
            // empty catch block
        }
        GroupResultSequenceNameSpace groupResultSequenceNameSpace = new GroupResultSequenceNameSpace();
        calculator.pushNameSpace(groupResultSequenceNameSpace);
        for (int i = 0; i < nArray.length; ++i) {
            String string2;
            int n2 = nArray[i];
            singleRowNameSpace.setRowIndex(n2);
            try {
                objectArray[i] = conditionalOrExpression.eval(calculator);
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                string2 = "error happens at calculate formula\nformula expression: \"" + conditionalOrExpression + "\"" + "\nerror message: " + utilEvalError.getMessage();
                FRContext.getLogger().log(Level.WARNING, string2, utilEvalError);
                continue;
            }
            catch (InterpreterError interpreterError) {
                string2 = "\"" + conditionalOrExpression + "\"" + " can not be resolved as a column" + "\nformula expression: " + "\"" + conditionalOrExpression + "\"" + "\nerror message: " + interpreterError.getMessage();
                FRContext.getLogger().log(Level.INFO, string2, interpreterError);
                String string3 = conditionalOrExpression.toString();
                Arrays.fill(objectArray, string3);
                break;
            }
        }
        calculator.removeNameSpace(groupResultSequenceNameSpace);
        return objectArray;
    }

    protected int col_name_2_col_index(TableData tableData, String string) {
        int n = Integer.MIN_VALUE;
        if (string.matches("^\\w+$")) {
            try {
                int n2 = tableData.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    if (!ComparatorUtils.tableDataColumnNameEquals(string, tableData.getColumnName(i))) continue;
                    n = i;
                }
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        } else if (string.matches("^#\\d+$")) {
            int n3 = Integer.parseInt(string.substring(1));
            try {
                if (n3 <= tableData.getColumnCount() && n3 >= 0) {
                    n = n3 - 1;
                }
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        return n;
    }

    public abstract Object resolveFunction(String var1, ConditionalOrExpression[] var2, char var3);

    public abstract Object resolveXFunction(String var1, ConditionalOrExpression[] var2, char var3);

    public abstract Object resolveColumnCount(String var1, ConditionalOrExpression[] var2);

    public abstract Object resolveColumnName(String var1, ConditionalOrExpression[] var2);

    public abstract Object resolveColumn(String var1, ConditionalOrExpression[] var2);

    public abstract Object resolveValue(String var1, ConditionalOrExpression[] var2);
}

