/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.base.FComparator;
import com.fr.base.core.ComparatorUtils;
import com.fr.data.util.DefaultComparator;
import com.fr.data.util.function.AbstractDataFunction;
import com.fr.report.script.Primitive;

public class MinFunction
extends AbstractDataFunction {
    private FComparator comparator = null;
    private Object minResult = new Double(Double.MAX_VALUE);

    public MinFunction() {
        this(null);
    }

    public MinFunction(FComparator fComparator) {
        if (fComparator == null) {
            fComparator = new DefaultComparator();
        }
        this.setComparator(fComparator);
        this.reset();
    }

    public FComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(FComparator fComparator) {
        this.comparator = fComparator;
    }

    public void reset() {
        this.minResult = null;
    }

    public void addData(Object object) {
        if (object == null || ComparatorUtils.equals(Primitive.NULL, object)) {
            return;
        }
        if (this.minResult == null) {
            this.minResult = object;
            return;
        }
        int n = this.comparator.compare(this.minResult, object);
        if (n > 0) {
            this.minResult = object;
        }
    }

    public Object getResult() {
        return this.minResult;
    }

    public String getFormula() {
        return "min";
    }
}

