/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.data.util.function.AbstractDataFunction;
import com.fr.report.script.core.FunctionHelper;

public class SumFunction
extends AbstractDataFunction {
    private double sumResult;

    public SumFunction() {
        this.reset();
    }

    public void reset() {
        this.sumResult = 0.0;
    }

    public void addData(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Number) {
            this.sumResult += ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.sumResult += 1.0;
            }
        } else {
            try {
                this.sumResult += Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Object getResult() {
        return FunctionHelper.parsePrimitiveDouble(this.sumResult);
    }

    public String getFormula() {
        return "sum";
    }
}

