/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog;

import com.fr.base.Inter;
import com.fr.dialog.DialogActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class BaseDialog
extends JDialog {
    protected int returnValue = 1;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton helpButton;
    protected List listeners = new ArrayList();

    protected BaseDialog(Frame frame) {
        super(frame);
    }

    protected BaseDialog(Dialog dialog) {
        super(dialog);
    }

    protected void initComponents() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        jPanel.setLayout(new BorderLayout(0, 4));
        this.applyClosingAction();
        this.applyEscapeAction();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaseDialog.this.doCancel();
            }
        });
    }

    public void addDialogActionListener(DialogActionListener dialogActionListener) {
        this.listeners.add(dialogActionListener);
    }

    public void clearDialogActionListeners() {
        this.listeners.clear();
    }

    protected JPanel createControlButtonPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "East");
        jPanel2.setLayout(new GridLayout(1, 2, 6, 0));
        this.okButton = new JButton(Inter.getLocText("OK"));
        this.okButton.setMnemonic('O');
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.doOK();
            }
        });
        this.cancelButton = new JButton(Inter.getLocText("Cancel"));
        this.cancelButton.setMnemonic('C');
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.doCancel();
            }
        });
        this.helpButton = new JButton(Inter.getLocText("Help"));
        this.helpButton.setMnemonic('H');
        if (this.isShowHelpButton()) {
            jPanel2.add(this.helpButton);
        }
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.doHelp();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        return jPanel;
    }

    protected JPanel createControlButtonPane(String string) {
        JPanel jPanel = this.createControlButtonPane();
        if (string != null) {
            this.okButton.setText(string);
        }
        return jPanel;
    }

    protected JPanel createControlButtonPane(String string, String string2) {
        JPanel jPanel = this.createControlButtonPane();
        if (string != null) {
            this.okButton.setText(string);
        }
        if (string2 != null) {
            this.okButton.setText(string);
        }
        return jPanel;
    }

    protected boolean isShowHelpButton() {
        return false;
    }

    public void doOK() {
        try {
            this.checkValid();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            return;
        }
        this.setReturnValue(0);
        this.dialogExit();
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            DialogActionListener dialogActionListener = (DialogActionListener)this.listeners.get(i);
            if (dialogActionListener == null) continue;
            dialogActionListener.doOk();
        }
    }

    public void doCancel() {
        this.setReturnValue(1);
        this.dialogExit();
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            DialogActionListener dialogActionListener = (DialogActionListener)this.listeners.get(i);
            if (dialogActionListener == null) continue;
            dialogActionListener.doCancel();
        }
    }

    public void doHelp() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            DialogActionListener dialogActionListener = (DialogActionListener)this.listeners.get(i);
            if (dialogActionListener == null) continue;
            dialogActionListener.doHelp();
        }
    }

    public void checkValid() throws Exception {
    }

    private void dialogExit() {
        this.setVisible(false);
        this.dispose();
    }

    private void applyClosingAction() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaseDialog.this.setReturnValue(1);
                BaseDialog.this.dialogExit();
            }
        });
    }

    protected void applyEscapeAction() {
        JPanel jPanel = (JPanel)this.getContentPane();
        InputMap inputMap = jPanel.getInputMap(1);
        ActionMap actionMap = jPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "dialogExit");
        actionMap.put("dialogExit", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.dialogExit();
            }

            public void removeDialogActionListener(DialogActionListener dialogActionListener) {
                BaseDialog.this.listeners.remove(dialogActionListener);
            }
        });
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(int n) {
        this.returnValue = n;
    }

    public Point getOKPosition() {
        return this.okButton.getLocationOnScreen();
    }

    public JButton getOKButton() {
        return this.okButton;
    }
}

