/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.cell.GUIUtils;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.BaseDialog;
import com.fr.dialog.core.ColumnRowPane;
import com.fr.dialog.core.ReportPageAttrPane;
import com.fr.dialog.core.UnitFieldPane;
import com.fr.report.Margin;
import com.fr.report.PaperSize;
import com.fr.report.Report;
import com.fr.report.ReportConstants;
import com.fr.report.ReportSettings;
import com.fr.report.core.ReportUtils;
import com.fr.util.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PageSetupDialog
extends BaseDialog {
    private PagePane pagePane;
    private OtherPane otherPane;
    private JPanel controlButtonPane;
    private boolean useLocale = false;

    public static PageSetupDialog showWindow(Window window) {
        if (window instanceof Frame) {
            return new PageSetupDialog((Frame)window);
        }
        return new PageSetupDialog((Dialog)window);
    }

    protected PageSetupDialog(Frame frame) {
        super(frame);
        this.initComponents();
    }

    protected PageSetupDialog(Dialog dialog) {
        super(dialog);
        this.initComponents();
    }

    protected void initComponents() {
        super.initComponents();
        JPanel jPanel = (JPanel)this.getContentPane();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        this.pagePane = new PagePane();
        this.otherPane = new OtherPane();
        jTabbedPane.addTab(Inter.getLocText("PageSetup-Page"), this.pagePane);
        jTabbedPane.addTab(Inter.getLocText("Other"), this.otherPane);
        this.controlButtonPane = this.createControlButtonPane();
        jPanel.add((Component)this.controlButtonPane, "South");
        this.setTitle(Inter.getLocText("PageSetup-Page_Setup"));
        this.setSize(420, 480);
        this.setModal(true);
        GUIUtils.centerWindow(this);
    }

    public void populate(Report report) {
        if (report == null) {
            return;
        }
        this.pagePane.populate(ReportUtils.getReportSettings(report));
        this.otherPane.populate(report);
    }

    public void update(Report report) {
        if (report == null) {
            return;
        }
        this.pagePane.update(report);
        this.otherPane.update(report);
    }

    public void checkValid() throws Exception {
        super.checkValid();
    }

    class OtherPane
    extends JPanel {
        private JRadioButton topBottomRadioButton;
        private JRadioButton leftRightRadioButton;
        private JCheckBox horizonalCenterCheckBox;
        private JCheckBox verticalCenterCheckBox;
        private JSpinner firstPageNumberSpinner;
        private JCheckBox freezeCheckBox;
        private CardLayout freezeCard;
        private JPanel freezeShowPane;
        private ColumnRowPane frozenColumnRow;
        private ReportPageAttrPane reportPageAttrPane;
        private JRadioButton isShrinkToFit4None;
        private JRadioButton isShrinkToFit4Height;
        private JRadioButton isShrinkToFit4Width;
        private JCheckBox singlePagePrint;

        public OtherPane() {
            this.setLayout(LayoutFactory.createBorderLayout());
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "North");
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel.add(jPanel2);
            jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("PageSetup-Page_Order")));
            jPanel2.setLayout(new GridLayout(1, 2));
            Icon icon = BaseUtils.readIcon("/com/fr/dialog/images/pagesetup/down.png");
            this.topBottomRadioButton = new JRadioButton(Inter.getLocText("PageSetup-Top_to_bottom"));
            jPanel2.add(this.createIconRadioPane(icon, this.topBottomRadioButton));
            this.topBottomRadioButton.setMnemonic('B');
            Icon icon2 = BaseUtils.readIcon("/com/fr/dialog/images/pagesetup/over.png");
            this.leftRightRadioButton = new JRadioButton(Inter.getLocText("PageSetup-Left_to_right"));
            jPanel2.add(this.createIconRadioPane(icon2, this.leftRightRadioButton));
            this.leftRightRadioButton.setMnemonic('R');
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.topBottomRadioButton);
            buttonGroup.add(this.leftRightRadioButton);
            this.topBottomRadioButton.setSelected(true);
            JPanel jPanel3 = new JPanel();
            jPanel.add(jPanel3);
            jPanel3.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("PageSetup-Placement_Center_on_Page")));
            jPanel3.setLayout(new GridLayout(1, 2));
            this.horizonalCenterCheckBox = new JCheckBox(Inter.getLocText("PageSetup-Horizontally"));
            this.horizonalCenterCheckBox.setMnemonic('H');
            this.verticalCenterCheckBox = new JCheckBox(Inter.getLocText("PageSetup-Vertically"));
            this.verticalCenterCheckBox.setMnemonic('V');
            jPanel3.add(GUICoreUtils.createFlowPane(this.horizonalCenterCheckBox, 1));
            jPanel3.add(GUICoreUtils.createFlowPane(this.verticalCenterCheckBox, 1));
            this.singlePagePrint = new JCheckBox("\u5355\u9875\u6253\u5370");
            JPanel jPanel4 = GUICoreUtils.createFlowPane(this.singlePagePrint, 1);
            jPanel4.setBorder(BorderFactory.createTitledBorder("\u6253\u5370\u8bbe\u7f6e"));
            jPanel.add(jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel.add(jPanel5);
            jPanel5.setLayout(new FlowLayout(0, 2, 5));
            jPanel5.add(new JLabel(Inter.getLocText("PageSetup-First_Page_Number") + ": "));
            this.firstPageNumberSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.firstPageNumberSpinner.getEditor()).getTextField();
            jFormattedTextField.setColumns(2);
            jPanel5.add(this.firstPageNumberSpinner);
            jPanel.add(Box.createVerticalStrut(4));
            this.reportPageAttrPane = new ReportPageAttrPane();
            jPanel.add(this.reportPageAttrPane);
            JPanel jPanel6 = new JPanel();
            jPanel.add(jPanel6);
            jPanel6.setLayout(new FlowLayout(0, 4, 2));
            jPanel6.add(new JLabel(Inter.getLocText("Freeze-Use_In_Write") + ":"));
            this.freezeCheckBox = new JCheckBox();
            jPanel6.add(this.freezeCheckBox);
            this.freezeCard = new CardLayout();
            this.freezeShowPane = new JPanel(this.freezeCard);
            this.freezeShowPane.add("none", new JPanel());
            this.frozenColumnRow = new ColumnRowPane();
            this.freezeShowPane.add("frozen", this.frozenColumnRow);
            jPanel6.add(this.freezeShowPane);
            this.freezeCheckBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ OtherPane this$1;
                {
                    this.this$1 = otherPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (OtherPane.access$800(this.this$1).isSelected()) {
                        OtherPane.access$1000(this.this$1).show(OtherPane.access$900(this.this$1), "frozen");
                    } else {
                        OtherPane.access$1000(this.this$1).show(OtherPane.access$900(this.this$1), "none");
                    }
                }
            });
            jPanel.add(Box.createVerticalStrut(4));
            JPanel jPanel7 = new JPanel();
            jPanel.add(jPanel7);
            jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            jPanel7.setLayout(new GridLayout(1, 1, 0, 0));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new FlowLayout(0, 5, 0));
            jPanel8.add(new JLabel(Inter.getLocText("PageSetup-Shrink_to_fit_content")));
            this.isShrinkToFit4None = new JRadioButton(Inter.getLocText("No"));
            this.isShrinkToFit4Height = new JRadioButton(Inter.getLocText("Utils-Row_Height"));
            this.isShrinkToFit4Width = new JRadioButton(Inter.getLocText("Utils-Column_Width"));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            jPanel8.add(this.isShrinkToFit4None);
            jPanel8.add(this.isShrinkToFit4Height);
            jPanel8.add(this.isShrinkToFit4Width);
            buttonGroup2.add(this.isShrinkToFit4None);
            buttonGroup2.add(this.isShrinkToFit4Height);
            buttonGroup2.add(this.isShrinkToFit4Width);
            jPanel7.add(jPanel8);
        }

        private JPanel createIconRadioPane(Icon icon, JRadioButton jRadioButton) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(new JLabel(icon));
            jPanel.add(jRadioButton);
            return jPanel;
        }

        public void populate(Report report) {
            ReportSettings reportSettings = null;
            reportSettings = ReportUtils.getReportSettings(report);
            if (reportSettings == null) {
                reportSettings = new ReportSettings();
            }
            if (reportSettings.getPageOrder() == 1) {
                this.leftRightRadioButton.setSelected(true);
            } else {
                this.topBottomRadioButton.setSelected(true);
            }
            this.horizonalCenterCheckBox.setSelected(reportSettings.isHorizontalCenterOnPage());
            this.verticalCenterCheckBox.setSelected(reportSettings.isVerticalCenterOnPage());
            this.firstPageNumberSpinner.setValue(new Integer(reportSettings.getFirstPageNumber()));
            if (reportSettings.getWriteFrozenColumnRow() != null) {
                this.freezeCheckBox.setSelected(true);
                this.freezeCard.show(this.freezeShowPane, "frozen");
                this.frozenColumnRow.populate(reportSettings.getWriteFrozenColumnRow());
            }
            this.reportPageAttrPane.populate(report.getReportPageAttr());
            if (reportSettings.getShrinkToFitMode() == 2) {
                this.isShrinkToFit4Width.setSelected(true);
            } else if (reportSettings.getShrinkToFitMode() == 1) {
                this.isShrinkToFit4Height.setSelected(true);
            } else {
                this.isShrinkToFit4None.setSelected(true);
            }
            this.singlePagePrint.setSelected(reportSettings.isLonelyPage());
        }

        public void update(Report report) {
            ReportSettings reportSettings = null;
            if (report.getReportSettings() == null) {
                report.setReportSettings(new ReportSettings());
            }
            reportSettings = report.getReportSettings();
            if (this.leftRightRadioButton.isSelected()) {
                reportSettings.setPageOrder(1);
            } else {
                reportSettings.setPageOrder(0);
            }
            reportSettings.setHorizontalCenterOnPage(this.horizonalCenterCheckBox.isSelected());
            reportSettings.setVerticalCenterOnPage(this.verticalCenterCheckBox.isSelected());
            reportSettings.setFirstPageNumber((Integer)this.firstPageNumberSpinner.getValue());
            report.setReportPageAttr(this.reportPageAttrPane.update());
            if (this.freezeCheckBox.isSelected()) {
                reportSettings.setWriteFrozenColumnRow(this.frozenColumnRow.update());
            } else {
                reportSettings.setWriteFrozenColumnRow(null);
            }
            if (this.isShrinkToFit4Width.isSelected()) {
                reportSettings.setShrinkToFitMode(2);
            } else if (this.isShrinkToFit4Height.isSelected()) {
                reportSettings.setShrinkToFitMode(1);
            } else {
                reportSettings.setShrinkToFitMode(0);
            }
            reportSettings.setLonelyPage(this.singlePagePrint.isSelected());
        }

        static /* synthetic */ JCheckBox access$800(OtherPane otherPane) {
            return otherPane.freezeCheckBox;
        }

        static /* synthetic */ JPanel access$900(OtherPane otherPane) {
            return otherPane.freezeShowPane;
        }

        static /* synthetic */ CardLayout access$1000(OtherPane otherPane) {
            return otherPane.freezeCard;
        }
    }

    class PagePane
    extends JPanel {
        private JRadioButton portraitRadioButton;
        private JRadioButton landscapeRadioButton;
        private JRadioButton predefinedRadioButton;
        private JRadioButton customRadioButton;
        private JComboBox predefinedComboBox;
        private JSpinner paperWidthSpinner;
        private JSpinner paperHeightSpinner;
        private UnitFieldPane marginTopUnitFieldPane;
        private UnitFieldPane marginLeftUnitFieldPane;
        private UnitFieldPane marginBottomUnitFieldPane;
        private UnitFieldPane marginRightUnitFieldPane;
        private UnitFieldPane headerUnitFieldPane;
        private UnitFieldPane footerUnitFieldPane;
        private ShowPagePane showPagePane;
        private ActionListener previewListener = new ActionListener(this){
            private final /* synthetic */ PagePane this$1;
            {
                this.this$1 = pagePane;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PagePane.access$100(this.this$1);
            }
        };
        private ChangeListener previewListener2 = new ChangeListener(this){
            private final /* synthetic */ PagePane this$1;
            {
                this.this$1 = pagePane;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                PagePane.access$100(this.this$1);
            }
        };
        private DefaultListCellRenderer paperSizeCellRenderere = new DefaultListCellRenderer(this){
            private final /* synthetic */ PagePane this$1;
            {
                this.this$1 = pagePane;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof PaperSize) {
                    PaperSize paperSize = (PaperSize)object;
                    for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
                        Object[] objectArray = ReportConstants.PaperSizeNameSizeArray[i];
                        if (!ComparatorUtils.equals(paperSize, objectArray[1])) continue;
                        StringBuffer stringBuffer = new StringBuffer(objectArray[0].toString());
                        stringBuffer.append(" [");
                        Locale locale = FRContext.getLocale();
                        if (PageSetupDialog.access$000(PagePane.access$200(this.this$1))) {
                            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                                stringBuffer.append(Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters2Show(paperSize.getWidth())));
                                stringBuffer.append("x");
                                stringBuffer.append(Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters2Show(paperSize.getHeight())));
                                stringBuffer.append(" ");
                                stringBuffer.append(Inter.getLocText("PageSetup-mm"));
                            } else {
                                stringBuffer.append(paperSize.getWidth());
                                stringBuffer.append("x");
                                stringBuffer.append(paperSize.getHeight());
                                stringBuffer.append(" ");
                                stringBuffer.append(Inter.getLocText("PageSetup-inches"));
                            }
                        } else {
                            stringBuffer.append(Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters2Show(paperSize.getWidth())));
                            stringBuffer.append("x");
                            stringBuffer.append(Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters2Show(paperSize.getHeight())));
                            stringBuffer.append(" ");
                            stringBuffer.append(Inter.getLocText("PageSetup-mm"));
                        }
                        stringBuffer.append("]");
                        this.setText(stringBuffer.toString());
                        break;
                    }
                }
                return this;
            }
        };
        private ItemListener paperSizeItemListener = new ItemListener(this){
            private final /* synthetic */ PagePane this$1;
            {
                this.this$1 = pagePane;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                PaperSize paperSize = (PaperSize)PagePane.access$300(this.this$1).getSelectedItem();
                Locale locale = FRContext.getLocale();
                if (PageSetupDialog.access$000(PagePane.access$200(this.this$1))) {
                    if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                        PagePane.access$400(this.this$1).setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
                        PagePane.access$500(this.this$1).setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
                    } else {
                        PagePane.access$400(this.this$1).setValue(new Double(paperSize.getWidth()));
                        PagePane.access$500(this.this$1).setValue(new Double(paperSize.getHeight()));
                    }
                } else {
                    PagePane.access$400(this.this$1).setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
                    PagePane.access$500(this.this$1).setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
                }
                PagePane.access$600(this.this$1).setSelected(true);
                PagePane.access$100(this.this$1);
            }
        };
        DocumentListener customTextListener = new DocumentListener(this){
            private final /* synthetic */ PagePane this$1;
            {
                this.this$1 = pagePane;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.fireTextEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.fireTextEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.fireTextEvent();
            }

            private void fireTextEvent() {
                PagePane.access$700(this.this$1).setSelected(((Number)PagePane.access$400(this.this$1).getValue()).doubleValue() > 0.0 && ((Number)PagePane.access$500(this.this$1).getValue()).doubleValue() > 0.0);
            }
        };

        public PagePane() {
            Object object;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "North");
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel.add(jPanel2);
            jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("PageSetup-Orientation")));
            jPanel2.setLayout(new GridLayout(1, 2));
            Icon icon = BaseUtils.readIcon("/com/fr/dialog/images/pagesetup/portrait.png");
            this.portraitRadioButton = new JRadioButton(Inter.getLocText("PageSetup-Portrait"));
            this.portraitRadioButton.setMnemonic('t');
            jPanel2.add(this.createIconRadioPane(icon, this.portraitRadioButton));
            this.portraitRadioButton.addActionListener(this.previewListener);
            Icon icon2 = BaseUtils.readIcon("/com/fr/dialog/images/pagesetup/landScape.png");
            this.landscapeRadioButton = new JRadioButton(Inter.getLocText("PageSetup-Landscape"));
            this.landscapeRadioButton.setMnemonic('L');
            jPanel2.add(this.createIconRadioPane(icon2, this.landscapeRadioButton));
            this.landscapeRadioButton.addActionListener(this.previewListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.portraitRadioButton);
            buttonGroup.add(this.landscapeRadioButton);
            this.portraitRadioButton.setSelected(true);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(1));
            this.showPagePane = new ShowPagePane();
            jPanel3.add(this.showPagePane);
            jPanel.add(jPanel3);
            jPanel3.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Preview")));
            JPanel jPanel4 = new JPanel();
            jPanel.add(jPanel4);
            jPanel4.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("PageSetup-Paper_Size")));
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            this.predefinedRadioButton = new JRadioButton(Inter.getLocText("PageSetup-Predefined") + ":");
            this.predefinedRadioButton.setMnemonic('P');
            this.predefinedRadioButton.addActionListener(this.previewListener);
            this.customRadioButton = new JRadioButton(Inter.getLocText("Custom") + ":");
            this.customRadioButton.setMnemonic('C');
            this.customRadioButton.addActionListener(this.previewListener);
            this.predefinedComboBox = new JComboBox();
            this.paperWidthSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
            ((JSpinner.DefaultEditor)this.paperWidthSpinner.getEditor()).getTextField().setColumns(7);
            this.paperHeightSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
            ((JSpinner.DefaultEditor)this.paperHeightSpinner.getEditor()).getTextField().setColumns(7);
            JLabel jLabel = new JLabel();
            Locale locale = FRContext.getLocale();
            if (PageSetupDialog.this.useLocale) {
                if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                    jLabel.setText(Inter.getLocText("PageSetup-mm"));
                } else {
                    jLabel.setText(Inter.getLocText("PageSetup-inches"));
                }
            } else {
                jLabel.setText(Inter.getLocText("PageSetup-mm"));
            }
            Dimension dimension = new Dimension(jLabel.getPreferredSize().width, this.paperHeightSpinner.getPreferredSize().height);
            jLabel.setMinimumSize(dimension);
            jLabel.setMinimumSize(dimension);
            jLabel.setSize(dimension);
            jLabel.setPreferredSize(dimension);
            this.predefinedComboBox.setRenderer(this.paperSizeCellRenderere);
            this.predefinedComboBox.addItemListener(this.paperSizeItemListener);
            ((JSpinner.DefaultEditor)this.paperWidthSpinner.getEditor()).getTextField().getDocument().addDocumentListener(this.customTextListener);
            ((JSpinner.DefaultEditor)this.paperHeightSpinner.getEditor()).getTextField().getDocument().addDocumentListener(this.customTextListener);
            this.paperWidthSpinner.addChangeListener(this.previewListener2);
            this.paperHeightSpinner.addChangeListener(this.previewListener2);
            for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
                object = ReportConstants.PaperSizeNameSizeArray[i];
                this.predefinedComboBox.addItem(object[1]);
            }
            jPanel4.add(Box.createHorizontalStrut(8));
            JPanel jPanel5 = new JPanel();
            jPanel4.add(jPanel5);
            jPanel5.setLayout(new GridLayout(2, 1));
            jPanel5.add(this.predefinedRadioButton);
            jPanel5.add(this.customRadioButton);
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.predefinedRadioButton);
            ((ButtonGroup)object).add(this.customRadioButton);
            JPanel jPanel6 = new JPanel();
            jPanel4.add(jPanel6);
            jPanel6.setLayout(new GridLayout(2, 1));
            JPanel jPanel7 = new JPanel();
            jPanel6.add(jPanel7);
            jPanel7.setLayout(new FlowLayout(0, 4, 2));
            jPanel7.add(this.predefinedComboBox);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new FlowLayout(0, 4, 2));
            jPanel8.add(this.paperWidthSpinner);
            jPanel8.add(new JLabel("x"));
            jPanel8.add(this.paperHeightSpinner);
            jPanel8.add(jLabel);
            jPanel6.add(jPanel8);
            jPanel4.add(Box.createHorizontalStrut(12));
            JPanel jPanel9 = new JPanel();
            jPanel.add(jPanel9);
            jPanel9.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("PageSetup-Margin")));
            jPanel9.setLayout(new GridLayout(1, 2));
            JPanel jPanel10 = new JPanel();
            jPanel9.add(jPanel10);
            jPanel10.setLayout(new FlowLayout(0, 4, 1));
            jPanel10.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 0));
            JPanel jPanel11 = new JPanel();
            jPanel10.add(jPanel11);
            jPanel11.setLayout(new GridLayout(2, 1, 1, 2));
            jPanel11.add(new JLabel(Inter.getLocText("Top") + ":"));
            jPanel11.add(new JLabel(Inter.getLocText("Bottom") + ":"));
            JPanel jPanel12 = new JPanel();
            jPanel10.add(jPanel12);
            jPanel12.setLayout(new GridLayout(2, 1, 1, 2));
            this.marginTopUnitFieldPane = new UnitFieldPane();
            this.marginBottomUnitFieldPane = new UnitFieldPane();
            jPanel12.add(this.marginTopUnitFieldPane);
            jPanel12.add(this.marginBottomUnitFieldPane);
            JPanel jPanel13 = new JPanel();
            jPanel9.add(jPanel13);
            jPanel13.setLayout(new FlowLayout(0, 4, 1));
            jPanel13.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 0));
            JPanel jPanel14 = new JPanel();
            jPanel13.add(jPanel14);
            jPanel14.setLayout(new GridLayout(2, 1, 1, 2));
            jPanel14.add(new JLabel(Inter.getLocText("Left") + ":"));
            jPanel14.add(new JLabel(Inter.getLocText("Right") + ":"));
            JPanel jPanel15 = new JPanel();
            jPanel13.add(jPanel15);
            jPanel15.setLayout(new GridLayout(2, 1, 1, 2));
            this.marginLeftUnitFieldPane = new UnitFieldPane();
            this.marginRightUnitFieldPane = new UnitFieldPane();
            jPanel15.add(this.marginLeftUnitFieldPane);
            jPanel15.add(this.marginRightUnitFieldPane);
            JPanel jPanel16 = new JPanel();
            jPanel16.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Height")));
            jPanel.add(jPanel16);
            jPanel16.setLayout(new GridLayout(1, 2));
            JPanel jPanel17 = new JPanel();
            jPanel16.add(jPanel17);
            jPanel17.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            jPanel17.setLayout(new FlowLayout(0, 4, 1));
            jPanel17.add(new JLabel(Inter.getLocText("PageSetup-Header") + ":"));
            this.headerUnitFieldPane = new UnitFieldPane();
            jPanel17.add(this.headerUnitFieldPane);
            JPanel jPanel18 = new JPanel();
            jPanel16.add(jPanel18);
            jPanel18.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            jPanel18.setLayout(new FlowLayout(0, 4, 1));
            jPanel18.add(new JLabel(Inter.getLocText("PageSetup-Footer") + ":"));
            this.footerUnitFieldPane = new UnitFieldPane();
            jPanel18.add(this.footerUnitFieldPane);
            JPanel jPanel19 = new JPanel();
            jPanel.add(jPanel19);
            jPanel19.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            jPanel19.setLayout(new GridLayout(1, 1, 0, 0));
        }

        public void populate(ReportSettings reportSettings) {
            if (reportSettings.getOrientation() == 1) {
                this.landscapeRadioButton.setSelected(true);
            } else {
                this.portraitRadioButton.setSelected(true);
            }
            PaperSize paperSize = reportSettings.getPaperSize();
            if (paperSize == null) {
                paperSize = PaperSize.PAPERSIZE_A4;
            }
            boolean bl = false;
            for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
                Object[] objectArray = ReportConstants.PaperSizeNameSizeArray[i];
                if (!ComparatorUtils.equals(paperSize, objectArray[1])) continue;
                this.predefinedComboBox.setSelectedIndex(i);
                this.predefinedRadioButton.setSelected(true);
                bl = true;
                break;
            }
            if (!bl) {
                this.customRadioButton.setSelected(true);
                Locale locale = FRContext.getLocale();
                if (PageSetupDialog.this.useLocale) {
                    if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                        this.paperWidthSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
                        this.paperHeightSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
                    } else {
                        this.paperWidthSpinner.setValue(new Double(paperSize.getWidth()));
                        this.paperHeightSpinner.setValue(new Double(paperSize.getHeight()));
                    }
                } else {
                    this.paperWidthSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
                    this.paperHeightSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
                }
            }
            if (PageSetupDialog.this.useLocale) {
                if (ComparatorUtils.equals(Locale.CHINA, FRContext.getLocale())) {
                    this.showPagePane.populate(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth()), BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight()), reportSettings.getOrientation(), true);
                } else {
                    this.showPagePane.populate(paperSize.getWidth(), paperSize.getHeight(), reportSettings.getOrientation(), false);
                }
            } else {
                this.showPagePane.populate(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth()), BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight()), reportSettings.getOrientation(), true);
            }
            Margin margin = reportSettings.getMargin();
            this.marginTopUnitFieldPane.setInchesValue(margin.getTop());
            this.marginLeftUnitFieldPane.setInchesValue(margin.getLeft());
            this.marginBottomUnitFieldPane.setInchesValue(margin.getBottom());
            this.marginRightUnitFieldPane.setInchesValue(margin.getRight());
            this.headerUnitFieldPane.setInchesValue(reportSettings.getHeaderHeight());
            this.footerUnitFieldPane.setInchesValue(reportSettings.getFooterHeight());
        }

        public void update(Report report) {
            Cloneable cloneable;
            ReportSettings reportSettings = report.getReportSettings();
            if (reportSettings == null) {
                reportSettings = new ReportSettings();
                report.setReportSettings(reportSettings);
            }
            if (this.landscapeRadioButton.isSelected()) {
                reportSettings.setOrientation(1);
            } else {
                reportSettings.setOrientation(0);
            }
            if (this.predefinedRadioButton.isSelected()) {
                try {
                    reportSettings.setPaperSize((PaperSize)((PaperSize)this.predefinedComboBox.getSelectedItem()).clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else if (this.customRadioButton.isSelected()) {
                cloneable = FRContext.getLocale();
                if (PageSetupDialog.this.useLocale) {
                    if (ComparatorUtils.equals(Locale.CHINA, cloneable)) {
                        reportSettings.setPaperSize(new PaperSize(BaseCoreUtils.convertMillimetersToInches(((Number)this.paperWidthSpinner.getValue()).doubleValue()), BaseCoreUtils.convertMillimetersToInches(((Number)this.paperHeightSpinner.getValue()).doubleValue())));
                    } else {
                        reportSettings.setPaperSize(new PaperSize(((Number)this.paperWidthSpinner.getValue()).doubleValue(), ((Number)this.paperHeightSpinner.getValue()).doubleValue()));
                    }
                } else {
                    reportSettings.setPaperSize(new PaperSize(BaseCoreUtils.convertMillimetersToInches(((Number)this.paperWidthSpinner.getValue()).doubleValue()), BaseCoreUtils.convertMillimetersToInches(((Number)this.paperHeightSpinner.getValue()).doubleValue())));
                }
            }
            cloneable = reportSettings.getMargin();
            ((Margin)cloneable).setTop(this.marginTopUnitFieldPane.getInchesValue());
            ((Margin)cloneable).setLeft(this.marginLeftUnitFieldPane.getInchesValue());
            ((Margin)cloneable).setBottom(this.marginBottomUnitFieldPane.getInchesValue());
            ((Margin)cloneable).setRight(this.marginRightUnitFieldPane.getInchesValue());
            reportSettings.setHeaderHeight(this.headerUnitFieldPane.getInchesValue());
            reportSettings.setFooterHeight(this.footerUnitFieldPane.getInchesValue());
        }

        private void previewShowPagePane() {
            int n = this.landscapeRadioButton.isSelected() ? 1 : 0;
            if (this.predefinedRadioButton.isSelected()) {
                PaperSize paperSize = (PaperSize)this.predefinedComboBox.getSelectedItem();
                if (PageSetupDialog.this.useLocale) {
                    if (ComparatorUtils.equals(Locale.CHINA, FRContext.getLocale())) {
                        this.showPagePane.populate(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth()), BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight()), n, true);
                    } else {
                        this.showPagePane.populate(paperSize.getWidth(), paperSize.getHeight(), n, false);
                    }
                } else {
                    this.showPagePane.populate(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth()), BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight()), n, true);
                }
            } else if (this.customRadioButton.isSelected()) {
                this.showPagePane.populate(((Number)this.paperWidthSpinner.getValue()).doubleValue(), ((Number)this.paperHeightSpinner.getValue()).doubleValue(), n, !PageSetupDialog.this.useLocale || ComparatorUtils.equals(Locale.CHINA, FRContext.getLocale()));
            }
            this.showPagePane.repaint();
        }

        private JPanel createIconRadioPane(Icon icon, JRadioButton jRadioButton) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(new JLabel(icon));
            jPanel.add(jRadioButton);
            return jPanel;
        }

        static /* synthetic */ void access$100(PagePane pagePane) {
            pagePane.previewShowPagePane();
        }

        static /* synthetic */ PageSetupDialog access$200(PagePane pagePane) {
            return pagePane.PageSetupDialog.this;
        }

        static /* synthetic */ JComboBox access$300(PagePane pagePane) {
            return pagePane.predefinedComboBox;
        }

        static /* synthetic */ JSpinner access$400(PagePane pagePane) {
            return pagePane.paperWidthSpinner;
        }

        static /* synthetic */ JSpinner access$500(PagePane pagePane) {
            return pagePane.paperHeightSpinner;
        }

        static /* synthetic */ JRadioButton access$600(PagePane pagePane) {
            return pagePane.predefinedRadioButton;
        }

        static /* synthetic */ JRadioButton access$700(PagePane pagePane) {
            return pagePane.customRadioButton;
        }

        class ShowPagePane
        extends JPanel {
            private double paper_width;
            private double paper_height;
            private int paper_orientation;
            private int pane_width = 300;
            private int pane_height = 100;
            private double length_scale = 0.3;
            private Image img;

            public ShowPagePane() {
                this.setSize(this.pane_width, this.pane_height);
                this.setPreferredSize(new Dimension(this.pane_width, this.pane_height));
                this.setBackground(new Color(128, 128, 128));
                this.setOpaque(false);
                this.img = BaseUtils.readImage("/com/fr/dialog/images/pagesetup/a.png");
            }

            public void populate(double d, double d2, int n, boolean bl) {
                if (d <= 0.0 || d2 <= 0.0) {
                    return;
                }
                this.paper_width = Math.min(d, 2000.0);
                this.paper_height = Math.min(d2, 2000.0);
                this.paper_orientation = n;
                this.length_scale = !bl ? 3.0 : 0.3;
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.paper_width > 0.0 && this.paper_height > 0.0) {
                    double d;
                    double d2;
                    double d3 = this.length_scale * this.paper_width / (double)(this.pane_width - 50);
                    double d4 = this.length_scale * this.paper_height / (double)(this.pane_height - 30);
                    if (d3 > 1.0 || d4 > 1.0) {
                        double d5 = d3 > d4 ? d3 : d4;
                        d2 = this.length_scale * this.paper_width / d5;
                        d = this.length_scale * this.paper_height / d5;
                    } else {
                        d2 = this.paper_width * this.length_scale;
                        d = this.paper_height * this.length_scale;
                    }
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    String string = "" + this.paper_width;
                    if (string.indexOf(".") > 0) {
                        string = string.substring(0, string.indexOf(".") + 2);
                    }
                    int n = fontMetrics.stringWidth(string);
                    d2 = Math.max(d2, (double)(n + 26));
                    String string2 = "" + this.paper_height;
                    if (string2.indexOf(".") > 0) {
                        string2 = string2.substring(0, string2.indexOf(".") + 2);
                    }
                    int n2 = fontMetrics.stringWidth(string2);
                    d = Math.max(d, (double)(n2 + 26));
                    double d6 = ((double)this.pane_width - d2) / 2.0;
                    double d7 = ((double)this.pane_height - d) / 2.0;
                    graphics2D.translate(d6, d7);
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fill3DRect(0, 0, (int)d2, (int)d, true);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawLine(0, -5, 0, -15);
                    graphics2D.drawLine((int)d2 - 1, -5, (int)d2 - 1, -15);
                    graphics2D.drawString(string, (int)((d2 - (double)n) / 2.0), -5);
                    graphics2D.drawLine(2, -10, (int)((d2 - (double)n) / 2.0) - 5, -10);
                    graphics2D.drawLine((int)((d2 + (double)n) / 2.0) + 5, -10, (int)d2 - 3, -10);
                    graphics2D.drawLine(2, -10, 7, -13);
                    graphics2D.drawLine(2, -10, 7, -7);
                    graphics2D.drawLine((int)d2 - 3, -10, (int)d2 - 8, -13);
                    graphics2D.drawLine((int)d2 - 3, -10, (int)d2 - 8, -7);
                    graphics2D.drawLine(-15, 0, -5, 0);
                    graphics2D.drawLine(-15, (int)d - 1, -5, (int)d - 1);
                    graphics2D.rotate(-Math.toRadians(90.0));
                    graphics2D.drawString(string2, -((int)((d + (double)n2) / 2.0)), -5);
                    graphics2D.rotate(Math.toRadians(90.0));
                    graphics2D.drawLine(-10, 2, -10, (int)((d - (double)n2) / 2.0) - 5);
                    graphics2D.drawLine(-10, (int)((d + (double)n2) / 2.0) + 5, -10, (int)d - 3);
                    graphics2D.drawLine(-10, 2, -13, 7);
                    graphics2D.drawLine(-10, 2, -7, 7);
                    graphics2D.drawLine(-10, (int)d - 3, -13, (int)d - 8);
                    graphics2D.drawLine(-10, (int)d - 3, -7, (int)d - 8);
                    if (this.paper_orientation == 0) {
                        graphics2D.drawImage(this.img, (int)((d2 - (double)this.img.getWidth(null)) / 2.0), (int)((d - (double)this.img.getHeight(null)) / 2.0), null);
                    } else {
                        graphics2D.rotate(-Math.toRadians(90.0));
                        graphics2D.drawImage(this.img, -((int)((d + (double)this.img.getWidth(null)) / 2.0)), (int)((d2 - (double)this.img.getHeight(null)) / 2.0), null);
                        graphics2D.rotate(Math.toRadians(90.0));
                    }
                    graphics2D.translate(-d6, -d7);
                }
            }
        }
    }
}

