/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

class ParenMatcher
extends JTextPane
implements Runnable {
    public static Color[] matchColor = new Color[]{Color.black, Color.orange, Color.blue};
    public static Color keywordsColor = Color.BLUE;
    public static Color badColor = Color.red;
    public static Color orgColor = Color.black;
    private AttributeSet[] matchAttrSet;
    private MutableAttributeSet badAttrSet;
    private MutableAttributeSet keyAttrSet;
    private MutableAttributeSet orgAttrSet;
    private String[] keywords = new String[]{"arguments", "break", "delete", "function", "return", "typeof", "case", "do", "if", "switch", "var", "catch", "else", "in", "this", "void", "continue", "false", "instanceof", "throw", "while", "debugger", "finally", "new", "true", "with", "default", "for", "null", "try"};
    private List keyList;
    private List list = new ArrayList();

    public ParenMatcher() {
        int n;
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        this.badAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.badAttrSet, badColor);
        StyleConstants.setBold(this.badAttrSet, true);
        StyleConstants.setFontFamily(this.badAttrSet, "DialogInput");
        this.matchAttrSet = new AttributeSet[matchColor.length];
        for (n = 0; n < matchColor.length; ++n) {
            this.matchAttrSet[n] = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, matchColor[n]);
        }
        this.keyAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyAttrSet, keywordsColor);
        StyleConstants.setFontFamily(this.keyAttrSet, "DialogInput");
        this.orgAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.orgAttrSet, orgColor);
        StyleConstants.setFontFamily(this.orgAttrSet, "DialogInput");
        this.keyList = new ArrayList();
        for (n = 0; n < this.keywords.length; ++n) {
            this.keyList.add(this.keywords[n]);
        }
    }

    public void run() {
        StyledDocument styledDocument = this.getStyledDocument();
        String string = "";
        int n = styledDocument.getLength();
        try {
            string = styledDocument.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Stack<String> stack = new Stack<String>();
        this.list.clear();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            this.hightKeywords(styledDocument, string, i);
            char c = string.charAt(i);
            if (c == '(' || c == '[' || c == '{') {
                int string22 = stack.size();
                stack.push("" + c + i);
                AttributeSet n3 = this.matchAttrSet[string22 % this.matchAttrSet.length];
                styledDocument.setCharacterAttributes(i, 1, n3, false);
            }
            if (c != ')' && c != ']' && c != '}') continue;
            String string3 = string2 = stack.empty() ? "." : (String)stack.peek();
            if (ParenMatcher.matches(string2.charAt(0), c)) {
                stack.pop();
                int n2 = stack.size();
                AttributeSet attributeSet = this.matchAttrSet[n2 % this.matchAttrSet.length];
                styledDocument.setCharacterAttributes(i, 1, attributeSet, false);
                continue;
            }
            styledDocument.setCharacterAttributes(i, 1, this.badAttrSet, false);
        }
        while (!stack.empty()) {
            String string4 = (String)stack.pop();
            int n3 = Integer.parseInt(string4.substring(1));
            styledDocument.setCharacterAttributes(n3, 1, this.badAttrSet, false);
        }
    }

    private void hightKeywords(StyledDocument styledDocument, String string, int n) {
        String string2;
        Pattern pattern = Pattern.compile("[a-zA-Z]");
        Matcher matcher = pattern.matcher(string2 = "" + string.charAt(n));
        boolean bl = matcher.matches();
        if (bl) {
            this.list.add(string2);
        } else {
            String string3 = this.toString(this.list);
            if (this.keyList.contains(string3)) {
                styledDocument.setCharacterAttributes(n - string3.length(), string3.length(), this.keyAttrSet, false);
            } else {
                styledDocument.setCharacterAttributes(n - string3.length(), string3.length(), this.orgAttrSet, false);
            }
            this.list.clear();
        }
    }

    private String toString(List list) {
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    public void replaceSelection(String string) {
        this.getInputAttributes().removeAttribute(StyleConstants.Foreground);
        super.replaceSelection(string);
    }

    public static boolean matches(char c, char c2) {
        if (c == '(') {
            return c2 == ')';
        }
        if (c == '[') {
            return c2 == ']';
        }
        if (c == '{') {
            return c2 == '}';
        }
        return false;
    }
}

