/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.Inter;
import com.fr.base.Style;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.ComparatorUtils;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.core.AlignmentComboBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class AlignmentPane
extends JPanel {
    private AlignmentComboBox horAlignmentComboBox;
    private AlignmentComboBox verAlignmentComboBox;
    private JComboBox textComboBox;
    private static final String[] TEXT = new String[]{Inter.getLocText("StyleAlignment-Wrap_Text"), Inter.getLocText("StyleAlignment-Single_Line"), Inter.getLocText("StyleAlignment-Single_Line(Adjust_Font)"), Inter.getLocText("StyleAlignment-Multi_Line(Adjust_Font)")};
    private JSpinner rotationSpinner;
    private JCheckBox isVerticalTextCheckBox;
    private JRadioButton leftToRightRB;
    private JRadioButton rightToLeftRB;
    private JComboBox imageComboBox;
    private static final String[] IMAGE = new String[]{Inter.getLocText("Default"), Inter.getLocText("Image-Extend")};
    private JSpinner leftIndentSpinner;
    private JSpinner rightIndentSpinner;
    private JSpinner spacingBeforeSpinner;
    private JSpinner spacingAfterSpinner;
    private JSpinner lineSpacingSpinner;
    private EventListenerList eventChangeList = new EventListenerList();
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            AlignmentPane.this.fireStateChanged();
        }
    };
    ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            AlignmentPane.this.fireStateChanged();
        }
    };
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public AlignmentPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(LayoutFactory.createBorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 2, 4));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("StyleAlignment-Horizontal")));
        this.horAlignmentComboBox = new AlignmentComboBox(BaseCoreConstants.HorizontalAlignmentArray);
        this.horAlignmentComboBox.addActionListener(this.actionListener);
        jPanel3.add(this.horAlignmentComboBox);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(jPanel4);
        jPanel4.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("StyleAlignment-Vertical")));
        this.verAlignmentComboBox = new AlignmentComboBox(BaseCoreConstants.VerticalAlignmentArray);
        this.verAlignmentComboBox.addActionListener(this.actionListener);
        jPanel4.add(this.verAlignmentComboBox);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 2, 4));
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel5.add(jPanel6);
        jPanel6.setLayout(new GridLayout(1, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("StyleAlignment-Text_Style") + ":"));
        this.textComboBox = new JComboBox<String>(TEXT);
        this.textComboBox.addActionListener(this.actionListener);
        jPanel6.add(this.textComboBox);
        JPanel jPanel7 = new JPanel();
        jPanel5.add(jPanel7);
        jPanel7.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Image-Image_Layout")));
        jPanel7.setLayout(new GridLayout(1, 1));
        this.imageComboBox = new JComboBox<String>(IMAGE);
        this.imageComboBox.addActionListener(this.actionListener);
        jPanel7.add(this.imageComboBox);
        JPanel jPanel8 = new JPanel();
        jPanel.add(jPanel8);
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("StyleAlignment-Text_Rotation") + ":"));
        JPanel jPanel9 = new JPanel();
        jPanel8.add(jPanel9);
        jPanel9.setLayout(new FlowLayout(0, 1, 0));
        JPanel jPanel10 = new JPanel();
        jPanel9.add(jPanel10);
        this.isVerticalTextCheckBox = new JCheckBox(Inter.getLocText("StyleAlignment-Vertical_Text"), false);
        this.isVerticalTextCheckBox.addActionListener(this.actionListener);
        jPanel10.add(this.isVerticalTextCheckBox);
        this.isVerticalTextCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AlignmentPane.this.isVerticalTextCheckBox.isSelected()) {
                    AlignmentPane.this.rotationSpinner.setEnabled(false);
                    AlignmentPane.this.leftToRightRB.setEnabled(true);
                    AlignmentPane.this.rightToLeftRB.setEnabled(true);
                } else {
                    AlignmentPane.this.rotationSpinner.setEnabled(true);
                    AlignmentPane.this.leftToRightRB.setEnabled(false);
                    AlignmentPane.this.rightToLeftRB.setEnabled(false);
                }
            }
        });
        this.leftToRightRB = new JRadioButton(Inter.getLocText("StyleAlignment-Left_To_Right"));
        this.leftToRightRB.addActionListener(this.actionListener);
        jPanel10.add(this.leftToRightRB);
        this.rightToLeftRB = new JRadioButton(Inter.getLocText("StyleAlignment-Right_To_Left"));
        this.rightToLeftRB.addActionListener(this.actionListener);
        jPanel10.add(this.rightToLeftRB);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftToRightRB);
        buttonGroup.add(this.rightToLeftRB);
        this.rightToLeftRB.setSelected(true);
        JPanel jPanel11 = new JPanel();
        jPanel8.add(jPanel11);
        jPanel11.setLayout(new FlowLayout(0, 1, 0));
        jPanel11.add(new JLabel(" " + Inter.getLocText("StyleAlignment-Text_Rotation") + ":"));
        this.rotationSpinner = new JSpinner(new SpinnerNumberModel(0, -90, 90, 1));
        this.rotationSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.rotationSpinner, 3);
        jPanel11.add(this.rotationSpinner);
        jPanel11.add(new JLabel(Inter.getLocText("StyleAlignment-Degrees")));
        jPanel11.add(new JLabel("(" + Inter.getLocText("StyleAlignment-between_-90_and_90") + ")"));
        JPanel jPanel12 = new JPanel();
        jPanel.add(jPanel12);
        jPanel12.setLayout(new GridLayout(1, 2));
        jPanel12.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Sytle-Indentation") + ":"));
        this.leftIndentSpinner = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.leftIndentSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.leftIndentSpinner, 3);
        jPanel12.add(this.createCenterFlowPane(Inter.getLocText("Style-Left_Indent") + "(" + Inter.getLocText("px") + ")", this.leftIndentSpinner));
        this.rightIndentSpinner = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.rightIndentSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.rightIndentSpinner, 3);
        jPanel12.add(this.createCenterFlowPane(Inter.getLocText("Style-Right_Indent") + "(" + Inter.getLocText("px") + ")", this.rightIndentSpinner));
        JPanel jPanel13 = new JPanel();
        jPanel.add(jPanel13);
        jPanel13.setLayout(new GridLayout(1, 3));
        jPanel13.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Style-Spacing") + ":"));
        this.spacingBeforeSpinner = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.spacingBeforeSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.spacingBeforeSpinner, 3);
        jPanel13.add(this.createCenterFlowPane(Inter.getLocText("Style-Spacing_Before"), this.spacingBeforeSpinner));
        this.spacingAfterSpinner = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.spacingAfterSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.spacingAfterSpinner, 3);
        jPanel13.add(this.createCenterFlowPane(Inter.getLocText("Style-Spacing_After"), this.spacingAfterSpinner));
        this.lineSpacingSpinner = new JSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.lineSpacingSpinner.addChangeListener(this.changeListener);
        GUICoreUtils.setColumnForSpinner(this.lineSpacingSpinner, 3);
        jPanel13.add(this.createCenterFlowPane(Inter.getLocText("Style-Line_Spacing"), this.lineSpacingSpinner));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventChangeList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AlignmentPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void fireStateChanged() {
        Object[] objectArray = this.eventChangeList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? AlignmentPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private JPanel createCenterFlowPane(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel(string));
        jPanel.add(jComponent);
        return jPanel;
    }

    public void populate(Style style) {
        this.horAlignmentComboBox.setSelectedAlignment(style.getHorizontalAlignment());
        this.verAlignmentComboBox.setSelectedAlignment(style.getVerticalAlignment());
        if (style.getTextStyle() == 1) {
            this.textComboBox.setSelectedIndex(1);
        } else if (style.getTextStyle() == 2) {
            this.textComboBox.setSelectedIndex(2);
        } else if (style.getTextStyle() == 3) {
            this.textComboBox.setSelectedIndex(3);
        } else {
            this.textComboBox.setSelectedIndex(0);
        }
        int n = style.getImageLayout();
        if (n == 2) {
            this.imageComboBox.setSelectedIndex(1);
        } else {
            this.imageComboBox.setSelectedIndex(0);
        }
        if (style.getVerticalText() == 1) {
            this.isVerticalTextCheckBox.setSelected(true);
            this.rotationSpinner.setEnabled(false);
            if (style.getTextDirection() == 1) {
                this.leftToRightRB.setEnabled(true);
                this.rightToLeftRB.setEnabled(true);
                this.leftToRightRB.setSelected(true);
                this.rightToLeftRB.setSelected(false);
            } else {
                this.leftToRightRB.setEnabled(true);
                this.rightToLeftRB.setEnabled(true);
                this.leftToRightRB.setSelected(false);
                this.rightToLeftRB.setSelected(true);
            }
        } else {
            this.isVerticalTextCheckBox.setSelected(false);
            this.leftToRightRB.setEnabled(false);
            this.rightToLeftRB.setEnabled(false);
            this.rotationSpinner.setEnabled(true);
            this.rotationSpinner.setValue(new Integer(style.getRotation()));
        }
        this.leftIndentSpinner.setValue(new Integer(style.getPaddingLeft()));
        this.rightIndentSpinner.setValue(new Integer(style.getPaddingRight()));
        this.spacingBeforeSpinner.setValue(new Integer(style.getSpacingBefore()));
        this.spacingAfterSpinner.setValue(new Integer(style.getSpacingAfter()));
        this.lineSpacingSpinner.setValue(new Integer(style.getLineSpacing()));
    }

    public void checkValid() throws Exception {
        int n = (Integer)this.rotationSpinner.getValue();
        if (n > 90 || n < -90) {
            throw new Exception(Inter.getLocText("StyleAlignment-The_value_of_rotation_must_between_-90_and_90_degrees") + ".");
        }
    }

    public Style update(Style style) {
        if (style == null) {
            return style;
        }
        style = style.deriveHorizontalAlignment(this.horAlignmentComboBox.getSelectedAlignment());
        style = style.deriveVerticalAlignment(this.verAlignmentComboBox.getSelectedAlignment());
        style = ComparatorUtils.equals(this.textComboBox.getSelectedItem(), TEXT[0]) ? style.deriveTextStyle(0) : (ComparatorUtils.equals(this.textComboBox.getSelectedItem(), TEXT[1]) ? style.deriveTextStyle(1) : (ComparatorUtils.equals(this.textComboBox.getSelectedItem(), TEXT[2]) ? style.deriveTextStyle(2) : style.deriveTextStyle(3)));
        if (ComparatorUtils.equals(this.imageComboBox.getSelectedItem(), IMAGE[0])) {
            style = style.deriveImageLayout(3);
        } else if (ComparatorUtils.equals(this.imageComboBox.getSelectedItem(), IMAGE[1])) {
            style = style.deriveImageLayout(2);
        }
        if (this.isVerticalTextCheckBox.isSelected()) {
            style = style.deriveVerticalText(1);
            style = style.deriveRotation(0);
            style = this.leftToRightRB.isSelected() ? style.deriveTextDirection(1) : style.deriveTextDirection(0);
        } else {
            style = style.deriveVerticalText(0);
            style = style.deriveRotation((Integer)this.rotationSpinner.getValue());
        }
        style = style.derivePaddingLeft((Integer)this.leftIndentSpinner.getValue());
        style = style.derivePaddingRight((Integer)this.rightIndentSpinner.getValue());
        style = style.deriveSpacingBefore((Integer)this.spacingBeforeSpinner.getValue());
        style = style.deriveSpacingAfter((Integer)this.spacingAfterSpinner.getValue());
        style = style.deriveLineSpacing((Integer)this.lineSpacingSpinner.getValue());
        return style;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

