/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.background.TextureBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.JNumberField;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.BasicPane;
import com.fr.dialog.core.BackgroundPreviewLabel;
import com.fr.dialog.core.ColorSelectionPane;
import com.fr.dialog.core.DetailColorSelectPane;
import com.fr.dialog.core.GradientPane;
import com.fr.dialog.core.ImageFileChooser;
import com.fr.dialog.core.ImagePreviewPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BackgroundPane
extends BasicPane {
    private JTabbedPane tabbedPane = null;
    private NullBackgroundPane nullBackgroundPane = null;
    private ColorBackgroundPane colorBackgroundPane = null;
    private TextureBackgroundPane textureBackgroundPane = null;
    private PatternBackgroundPane patternBackgroundPane = null;
    private ImageBackgroundPane imageBackgroundPane = null;
    private GradientPane gradientPane = null;
    private EventListenerList eventChangeList = new EventListenerList();
    private ChangeListener backgroundChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            BackgroundPane.this.previewPane.setBackgroundObject(BackgroundPane.this.update());
            BackgroundPane.this.previewPane.repaint();
        }
    };
    private BackgroundPreviewLabel previewPane = null;
    static TexturePaint[] EmbedTexturePaintArray = new TexturePaint[]{TextureBackground.NewsprintTexturePaint, TextureBackground.RecycledPaperTexturePaint, TextureBackground.ParchmentTexturePaint, TextureBackground.StationeryTexturePaint, TextureBackground.GreenMarbleTexturePaint, TextureBackground.WhiteMarbleTexturePaint, TextureBackground.BrownMarbleTexturePaint, TextureBackground.GraniteTexturePaint, TextureBackground.BlueTissuePaperTexturePaint, TextureBackground.PinkTissuePaperTexturePaint, TextureBackground.PurpleMeshTexturePaint, TextureBackground.BouquetTexturePaint, TextureBackground.PapyrusTexturePaint, TextureBackground.CanvasTexturePaint, TextureBackground.DenimTexturePaint, TextureBackground.WovenMatTexturePaint, TextureBackground.WaterDropletsTexturePaint, TextureBackground.PaperBagTexturePaint, TextureBackground.FishFossilTexturePaint, TextureBackground.SandTexturePaint, TextureBackground.CorkTexturePaint, TextureBackground.WalnutTexturePaint, TextureBackground.OakTexturePaint, TextureBackground.MediumWoodTexturePaint};
    static String[] EmbedTexturePaintDesArray = new String[]{Inter.getLocText("BackgroundTexture-Newsprint"), Inter.getLocText("BackgroundTexture-RecycledPaper"), Inter.getLocText("BackgroundTexture-Parchment"), Inter.getLocText("BackgroundTexture-Stationery"), Inter.getLocText("BackgroundTexture-GreenMarble"), Inter.getLocText("BackgroundTexture-WhiteMarble"), Inter.getLocText("BackgroundTexture-BrownMarble"), Inter.getLocText("BackgroundTexture-Granite"), Inter.getLocText("BackgroundTexture-BlueTissuePaper"), Inter.getLocText("BackgroundTexture-PinkTissuePaper"), Inter.getLocText("BackgroundTexture-PurpleMesh"), Inter.getLocText("BackgroundTexture-Bouquet"), Inter.getLocText("BackgroundTexture-Papyrus"), Inter.getLocText("BackgroundTexture-Canvas"), Inter.getLocText("BackgroundTexture-Denim"), Inter.getLocText("BackgroundTexture-WovenMat"), Inter.getLocText("BackgroundTexture-WaterDroplets"), Inter.getLocText("BackgroundTexture-PaperBag"), Inter.getLocText("BackgroundTexture-FishFossil"), Inter.getLocText("BackgroundTexture-Sand"), Inter.getLocText("BackgroundTexture-Cork"), Inter.getLocText("BackgroundTexture-Walnut"), Inter.getLocText("BackgroundTexture-Oak"), Inter.getLocText("BackgroundTexture-MediumWood")};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$javax$swing$JPanel;

    public BackgroundPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(LayoutFactory.createBorderLayout());
        this.previewPane = new BackgroundPreviewLabel();
        this.previewPane.addBackgroundChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BackgroundPane.this.fireStateChanged();
            }
        });
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addTab(Inter.getLocText("Background-Null"), new JPanel());
        this.tabbedPane.addTab(Inter.getLocText("Color"), new JPanel());
        this.tabbedPane.addTab(Inter.getLocText("Background-Texture"), new JPanel());
        this.tabbedPane.addTab(Inter.getLocText("Background-Pattern"), new JPanel());
        this.tabbedPane.addTab(Inter.getLocText("Image"), new JPanel());
        this.tabbedPane.addTab("\u6e10\u53d8\u8272", new JPanel());
        this.tabbedPane.addChangeListener(this.backgroundChangeListener);
        this.tabbedPane.setPreferredSize(new Dimension(200, 210));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventChangeList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BackgroundPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void fireStateChanged() {
        Object[] objectArray = this.eventChangeList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? BackgroundPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private NullBackgroundPane getNullBackgroundPane() {
        if (this.nullBackgroundPane == null) {
            this.nullBackgroundPane = new NullBackgroundPane();
            this.nullBackgroundPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.nullBackgroundPane;
    }

    private ColorBackgroundPane getColorBackgroundPane() {
        if (this.colorBackgroundPane == null) {
            this.colorBackgroundPane = new ColorBackgroundPane();
            this.colorBackgroundPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.colorBackgroundPane;
    }

    private TextureBackgroundPane getTextureBackgroundPane() {
        if (this.textureBackgroundPane == null) {
            this.textureBackgroundPane = new TextureBackgroundPane();
            this.textureBackgroundPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.textureBackgroundPane;
    }

    private PatternBackgroundPane getPatternBackgroundPane() {
        if (this.patternBackgroundPane == null) {
            this.patternBackgroundPane = new PatternBackgroundPane();
            this.patternBackgroundPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.patternBackgroundPane;
    }

    private ImageBackgroundPane getImageBackgroundPane() {
        if (this.imageBackgroundPane == null) {
            this.imageBackgroundPane = new ImageBackgroundPane();
            this.imageBackgroundPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.imageBackgroundPane;
    }

    private GradientPane getGradientPane() {
        if (this.gradientPane == null) {
            this.gradientPane = new GradientPane();
            this.gradientPane.addChangeListener(this.backgroundChangeListener);
        }
        return this.gradientPane;
    }

    public void populate(Background background) {
        if (background == null) {
            this.tabbedPane.setComponentAt(0, this.getNullBackgroundPane());
            this.tabbedPane.setSelectedIndex(0);
            this.nullBackgroundPane.populate(background);
        } else if (background instanceof ColorBackground) {
            this.tabbedPane.setComponentAt(1, this.getColorBackgroundPane());
            this.tabbedPane.setSelectedIndex(1);
            this.colorBackgroundPane.populate(background);
        } else if (background instanceof TextureBackground) {
            this.tabbedPane.setComponentAt(2, this.getTextureBackgroundPane());
            this.tabbedPane.setSelectedIndex(2);
            this.textureBackgroundPane.populate(background);
        } else if (background instanceof PatternBackground) {
            this.tabbedPane.setComponentAt(3, this.getPatternBackgroundPane());
            this.tabbedPane.setSelectedIndex(3);
            this.patternBackgroundPane.populate(background);
        } else if (background instanceof ImageBackground) {
            this.tabbedPane.setComponentAt(4, this.getImageBackgroundPane());
            this.tabbedPane.setSelectedIndex(4);
            this.imageBackgroundPane.populate(background);
        } else if (background instanceof GradientBackground) {
            this.tabbedPane.setComponentAt(5, this.getGradientPane());
            this.tabbedPane.setSelectedIndex(5);
            this.gradientPane.populate(background);
        }
        this.tabbedPane.doLayout();
        this.tabbedPane.validate();
    }

    public Background update() {
        try {
            Component component = this.tabbedPane.getSelectedComponent();
            if (component.getClass() == (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = BackgroundPane.class$("javax.swing.JPanel")) : class$javax$swing$JPanel)) {
                int n = this.tabbedPane.getSelectedIndex();
                if (n == 0) {
                    component = this.getNullBackgroundPane();
                } else if (n == 1) {
                    component = this.getColorBackgroundPane();
                } else if (n == 2) {
                    component = this.getTextureBackgroundPane();
                } else if (n == 3) {
                    component = this.getPatternBackgroundPane();
                } else if (n == 4) {
                    component = this.getImageBackgroundPane();
                } else if (n == 5) {
                    component = this.getGradientPane();
                }
                this.tabbedPane.setComponentAt(n, component);
            }
            if (component instanceof BackgroundSettingPane) {
                return ((BackgroundSettingPane)component).update();
            }
            if (component instanceof GradientPane) {
                return ((GradientPane)component).update();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ImageBackgroundPane
    extends BackgroundSettingPane {
        private ImagePreviewPane previewPane = null;
        private JRadioButton defaultRadioButton = null;
        private JRadioButton centerRadioButton = null;
        private JRadioButton extendRadioButton = null;
        private JRadioButton tiledRadioButton = null;
        private ChangeListener changeListener = null;
        private ImageFileChooser imageFileChooser = null;
        private JLabel imageSizeLabel = new JLabel();
        private JCheckBox specifySizeCheckBox;
        private JPanel southImageSizePane;
        private JNumberField widthNumberField;
        private JNumberField heightNumberField;
        ActionListener selectPictureActionListener = new ActionListener(this){
            private final /* synthetic */ ImageBackgroundPane this$1;
            {
                this.this$1 = imageBackgroundPane;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImageBackgroundPane.access$800(this.this$1).showOpenDialog(this.this$1);
                if (n != 1) {
                    File file = ImageBackgroundPane.access$800(this.this$1).getSelectedFile();
                    if (file != null && file.isFile()) {
                        BufferedImage bufferedImage = BaseUtils.readImage(file.getPath());
                        GraphHelper.waitForImage(bufferedImage);
                        ImageBackgroundPane.access$900(this.this$1).setImage(bufferedImage);
                    } else {
                        ImageBackgroundPane.access$900(this.this$1).setImage(null);
                    }
                }
                ImageBackgroundPane.access$1000(this.this$1);
            }
        };
        KeyListener widthHeightKeyListener = new KeyAdapter(this){
            private final /* synthetic */ ImageBackgroundPane this$1;
            {
                this.this$1 = imageBackgroundPane;
            }

            public void keyReleased(KeyEvent keyEvent) {
                ImageBackgroundPane.access$1000(this.this$1);
            }
        };
        ActionListener layoutActionListener = new ActionListener(this){
            private final /* synthetic */ ImageBackgroundPane this$1;
            {
                this.this$1 = imageBackgroundPane;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ImageBackgroundPane.access$1000(this.this$1);
            }
        };
        ChangeListener imageSizeChangeListener = new ChangeListener(this){
            private final /* synthetic */ ImageBackgroundPane this$1;
            {
                this.this$1 = imageBackgroundPane;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                Image image = (Image)changeEvent.getSource();
                if (image == null) {
                    ImageBackgroundPane.access$1100(this.this$1).setText("");
                } else {
                    ImageBackgroundPane.access$1100(this.this$1).setText(Inter.getLocText("Size") + ": " + image.getWidth(null) + "x" + image.getHeight(null) + Inter.getLocText("px"));
                }
            }
        };

        public ImageBackgroundPane() {
            Object object;
            Object object2;
            this.setLayout(new BorderLayout(0, 0));
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "Center");
            jPanel.setLayout(new BorderLayout(0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel.add((Component)jPanel2, "Center");
            jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Preview")));
            jPanel2.setLayout(LayoutFactory.createBorderLayout());
            this.previewPane = new ImagePreviewPane();
            jPanel2.add(new JScrollPane(this.previewPane));
            this.previewPane.addChangeListener(this.imageSizeChangeListener);
            JPanel jPanel3 = new JPanel();
            jPanel.add((Component)jPanel3, "East");
            jPanel3.setLayout(LayoutFactory.createBorderLayout());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 2, 4, 0));
            JButton jButton = new JButton(Inter.getLocText("Image-Select_Picture"));
            jPanel3.add((Component)jButton, "North");
            jButton.setMnemonic('S');
            jButton.addActionListener(this.selectPictureActionListener);
            this.imageSizeLabel.setHorizontalAlignment(0);
            jPanel3.add((Component)this.imageSizeLabel, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel3.add((Component)jPanel4, "South");
            jPanel4.setLayout(new BorderLayout(0, 4));
            this.specifySizeCheckBox = new JCheckBox(Inter.getLocText("Image-Specified_Size"), false);
            jPanel4.add((Component)this.specifySizeCheckBox, "North");
            this.specifySizeCheckBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ ImageBackgroundPane this$1;
                {
                    this.this$1 = imageBackgroundPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ImageBackgroundPane.access$600(this.this$1).isSelected()) {
                        GUICoreUtils.setEnabled(ImageBackgroundPane.access$700(this.this$1), true);
                    } else {
                        GUICoreUtils.setEnabled(ImageBackgroundPane.access$700(this.this$1), false);
                    }
                }
            });
            this.southImageSizePane = new JPanel();
            jPanel4.add((Component)this.southImageSizePane, "Center");
            this.southImageSizePane.setLayout(new SpringLayout());
            this.widthNumberField = new JNumberField();
            this.widthNumberField.setColumns(4);
            this.widthNumberField.addKeyListener(this.widthHeightKeyListener);
            this.southImageSizePane.add(new JLabel(Inter.getLocText("Width") + ":"));
            this.southImageSizePane.add(this.widthNumberField);
            this.widthNumberField.setEnabled(false);
            this.heightNumberField = new JNumberField();
            this.heightNumberField.setColumns(4);
            this.heightNumberField.addKeyListener(this.widthHeightKeyListener);
            this.southImageSizePane.add(new JLabel(Inter.getLocText("Height") + ":"));
            this.southImageSizePane.add(this.heightNumberField);
            this.heightNumberField.setEnabled(false);
            if (this.southImageSizePane.getLayout() instanceof SpringLayout) {
                object2 = (SpringLayout)this.southImageSizePane.getLayout();
                object = Spring.constant(6);
                for (int i = 0; i < 2; ++i) {
                    int n;
                    Spring spring = Spring.constant(0);
                    for (n = 0; n < 2; ++n) {
                        spring = Spring.max(spring, ((SpringLayout)object2).getConstraints(this.southImageSizePane.getComponent(n * 2 + i)).getWidth());
                    }
                    for (n = 0; n < 2; ++n) {
                        SpringLayout.Constraints constraints = ((SpringLayout)object2).getConstraints(this.southImageSizePane.getComponent(n * 2 + i));
                        constraints.setX((Spring)object);
                        constraints.setWidth(spring);
                    }
                    object = Spring.sum((Spring)object, Spring.sum(spring, Spring.constant(2)));
                }
                Spring spring = Spring.constant(6);
                for (int i = 0; i < 2; ++i) {
                    int n;
                    Spring spring2 = Spring.constant(0);
                    for (n = 0; n < 2; ++n) {
                        spring2 = Spring.max(spring2, ((SpringLayout)object2).getConstraints(this.southImageSizePane.getComponent(i * 2 + n)).getHeight());
                    }
                    for (n = 0; n < 2; ++n) {
                        SpringLayout.Constraints constraints = ((SpringLayout)object2).getConstraints(this.southImageSizePane.getComponent(i * 2 + n));
                        constraints.setY(spring);
                        constraints.setHeight(spring2);
                    }
                    spring = Spring.sum(spring, Spring.sum(spring2, Spring.constant(2)));
                }
                SpringLayout.Constraints constraints = ((SpringLayout)object2).getConstraints(this.southImageSizePane);
                constraints.setConstraint("South", spring);
                constraints.setConstraint("East", (Spring)object);
            } else {
                GUICoreUtils.setEnabled(this.southImageSizePane, false);
            }
            object2 = new JPanel();
            this.add((Component)object2, "South");
            ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Image-Layout")));
            ((Container)object2).setLayout(new GridLayout(1, 3));
            this.defaultRadioButton = new JRadioButton(Inter.getLocText("Default"));
            this.tiledRadioButton = new JRadioButton(Inter.getLocText("Image-Titled"));
            this.centerRadioButton = new JRadioButton(Inter.getLocText("Center"));
            this.extendRadioButton = new JRadioButton(Inter.getLocText("Image-Extend"));
            this.defaultRadioButton.setMnemonic('D');
            this.tiledRadioButton.setMnemonic('T');
            this.centerRadioButton.setMnemonic('C');
            this.extendRadioButton.setMnemonic('E');
            this.defaultRadioButton.addActionListener(this.layoutActionListener);
            this.tiledRadioButton.addActionListener(this.layoutActionListener);
            this.centerRadioButton.addActionListener(this.layoutActionListener);
            this.extendRadioButton.addActionListener(this.layoutActionListener);
            this.defaultRadioButton.setHorizontalAlignment(0);
            this.tiledRadioButton.setHorizontalAlignment(0);
            this.centerRadioButton.setHorizontalAlignment(0);
            this.extendRadioButton.setHorizontalAlignment(0);
            ((Container)object2).add(this.defaultRadioButton);
            ((Container)object2).add(this.tiledRadioButton);
            ((Container)object2).add(this.centerRadioButton);
            ((Container)object2).add(this.extendRadioButton);
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.defaultRadioButton);
            ((ButtonGroup)object).add(this.tiledRadioButton);
            ((ButtonGroup)object).add(this.centerRadioButton);
            ((ButtonGroup)object).add(this.extendRadioButton);
            this.defaultRadioButton.setSelected(true);
            this.imageFileChooser = new ImageFileChooser();
            this.imageFileChooser.setMultiSelectionEnabled(false);
        }

        public void populate(Background background) {
            this.specifySizeCheckBox.setSelected(false);
            if (background instanceof ImageBackground) {
                ImageBackground imageBackground = (ImageBackground)background;
                if (imageBackground.getLayout() == 1) {
                    this.centerRadioButton.setSelected(true);
                } else if (imageBackground.getLayout() == 2) {
                    this.extendRadioButton.setSelected(true);
                } else if (imageBackground.getLayout() == 3) {
                    this.defaultRadioButton.setSelected(true);
                } else {
                    this.tiledRadioButton.setSelected(true);
                }
                if (imageBackground.getImage() != null) {
                    this.previewPane.setImage(imageBackground.getImage());
                    this.imageSizeLabel.setText(this.previewPane.getImage().getWidth(null) + " X " + this.previewPane.getImage().getHeight(null));
                }
                this.widthNumberField.setValue(-1.0);
                this.heightNumberField.setValue(-1.0);
                if (imageBackground.getImage() != null) {
                    this.previewPane.setImage(imageBackground.getImage());
                    if (imageBackground.getSpecifiedImageWidth() != -1.0 && imageBackground.getSpecifiedImageHeight() != -1.0) {
                        this.specifySizeCheckBox.setSelected(true);
                        this.widthNumberField.setValue(imageBackground.getSpecifiedImageWidth());
                        this.heightNumberField.setValue(imageBackground.getSpecifiedImageHeight());
                    }
                }
            } else {
                this.previewPane.setImage(null);
                this.tiledRadioButton.setSelected(true);
                this.imageSizeLabel.setText("");
            }
            if (this.specifySizeCheckBox.isSelected()) {
                GUICoreUtils.setEnabled(this.southImageSizePane, true);
            } else {
                GUICoreUtils.setEnabled(this.southImageSizePane, false);
            }
            this.fireChagneListener();
        }

        public Background update() throws Exception {
            ImageBackground imageBackground = new ImageBackground(this.previewPane.getImage());
            if (this.specifySizeCheckBox.isSelected()) {
                if (this.widthNumberField.getValue() < 0.0) {
                    imageBackground.setSpecifiedImageWidth(this.previewPane.getImage().getWidth(null));
                } else {
                    imageBackground.setSpecifiedImageWidth(this.widthNumberField.getValue());
                }
                if (this.heightNumberField.getValue() < 0.0) {
                    imageBackground.setSpecifiedImageHeight(this.previewPane.getImage().getHeight(null));
                } else {
                    imageBackground.setSpecifiedImageHeight(this.heightNumberField.getValue());
                }
            } else {
                this.widthNumberField.setValue(-1.0);
                this.heightNumberField.setValue(-1.0);
            }
            if (this.tiledRadioButton.isSelected()) {
                imageBackground.setLayout(0);
            } else if (this.centerRadioButton.isSelected()) {
                imageBackground.setLayout(1);
            } else if (this.extendRadioButton.isSelected()) {
                imageBackground.setLayout(2);
            } else {
                imageBackground.setLayout(3);
            }
            return imageBackground;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        private void fireChagneListener() {
            if (this.changeListener != null) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                this.changeListener.stateChanged(changeEvent);
            }
        }

        static /* synthetic */ JCheckBox access$600(ImageBackgroundPane imageBackgroundPane) {
            return imageBackgroundPane.specifySizeCheckBox;
        }

        static /* synthetic */ JPanel access$700(ImageBackgroundPane imageBackgroundPane) {
            return imageBackgroundPane.southImageSizePane;
        }

        static /* synthetic */ ImageFileChooser access$800(ImageBackgroundPane imageBackgroundPane) {
            return imageBackgroundPane.imageFileChooser;
        }

        static /* synthetic */ ImagePreviewPane access$900(ImageBackgroundPane imageBackgroundPane) {
            return imageBackgroundPane.previewPane;
        }

        static /* synthetic */ void access$1000(ImageBackgroundPane imageBackgroundPane) {
            imageBackgroundPane.fireChagneListener();
        }

        static /* synthetic */ JLabel access$1100(ImageBackgroundPane imageBackgroundPane) {
            return imageBackgroundPane.imageSizeLabel;
        }
    }

    class PatternBackgroundPane
    extends BackgroundSettingPane {
        private int patternIndex = 0;
        private ColorSelectionPane foregroundColorPane;
        private ColorSelectionPane backgroundColorPane;
        private PatternButton[] patternButtonArray;
        ChangeListener colorChangeListener = new ChangeListener(this){
            private final /* synthetic */ PatternBackgroundPane this$1;
            {
                this.this$1 = patternBackgroundPane;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                for (int i = 0; i < PatternBackgroundPane.access$200(this.this$1).length; ++i) {
                    PatternBackgroundPane.access$200(this.this$1)[i].setPatternForeground(PatternBackgroundPane.access$300(this.this$1).getColor());
                    PatternBackgroundPane.access$200(this.this$1)[i].setPatternBackground(PatternBackgroundPane.access$400(this.this$1).getColor());
                }
                this.this$1.repaint();
            }
        };

        public PatternBackgroundPane() {
            this.initComponents();
        }

        protected void initComponents() {
            this.setLayout(LayoutFactory.createBorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "North");
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel.add(jPanel2);
            jPanel2.setLayout(new FlowLayout(1, 2, 3));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Background-Pattern")));
            JPanel jPanel3 = new JPanel();
            jPanel2.add(jPanel3);
            jPanel3.setLayout(new GridLayout(4, 12, 4, 2));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.patternButtonArray = new PatternButton[48];
            for (int i = 0; i < 48; ++i) {
                this.patternButtonArray[i] = new PatternButton(i);
                buttonGroup.add(this.patternButtonArray[i]);
                jPanel3.add(this.patternButtonArray[i]);
            }
            JPanel jPanel4 = new JPanel();
            jPanel.add(jPanel4);
            jPanel4.setLayout(new FlowLayout(1, 12, 6));
            jPanel4.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Colors")));
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            this.foregroundColorPane = new ColorSelectionPane(80);
            this.backgroundColorPane = new ColorSelectionPane(80);
            this.backgroundColorPane.setCanBeNull(true);
            this.foregroundColorPane.setColor(Color.lightGray);
            this.backgroundColorPane.setColor(Color.black);
            this.foregroundColorPane.addColorChangeListener(this.colorChangeListener);
            this.backgroundColorPane.addColorChangeListener(this.colorChangeListener);
            jPanel4.add(Box.createHorizontalStrut(2));
            jPanel4.add(this.createLabelColorPane(Inter.getLocText("Foreground") + ":", this.foregroundColorPane));
            jPanel4.add(Box.createHorizontalStrut(8));
            jPanel4.add(this.createLabelColorPane(Inter.getLocText("Background") + ":", this.backgroundColorPane));
        }

        private JPanel createLabelColorPane(String string, ColorSelectionPane colorSelectionPane) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1, 2, 0));
            jPanel.add(new JLabel(string));
            jPanel.add(colorSelectionPane);
            return jPanel;
        }

        public void populate(Background background) {
            if (background != null && background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                int n = patternBackground.getPatternIndex();
                if (n >= 0 && n < this.patternButtonArray.length) {
                    this.patternButtonArray[n].setSelected(true);
                    this.patternIndex = n;
                } else {
                    this.patternIndex = 0;
                }
                this.foregroundColorPane.setColor(patternBackground.getForeground());
                this.backgroundColorPane.setColor(patternBackground.getBackground());
            } else {
                this.patternIndex = 0;
                this.patternButtonArray[0].setSelected(true);
                this.foregroundColorPane.setColor(Color.lightGray);
                this.backgroundColorPane.setColor(Color.black);
            }
        }

        public Background update() throws Exception {
            return new PatternBackground(this.patternIndex, this.foregroundColorPane.getColor(), this.backgroundColorPane.getColor());
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.foregroundColorPane.addColorChangeListener(changeListener);
            this.backgroundColorPane.addColorChangeListener(changeListener);
            for (int i = 0; i < this.patternButtonArray.length; ++i) {
                this.patternButtonArray[i].addChangeListener(changeListener);
            }
        }

        static /* synthetic */ PatternButton[] access$200(PatternBackgroundPane patternBackgroundPane) {
            return patternBackgroundPane.patternButtonArray;
        }

        static /* synthetic */ ColorSelectionPane access$300(PatternBackgroundPane patternBackgroundPane) {
            return patternBackgroundPane.foregroundColorPane;
        }

        static /* synthetic */ ColorSelectionPane access$400(PatternBackgroundPane patternBackgroundPane) {
            return patternBackgroundPane.backgroundColorPane;
        }

        class PatternButton
        extends JToggleButton
        implements ActionListener {
            private int pIndex = 0;
            private PatternBackground patternBackground;

            public PatternButton(int n) {
                this.pIndex = n;
                this.addActionListener(this);
                this.setCursor(new Cursor(12));
                this.setBorder(null);
                this.patternBackground = new PatternBackground(this.pIndex, Color.lightGray, Color.black);
            }

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Dimension dimension = this.getSize();
                this.patternBackground.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, dimension.width - 1, dimension.height - 1));
                if (this.pIndex == PatternBackgroundPane.this.patternIndex) {
                    graphics2D.setPaint(new Color(255, 51, 0));
                } else {
                    graphics2D.setPaint(Color.gray);
                }
                GraphHelper.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, dimension.width - 1, dimension.height - 1));
            }

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }

            public void setPatternForeground(Color color) {
                this.patternBackground.setForeground(color);
            }

            public void setPatternBackground(Color color) {
                this.patternBackground.setBackground(color);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PatternBackgroundPane.this.patternIndex = this.pIndex;
                this.fireChagneListener();
                PatternBackgroundPane.this.repaint();
            }

            public void addChangeListener(ChangeListener changeListener) {
                this.changeListener = changeListener;
            }

            private void fireChagneListener() {
                if (this.changeListener != null) {
                    ChangeEvent changeEvent = new ChangeEvent(this);
                    this.changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    class TextureBackgroundPane
    extends BackgroundSettingPane {
        private TexturePaint texturePaint;
        private TextureButton[] textureButtonArray;

        public TextureBackgroundPane() {
            this.initComponents();
        }

        protected void initComponents() {
            this.setLayout(LayoutFactory.createBorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, "North");
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel.add(jPanel2);
            jPanel2.setLayout(new FlowLayout(1, 2, 3));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Background-Texture")));
            JPanel jPanel3 = new JPanel();
            jPanel2.add(jPanel3);
            jPanel3.setLayout(new GridLayout(3, 8, 6, 4));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.textureButtonArray = new TextureButton[EmbedTexturePaintArray.length];
            for (int i = 0; i < EmbedTexturePaintArray.length; ++i) {
                this.textureButtonArray[i] = new TextureButton(EmbedTexturePaintArray[i], EmbedTexturePaintDesArray[i]);
                buttonGroup.add(this.textureButtonArray[i]);
                jPanel3.add(this.textureButtonArray[i]);
            }
        }

        public void populate(Background background) {
            if (background instanceof TextureBackground) {
                TextureBackground textureBackground = (TextureBackground)background;
                this.texturePaint = textureBackground.getTexturePaint();
                for (int i = 0; i < this.textureButtonArray.length; ++i) {
                    if (!this.textureButtonArray[i].getTexturePaint().equals(this.texturePaint)) continue;
                    this.textureButtonArray[i].setSelected(true);
                    break;
                }
            } else {
                this.textureButtonArray[0].setSelected(true);
                this.texturePaint = this.textureButtonArray[0].getTexturePaint();
            }
        }

        public Background update() throws Exception {
            return new TextureBackground(this.texturePaint);
        }

        public void addChangeListener(ChangeListener changeListener) {
            for (int i = 0; i < this.textureButtonArray.length; ++i) {
                this.textureButtonArray[i].addChangeListener(changeListener);
            }
        }

        class TextureButton
        extends JToggleButton
        implements ActionListener {
            private TexturePaint buttonTexturePaint;

            public TextureButton(TexturePaint texturePaint, String string) {
                this.buttonTexturePaint = texturePaint;
                this.setToolTipText(string);
                this.setCursor(new Cursor(12));
                this.addActionListener(this);
                this.setBorder(null);
            }

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Dimension dimension = this.getSize();
                graphics2D.setPaint(this.buttonTexturePaint);
                GraphHelper.fill(graphics2D, new Rectangle2D.Double(0.0, 0.0, dimension.width - 1, dimension.height - 1));
                if (ComparatorUtils.equals(TextureBackgroundPane.this.texturePaint, this.buttonTexturePaint)) {
                    graphics2D.setPaint(Color.black);
                } else {
                    graphics2D.setPaint(Color.gray);
                }
                GraphHelper.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, dimension.width - 1, dimension.height - 1));
            }

            public Dimension getPreferredSize() {
                return new Dimension(36, 32);
            }

            public TexturePaint getTexturePaint() {
                return this.buttonTexturePaint;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TextureBackgroundPane.this.texturePaint = this.getTexturePaint();
                this.fireChagneListener();
                TextureBackgroundPane.this.repaint();
            }

            public void addChangeListener(ChangeListener changeListener) {
                this.changeListener = changeListener;
            }

            private void fireChagneListener() {
                if (this.changeListener != null) {
                    ChangeEvent changeEvent = new ChangeEvent(this);
                    this.changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    class ColorBackgroundPane
    extends BackgroundSettingPane {
        private DetailColorSelectPane detailColorSelectPane;

        public ColorBackgroundPane() {
            this.setLayout(LayoutFactory.createBorderLayout());
            this.detailColorSelectPane = new DetailColorSelectPane();
            this.add((Component)this.detailColorSelectPane, "Center");
        }

        public void populate(Background background) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                this.detailColorSelectPane.populate(colorBackground.getColor());
            } else {
                this.detailColorSelectPane.populate(Color.white);
            }
        }

        public Background update() throws Exception {
            return ColorBackground.getInstance(this.detailColorSelectPane.update());
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.detailColorSelectPane.addChangeListener(changeListener);
        }
    }

    class NullBackgroundPane
    extends BackgroundSettingPane {
        public NullBackgroundPane() {
            this.setLayout(LayoutFactory.createBorderLayout());
            JLabel jLabel = new JLabel(Inter.getLocText("Background-Background_is_NULL") + "...");
            this.add(jLabel);
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createLineBorder(GUICoreUtils.getTitleLineBorderColor()));
        }

        public void populate(Background background) {
        }

        public Background update() throws Exception {
            return null;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }
    }

    abstract class BackgroundSettingPane
    extends JPanel {
        BackgroundSettingPane() {
        }

        public abstract void populate(Background var1);

        public abstract Background update() throws Exception;

        public abstract void addChangeListener(ChangeListener var1);
    }
}

