/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.Style;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.cell.core.GUIConstants;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.BasicPane;
import com.fr.dialog.core.CellBorderStyle;
import com.fr.dialog.core.ColorSelectionPane;
import com.fr.dialog.core.LineComboBox;
import com.fr.dialog.core.VerticalFlowLayout;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FloatElement;
import com.fr.report.TemplateReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BorderPane
extends BasicPane {
    private static final int NO_BORDERS = 0;
    private static final int EXTERNAL_BORDERS = 1;
    private static final int INSIDE_BORDERS = 2;
    private static final int TOP_BORDER = 3;
    private static final int LEFT_BORDER = 4;
    private static final int BOTTOM_BORDER = 5;
    private static final int RIGHT_BORDER = 6;
    private static final int VERTICAL_BORDER = 7;
    private static final int HORIZONTAL_BORDER = 8;
    private boolean insideMode = false;
    private CellBorderStyle cellBorderStyle = new CellBorderStyle();
    private BorderButton insideBorderButton;
    private BorderComponent borderComponent;
    private JToggleButton topToggleButton;
    private JToggleButton horizontalToggleButton;
    private JToggleButton bottomToggleButton;
    private JToggleButton leftToggleButton;
    private JToggleButton verticalToggleButton;
    private JToggleButton rightToggleButton;
    private LineComboBox currentLineCombo;
    private ColorSelectionPane currentLineColorPane;
    private EventListenerList eventChangeList = new EventListenerList();
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BorderPane.this.fireStateChanged();
        }
    };
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public BorderPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setLayout(new BorderLayout(4, 0));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new BorderLayout(0, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Preview") + ":"));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 16, 0));
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        jPanel3.add(new JLabel(" "));
        BorderButtonIcon borderButtonIcon = new BorderButtonIcon(0);
        BorderButton borderButton = new BorderButton(borderButtonIcon);
        borderButton.addActionListener(this.actionListener);
        borderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BorderPane.this.borderComponent.setActiveBorders(0);
                BorderPane.this.cellBorderStyle.setTopColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setTopStyle(0);
                BorderPane.this.cellBorderStyle.setHorizontalColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setHorizontalStyle(0);
                BorderPane.this.cellBorderStyle.setBottomColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setBottomStyle(0);
                BorderPane.this.cellBorderStyle.setLeftColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setLeftStyle(0);
                BorderPane.this.cellBorderStyle.setVerticalColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setVerticalStyle(0);
                BorderPane.this.cellBorderStyle.setRightColor(Color.BLACK);
                BorderPane.this.cellBorderStyle.setRightStyle(0);
                BorderPane.this.refreshAllToggleButtons();
                BorderPane.this.borderComponent.repaint();
            }
        });
        jPanel3.add(this.createVerButtonPane(borderButton, Inter.getLocText("No")));
        BorderButtonIcon borderButtonIcon2 = new BorderButtonIcon(1);
        BorderButton borderButton2 = new BorderButton(borderButtonIcon2);
        borderButton2.addActionListener(this.actionListener);
        borderButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BorderPane.this.borderComponent.setActiveBorders(1);
                BorderPane.this.cellBorderStyle.setTopColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setTopStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.cellBorderStyle.setBottomColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setBottomStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.cellBorderStyle.setLeftColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setLeftStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.cellBorderStyle.setRightColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setRightStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.refreshAllToggleButtons();
                BorderPane.this.borderComponent.repaint();
            }
        });
        jPanel3.add(this.createVerButtonPane(borderButton2, Inter.getLocText("External")));
        BorderButtonIcon borderButtonIcon3 = new BorderButtonIcon(2);
        this.insideBorderButton = new BorderButton(borderButtonIcon3);
        this.insideBorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BorderPane.this.borderComponent.setActiveBorders(2);
                BorderPane.this.cellBorderStyle.setHorizontalColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setHorizontalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.cellBorderStyle.setVerticalColor(BorderPane.this.currentLineColorPane.getColor());
                BorderPane.this.cellBorderStyle.setVerticalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                BorderPane.this.refreshAllToggleButtons();
                BorderPane.this.borderComponent.repaint();
            }
        });
        jPanel3.add(this.createVerButtonPane(this.insideBorderButton, Inter.getLocText("Inside")));
        JPanel jPanel4 = new JPanel();
        jPanel2.add((Component)jPanel4, "Center");
        jPanel4.setLayout(new BorderLayout(0, 2));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.borderComponent = new BorderComponent();
        this.borderComponent.addBorderChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BorderPane.this.fireStateChanged();
            }
        });
        jPanel4.add((Component)this.borderComponent, "Center");
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel4.add((Component)jPanel5, "West");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(LayoutFactory.createBorderLayout());
        jPanel4.add((Component)jPanel8, "South");
        jPanel8.add((Component)jPanel7, "Center");
        jPanel8.add((Component)jPanel6, "West");
        jPanel5.setLayout(new VerticalFlowLayout(1, 4, 16));
        this.topToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/top.png"), 3);
        this.horizontalToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/horizontal.png"), 8);
        this.bottomToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/bottom.png"), 5);
        this.leftToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/left.png"), 4);
        this.verticalToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/vertical.png"), 7);
        this.rightToggleButton = new ToggleButton(BaseUtils.readIcon("/com/fr/dialog/images/border/right.png"), 6);
        jPanel5.add(this.topToggleButton);
        jPanel5.add(this.horizontalToggleButton);
        jPanel5.add(this.bottomToggleButton);
        jPanel7.setLayout(new FlowLayout(1, 42, 5));
        jPanel7.add(this.leftToggleButton);
        jPanel7.add(this.verticalToggleButton);
        jPanel7.add(this.rightToggleButton);
        jPanel6.setPreferredSize(new Dimension(jPanel5.getPreferredSize().width, jPanel7.getPreferredSize().height));
        JPanel jPanel9 = new JPanel();
        jPanel.add((Component)jPanel9, "West");
        jPanel9.setLayout(LayoutFactory.createBorderLayout());
        jPanel9.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Line") + ":"));
        JPanel jPanel10 = new JPanel();
        jPanel9.add((Component)jPanel10, "North");
        jPanel10.setLayout(new GridLayout(4, 1, 2, 2));
        jPanel10.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel10.add(new JLabel(Inter.getLocText("Style") + ":"));
        this.currentLineCombo = new LineComboBox(GUIConstants.BorderlineStyleArray);
        jPanel10.add(this.currentLineCombo);
        jPanel10.add(new JLabel(Inter.getLocText("Color") + ":"));
        this.currentLineColorPane = new ColorSelectionPane(100);
        jPanel10.add(this.currentLineColorPane);
        this.currentLineColorPane.setColor(Color.BLACK);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventChangeList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BorderPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void fireStateChanged() {
        Object[] objectArray = this.eventChangeList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? BorderPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private JPanel createVerButtonPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalFlowLayout(1, 2, 2));
        jPanel.add(jComponent);
        jPanel.add(new JLabel(string));
        return jPanel;
    }

    private void refreshAllToggleButtons() {
        this.topToggleButton.setSelected(this.cellBorderStyle.getTopStyle() != 0);
        this.horizontalToggleButton.setSelected(this.cellBorderStyle.getHorizontalStyle() != 0);
        this.bottomToggleButton.setSelected(this.cellBorderStyle.getBottomStyle() != 0);
        this.leftToggleButton.setSelected(this.cellBorderStyle.getLeftStyle() != 0);
        this.verticalToggleButton.setSelected(this.cellBorderStyle.getVerticalStyle() != 0);
        this.rightToggleButton.setSelected(this.cellBorderStyle.getRightStyle() != 0);
    }

    public CellBorderStyle getCellBorderStyle() {
        return this.cellBorderStyle;
    }

    public void setCellBorderStyle(CellBorderStyle cellBorderStyle) {
        this.cellBorderStyle = cellBorderStyle;
    }

    public void populate(ReportPane reportPane) {
        Object[] objectArray = this.createCellBorderObject(reportPane);
        if (objectArray != null && objectArray.length == 4) {
            this.populate((CellBorderStyle)objectArray[0], (Boolean)objectArray[1], (Integer)objectArray[2], (Color)objectArray[3]);
        }
    }

    public void populate(Style style) {
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        CellBorderStyle cellBorderStyle = new CellBorderStyle();
        cellBorderStyle.setTopStyle(style.getBorderTop());
        cellBorderStyle.setTopColor(style.getBorderTopColor());
        cellBorderStyle.setLeftStyle(style.getBorderLeft());
        cellBorderStyle.setLeftColor(style.getBorderLeftColor());
        cellBorderStyle.setBottomStyle(style.getBorderBottom());
        cellBorderStyle.setBottomColor(style.getBorderBottomColor());
        cellBorderStyle.setRightStyle(style.getBorderRight());
        cellBorderStyle.setRightColor(style.getBorderRightColor());
        this.populate(cellBorderStyle, false, style.getBorderTop(), style.getBorderTopColor());
    }

    public void populate(CellBorderStyle cellBorderStyle, boolean bl, int n, Color color) {
        try {
            if (cellBorderStyle != null) {
                this.cellBorderStyle = (CellBorderStyle)cellBorderStyle.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        this.insideMode = bl;
        this.currentLineCombo.setSelectedLineStyle(n == 0 ? 1 : n);
        this.currentLineColorPane.setColor(color);
        this.insideBorderButton.setEnabled(this.insideMode);
        this.horizontalToggleButton.setEnabled(this.insideMode);
        this.verticalToggleButton.setEnabled(this.insideMode);
        this.borderComponent.repaint();
    }

    public boolean update(ReportPane reportPane) {
        boolean bl = false;
        Object[] objectArray = this.createCellBorderObject(reportPane);
        if (objectArray == null || objectArray.length < 4) {
            return false;
        }
        CellBorderStyle cellBorderStyle = (CellBorderStyle)objectArray[0];
        CellBorderStyle cellBorderStyle2 = this.update();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            FloatElement floatElement = templateReport.getFloatElement(gridSelection.getLastFloatName());
            if (!ComparatorUtils.equals(cellBorderStyle, cellBorderStyle2)) {
                bl = true;
                Style style = floatElement.getStyle();
                floatElement.setStyle(style.deriveBorder(cellBorderStyle2.getTopStyle(), cellBorderStyle2.getTopColor(), cellBorderStyle2.getBottomStyle(), cellBorderStyle2.getBottomColor(), cellBorderStyle2.getLeftStyle(), cellBorderStyle2.getLeftColor(), cellBorderStyle2.getRightStyle(), cellBorderStyle2.getRightColor()));
            }
            return bl;
        }
        int n2 = gridSelection.getCellRectangleCount();
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = gridSelection.getCellRectangle(i);
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            if (ComparatorUtils.equals(cellBorderStyle, cellBorderStyle2)) continue;
            bl = true;
            for (int j = n3; j < n3 + n5; ++j) {
                for (int k = n4; k < n4 + n6; ++k) {
                    CellElement cellElement = templateReport.getCellElement(j, k);
                    if (cellElement == null) {
                        cellElement = new DefaultCellElement(j, k);
                        templateReport.addCellElement(cellElement);
                    }
                    Style style = cellElement.getStyle();
                    if (cellElement.getColumn() == n3) {
                        if (cellBorderStyle.getLeftStyle() != cellBorderStyle2.getLeftStyle() || !ComparatorUtils.equals(cellBorderStyle.getLeftColor(), cellBorderStyle2.getLeftColor())) {
                            style = style.deriveBorderLeft(cellBorderStyle2.getLeftStyle(), cellBorderStyle2.getLeftColor());
                        }
                    } else if (cellBorderStyle.getVerticalStyle() != cellBorderStyle2.getVerticalStyle() || !ComparatorUtils.equals(cellBorderStyle.getVerticalColor(), cellBorderStyle2.getVerticalColor())) {
                        style = style.deriveBorderLeft(cellBorderStyle2.getVerticalStyle(), cellBorderStyle2.getVerticalColor());
                    }
                    if (cellElement.getColumn() + cellElement.getColumnSpan() == n3 + n5) {
                        if (cellBorderStyle.getRightStyle() != cellBorderStyle2.getRightStyle() || !ComparatorUtils.equals(cellBorderStyle.getRightColor(), cellBorderStyle2.getRightColor())) {
                            style = style.deriveBorderRight(cellBorderStyle2.getRightStyle(), cellBorderStyle2.getRightColor());
                        }
                    } else if (cellBorderStyle.getVerticalStyle() != cellBorderStyle2.getVerticalStyle() || !ComparatorUtils.equals(cellBorderStyle.getVerticalColor(), cellBorderStyle2.getVerticalColor())) {
                        style = style.deriveBorderRight(cellBorderStyle2.getVerticalStyle(), cellBorderStyle2.getVerticalColor());
                    }
                    if (cellElement.getRow() == n4) {
                        if (cellBorderStyle.getTopStyle() != cellBorderStyle2.getTopStyle() || !ComparatorUtils.equals(cellBorderStyle.getTopColor(), cellBorderStyle2.getTopColor())) {
                            style = style.deriveBorderTop(cellBorderStyle2.getTopStyle(), cellBorderStyle2.getTopColor());
                        }
                    } else if (cellBorderStyle.getHorizontalStyle() != cellBorderStyle2.getHorizontalStyle() || !ComparatorUtils.equals(cellBorderStyle.getHorizontalColor(), cellBorderStyle2.getHorizontalColor())) {
                        style = style.deriveBorderTop(cellBorderStyle2.getHorizontalStyle(), cellBorderStyle2.getHorizontalColor());
                    }
                    if (cellElement.getRow() + cellElement.getRowSpan() == n4 + n6) {
                        if (cellBorderStyle.getBottomStyle() != cellBorderStyle2.getBottomStyle() || !ComparatorUtils.equals(cellBorderStyle.getBottomColor(), cellBorderStyle2.getBottomColor())) {
                            style = style.deriveBorderBottom(cellBorderStyle2.getBottomStyle(), cellBorderStyle2.getBottomColor());
                        }
                    } else if (cellBorderStyle.getHorizontalStyle() != cellBorderStyle2.getHorizontalStyle() || !ComparatorUtils.equals(cellBorderStyle.getHorizontalColor(), cellBorderStyle2.getHorizontalColor())) {
                        style = style.deriveBorderBottom(cellBorderStyle2.getHorizontalStyle(), cellBorderStyle2.getHorizontalColor());
                    }
                    cellElement.setStyle(style);
                }
            }
        }
        return bl;
    }

    public Style update(Style style) {
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        CellBorderStyle cellBorderStyle = this.update();
        style = style.deriveBorder(cellBorderStyle.getTopStyle(), cellBorderStyle.getTopColor(), cellBorderStyle.getBottomStyle(), cellBorderStyle.getBottomColor(), cellBorderStyle.getLeftStyle(), cellBorderStyle.getLeftColor(), cellBorderStyle.getRightStyle(), cellBorderStyle.getRightColor());
        return style;
    }

    public CellBorderStyle update() {
        return this.cellBorderStyle;
    }

    private boolean isAllEquals(List list) {
        int n = 0;
        while (n + 1 < list.size()) {
            if (!ComparatorUtils.equals(list.get(n), list.get(n + 1))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Object[] createCellBorderObject(ReportPane reportPane) {
        Serializable serializable;
        Cloneable cloneable;
        CellBorderStyle cellBorderStyle = new CellBorderStyle();
        boolean bl = false;
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            cloneable = templateReport.getFloatElement(gridSelection.getLastFloatName());
            serializable = ((FloatElement)cloneable).getStyle();
            cellBorderStyle.setTopColor(serializable.getBorderTopColor());
            cellBorderStyle.setTopStyle(serializable.getBorderTop());
            cellBorderStyle.setLeftColor(serializable.getBorderLeftColor());
            cellBorderStyle.setLeftStyle(serializable.getBorderLeft());
            cellBorderStyle.setBottomColor(serializable.getBorderBottomColor());
            cellBorderStyle.setBottomStyle(serializable.getBorderBottom());
            cellBorderStyle.setRightColor(serializable.getBorderRightColor());
            cellBorderStyle.setRightStyle(serializable.getBorderRight());
        } else {
            int n2;
            Object object;
            CellElement cellElement;
            int n3;
            cloneable = gridSelection.getLastCellRectangle();
            int n4 = ((Rectangle)cloneable).x;
            int n5 = ((Rectangle)cloneable).y;
            int n6 = ((Rectangle)cloneable).width;
            int n7 = ((Rectangle)cloneable).height;
            Hashtable<ColumnRow, BorderStyleColor> hashtable = new Hashtable<ColumnRow, BorderStyleColor>();
            Hashtable<ColumnRow, BorderStyleColor> hashtable2 = new Hashtable<ColumnRow, BorderStyleColor>();
            Hashtable<ColumnRow, BorderStyleColor> hashtable3 = new Hashtable<ColumnRow, BorderStyleColor>();
            Hashtable<ColumnRow, BorderStyleColor> hashtable4 = new Hashtable<ColumnRow, BorderStyleColor>();
            if (n5 - 1 >= 0) {
                for (n3 = n4; n3 < n4 + n6; ++n3) {
                    cellElement = templateReport.getCellElement(n3, n5 - 1);
                    if (cellElement == null || ((Style)(object = cellElement.getStyle())).getBorderBottom() == 0) continue;
                    for (n2 = cellElement.getColumn(); n2 < cellElement.getColumn() + cellElement.getColumnSpan(); ++n2) {
                        hashtable2.put(new ColumnRow(n2, n5, false), new BorderStyleColor(((Style)object).getBorderBottom(), ((Style)object).getBorderBottomColor()));
                    }
                }
            }
            if (n4 - 1 >= 0) {
                for (n3 = n5; n3 < n5 + n7; ++n3) {
                    cellElement = templateReport.getCellElement(n4 - 1, n3);
                    if (cellElement == null || ((Style)(object = cellElement.getStyle())).getBorderRight() == 0) continue;
                    for (n2 = cellElement.getRow(); n2 < cellElement.getRow() + cellElement.getRowSpan(); ++n2) {
                        hashtable4.put(new ColumnRow(n4, n2, true), new BorderStyleColor(((Style)object).getBorderRight(), ((Style)object).getBorderRightColor()));
                    }
                }
            }
            for (n3 = n4; n3 < n4 + n6; ++n3) {
                cellElement = templateReport.getCellElement(n3, n5 + n7);
                if (cellElement == null || ((Style)(object = cellElement.getStyle())).getBorderTop() == 0) continue;
                for (n2 = cellElement.getColumn(); n2 < cellElement.getColumn() + cellElement.getColumnSpan(); ++n2) {
                    hashtable.put(new ColumnRow(n2, n5 + n7, false), new BorderStyleColor(((Style)object).getBorderTop(), ((Style)object).getBorderTopColor()));
                }
            }
            for (n3 = n5; n3 < n5 + n7; ++n3) {
                cellElement = templateReport.getCellElement(n4 + n6, n3);
                if (cellElement == null || ((Style)(object = cellElement.getStyle())).getBorderLeft() == 0) continue;
                for (n2 = cellElement.getRow(); n2 < cellElement.getRow() + cellElement.getRowSpan(); ++n2) {
                    hashtable3.put(new ColumnRow(n4 + n6, n2, true), new BorderStyleColor(((Style)object).getBorderLeft(), ((Style)object).getBorderLeftColor()));
                }
            }
            for (n3 = n4; n3 < n4 + n6; ++n3) {
                for (int i = n5; i < n5 + n7; ++i) {
                    int n8;
                    object = templateReport.getCellElement(n3, i);
                    if (object == null) continue;
                    Style style = object.getStyle();
                    if (style.getBorderTop() != 0) {
                        for (n8 = object.getColumn(); n8 < object.getColumn() + object.getColumnSpan(); ++n8) {
                            hashtable.put(new ColumnRow(n8, object.getRow(), false), new BorderStyleColor(style.getBorderTop(), style.getBorderTopColor()));
                        }
                    }
                    if (style.getBorderLeft() != 0) {
                        for (n8 = object.getRow(); n8 < object.getRow() + object.getRowSpan(); ++n8) {
                            hashtable3.put(new ColumnRow(object.getColumn(), n8, true), new BorderStyleColor(style.getBorderLeft(), style.getBorderLeftColor()));
                        }
                    }
                    if (style.getBorderBottom() != 0) {
                        for (n8 = object.getColumn(); n8 < object.getColumn() + object.getColumnSpan(); ++n8) {
                            hashtable2.put(new ColumnRow(n8, object.getRow() + object.getRowSpan(), false), new BorderStyleColor(style.getBorderBottom(), style.getBorderBottomColor()));
                        }
                    }
                    if (style.getBorderRight() == 0) continue;
                    for (n8 = object.getRow(); n8 < object.getRow() + object.getRowSpan(); ++n8) {
                        hashtable4.put(new ColumnRow(object.getColumn() + object.getColumnSpan(), n8, true), new BorderStyleColor(style.getBorderRight(), style.getBorderRightColor()));
                    }
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = n4; i < n4 + n6; ++i) {
                object = (BorderStyleColor)hashtable.get(new ColumnRow(i, n5, false));
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                if (this.isAllEquals(arrayList)) {
                    BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                    if (borderStyleColor != null) {
                        cellBorderStyle.setTopColor(borderStyleColor.getColor());
                        cellBorderStyle.setTopStyle(borderStyleColor.getStyle());
                    }
                } else {
                    cellBorderStyle.setTopColor(Color.GRAY);
                    cellBorderStyle.setTopStyle(15);
                }
            }
            arrayList.clear();
            for (int i = n5; i < n5 + n7; ++i) {
                object = (BorderStyleColor)hashtable3.get(new ColumnRow(n4, i, true));
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                if (this.isAllEquals(arrayList)) {
                    BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                    if (borderStyleColor != null) {
                        cellBorderStyle.setLeftColor(borderStyleColor.getColor());
                        cellBorderStyle.setLeftStyle(borderStyleColor.getStyle());
                    }
                } else {
                    cellBorderStyle.setLeftColor(Color.GRAY);
                    cellBorderStyle.setLeftStyle(15);
                }
            }
            arrayList.clear();
            for (int i = n4; i < n4 + n6; ++i) {
                object = (BorderStyleColor)hashtable2.get(new ColumnRow(i, n5 + n7, false));
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                if (this.isAllEquals(arrayList)) {
                    BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                    if (borderStyleColor != null) {
                        cellBorderStyle.setBottomColor(borderStyleColor.getColor());
                        cellBorderStyle.setBottomStyle(borderStyleColor.getStyle());
                    }
                } else {
                    cellBorderStyle.setBottomColor(Color.GRAY);
                    cellBorderStyle.setBottomStyle(15);
                }
            }
            arrayList.clear();
            for (int i = n5; i < n5 + n7; ++i) {
                object = (BorderStyleColor)hashtable4.get(new ColumnRow(n4 + n6, i, true));
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                if (this.isAllEquals(arrayList)) {
                    BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                    if (borderStyleColor != null) {
                        cellBorderStyle.setRightColor(borderStyleColor.getColor());
                        cellBorderStyle.setRightStyle(borderStyleColor.getStyle());
                    }
                } else {
                    cellBorderStyle.setRightColor(Color.GRAY);
                    cellBorderStyle.setRightStyle(15);
                }
            }
            if (n6 > 1 || n7 > 1) {
                bl = true;
                arrayList.clear();
                for (int i = n4 + 1; i < n4 + n6; ++i) {
                    for (int j = n5; j < n5 + n7; ++j) {
                        BorderStyleColor borderStyleColor = (BorderStyleColor)hashtable3.get(new ColumnRow(i, j, true));
                        arrayList.add(borderStyleColor);
                        borderStyleColor = (BorderStyleColor)hashtable4.get(new ColumnRow(i, j, true));
                        arrayList.add(borderStyleColor);
                    }
                }
                if (arrayList.size() > 0) {
                    if (this.isAllEquals(arrayList)) {
                        BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                        if (borderStyleColor != null) {
                            cellBorderStyle.setVerticalColor(borderStyleColor.getColor());
                            cellBorderStyle.setVerticalStyle(borderStyleColor.getStyle());
                        }
                    } else {
                        cellBorderStyle.setVerticalColor(Color.GRAY);
                        cellBorderStyle.setVerticalStyle(15);
                    }
                }
                arrayList.clear();
                for (int i = n4; i < n4 + n6; ++i) {
                    for (int j = n5 + 1; j < n5 + n7; ++j) {
                        BorderStyleColor borderStyleColor = (BorderStyleColor)hashtable.get(new ColumnRow(i, j, false));
                        arrayList.add(borderStyleColor);
                        borderStyleColor = (BorderStyleColor)hashtable2.get(new ColumnRow(i, j, false));
                        arrayList.add(borderStyleColor);
                    }
                }
                if (arrayList.size() > 0) {
                    if (this.isAllEquals(arrayList)) {
                        BorderStyleColor borderStyleColor = (BorderStyleColor)arrayList.get(0);
                        if (borderStyleColor != null) {
                            cellBorderStyle.setHorizontalColor(borderStyleColor.getColor());
                            cellBorderStyle.setHorizontalStyle(borderStyleColor.getStyle());
                        }
                    } else {
                        cellBorderStyle.setHorizontalColor(Color.GRAY);
                        cellBorderStyle.setHorizontalStyle(15);
                    }
                }
            }
        }
        int n9 = 0;
        serializable = Color.BLACK;
        if (cellBorderStyle.getLeftStyle() != 0 && cellBorderStyle.getLeftStyle() != 15) {
            n9 = cellBorderStyle.getLeftStyle();
            serializable = cellBorderStyle.getLeftColor();
        } else if (cellBorderStyle.getTopStyle() != 0 && cellBorderStyle.getTopStyle() != 15) {
            n9 = cellBorderStyle.getTopStyle();
            serializable = cellBorderStyle.getTopColor();
        } else if (cellBorderStyle.getBottomStyle() != 0 && cellBorderStyle.getBottomStyle() != 15) {
            n9 = cellBorderStyle.getBottomStyle();
            serializable = cellBorderStyle.getBottomColor();
        } else if (cellBorderStyle.getRightStyle() != 0 && cellBorderStyle.getRightStyle() != 15) {
            n9 = cellBorderStyle.getRightStyle();
            serializable = cellBorderStyle.getRightColor();
        } else if (cellBorderStyle.getVerticalStyle() != 0 && cellBorderStyle.getVerticalStyle() != 15) {
            n9 = cellBorderStyle.getVerticalStyle();
            serializable = cellBorderStyle.getVerticalColor();
        } else if (cellBorderStyle.getHorizontalStyle() != 0 && cellBorderStyle.getHorizontalStyle() != 15) {
            n9 = cellBorderStyle.getHorizontalStyle();
            serializable = cellBorderStyle.getHorizontalColor();
        }
        return new Object[]{cellBorderStyle, bl ? Boolean.TRUE : Boolean.FALSE, new Integer(n9), serializable};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BorderComponent
    extends JComponent {
        private boolean topActive = false;
        private boolean leftActive = false;
        private boolean bottomActive = false;
        private boolean rightActive = false;
        private boolean verticalActive = false;
        private boolean horizontalActive = false;
        private EventListenerList borderChangeListenerList = new EventListenerList();

        private BorderComponent() {
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ BorderComponent this$1;
                {
                    this.this$1 = borderComponent;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getX() <= 24) {
                        if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getLeftColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getLeftStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setLeftColor(Color.BLACK);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setLeftStyle(0);
                            BorderComponent.access$300(this.this$1, 0);
                        } else {
                            BorderComponent.access$300(this.this$1, 4);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setLeftColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setLeftStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                        }
                    } else if (mouseEvent.getY() <= 24) {
                        if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getTopColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getTopStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setTopColor(Color.BLACK);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setTopStyle(0);
                            BorderComponent.access$300(this.this$1, 0);
                        } else {
                            BorderComponent.access$300(this.this$1, 3);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setTopColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setTopStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                        }
                    } else if (mouseEvent.getY() > this.this$1.getHeight() - 24) {
                        if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getBottomColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getBottomStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setBottomColor(Color.BLACK);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setBottomStyle(0);
                            BorderComponent.access$300(this.this$1, 0);
                        } else {
                            BorderComponent.access$300(this.this$1, 5);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setBottomColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setBottomStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                        }
                    } else if (mouseEvent.getX() > this.this$1.getWidth() - 24) {
                        if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getRightColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getRightStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setRightColor(Color.BLACK);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setRightStyle(0);
                            BorderComponent.access$300(this.this$1, 0);
                        } else {
                            BorderComponent.access$300(this.this$1, 6);
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setRightColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                            BorderPane.access$400(BorderComponent.access$900(this.this$1)).setRightStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                        }
                    } else if (BorderPane.access$1000(BorderComponent.access$900(this.this$1))) {
                        if (mouseEvent.getX() > this.this$1.getWidth() / 2 - 8 && mouseEvent.getX() < this.this$1.getWidth() / 2 + 8) {
                            if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getVerticalColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getVerticalStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setVerticalColor(Color.BLACK);
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setVerticalStyle(0);
                                BorderComponent.access$300(this.this$1, 0);
                            } else {
                                BorderComponent.access$300(this.this$1, 7);
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setVerticalColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setVerticalStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                            }
                        } else if (mouseEvent.getY() > this.this$1.getHeight() / 2 - 8 && mouseEvent.getY() < this.this$1.getHeight() / 2 + 8) {
                            if (BorderPane.access$400(BorderComponent.access$900(this.this$1)).getHorizontalColor() == BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor() && BorderPane.access$400(BorderComponent.access$900(this.this$1)).getHorizontalStyle() == BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle()) {
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setHorizontalColor(Color.BLACK);
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setHorizontalStyle(0);
                                BorderComponent.access$300(this.this$1, 0);
                            } else {
                                BorderComponent.access$300(this.this$1, 8);
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setHorizontalColor(BorderPane.access$600(BorderComponent.access$900(this.this$1)).getColor());
                                BorderPane.access$400(BorderComponent.access$900(this.this$1)).setHorizontalStyle(BorderPane.access$700(BorderComponent.access$900(this.this$1)).getSelectedLineStyle());
                            }
                        }
                    }
                    BorderPane.access$500(BorderComponent.access$900(this.this$1));
                    this.this$1.repaint();
                }
            });
        }

        public void paint(Graphics graphics) {
            int[] nArray;
            int[] nArray2;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this.topActive) {
                nArray2 = new int[]{3, 3, 10};
                nArray = new int[]{7, 13, 10};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(3, 10, 10, 10);
            }
            if (this.leftActive) {
                nArray2 = new int[]{7, 13, 10};
                nArray = new int[]{3, 3, 10};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(10, 3, 10, 10);
            }
            if (BorderPane.this.insideMode) {
                graphics.drawLine(this.getWidth() / 2 - 3, 10, this.getWidth() / 2 + 3, 10);
                if (this.verticalActive) {
                    nArray2 = new int[]{this.getWidth() / 2 - 3, this.getWidth() / 2 + 3, this.getWidth() / 2};
                    nArray = new int[]{3, 3, 10};
                    graphics.fillPolygon(nArray2, nArray, 3);
                } else {
                    graphics.drawLine(this.getWidth() / 2, 3, this.getWidth() / 2, 10);
                }
            }
            if (this.topActive) {
                nArray2 = new int[]{this.getWidth() - 3, this.getWidth() - 11, this.getWidth() - 3};
                nArray = new int[]{7, 10, 13};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(this.getWidth() - 11, 10, this.getWidth() - 4, 10);
            }
            if (this.rightActive) {
                nArray2 = new int[]{this.getWidth() - 14, this.getWidth() - 8, this.getWidth() - 11};
                nArray = new int[]{3, 3, 10};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(this.getWidth() - 11, 3, this.getWidth() - 11, 10);
            }
            if (BorderPane.this.insideMode) {
                graphics.drawLine(this.getWidth() - 11, this.getHeight() / 2 - 3, this.getWidth() - 11, this.getHeight() / 2 + 3);
                if (this.horizontalActive) {
                    nArray2 = new int[]{this.getWidth() - 3, this.getWidth() - 11, this.getWidth() - 3};
                    nArray = new int[]{this.getHeight() / 2 - 3, this.getHeight() / 2, this.getHeight() / 2 + 3};
                    graphics.fillPolygon(nArray2, nArray, 3);
                } else {
                    graphics.drawLine(this.getWidth() - 11, this.getHeight() / 2, this.getWidth() - 4, this.getHeight() / 2);
                }
            }
            if (this.bottomActive) {
                nArray2 = new int[]{3, 3, 10};
                nArray = new int[]{this.getHeight() - 14, this.getHeight() - 8, this.getHeight() - 11};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(3, this.getHeight() - 11, 10, this.getHeight() - 11);
            }
            if (this.leftActive) {
                nArray2 = new int[]{7, 13, 10};
                nArray = new int[]{this.getHeight() - 3, this.getHeight() - 3, this.getHeight() - 11};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(10, this.getHeight() - 11, 10, this.getHeight() - 4);
            }
            if (BorderPane.this.insideMode) {
                graphics.drawLine(10, this.getHeight() / 2 - 3, 10, this.getHeight() / 2 + 3);
                if (this.horizontalActive) {
                    nArray2 = new int[]{3, 3, 10};
                    nArray = new int[]{this.getHeight() / 2 - 3, this.getHeight() / 2 + 3, this.getHeight() / 2};
                    graphics.fillPolygon(nArray2, nArray, 3);
                } else {
                    graphics.drawLine(3, this.getHeight() / 2, 10, this.getHeight() / 2);
                }
            }
            if (this.rightActive) {
                nArray2 = new int[]{this.getWidth() - 14, this.getWidth() - 8, this.getWidth() - 11};
                nArray = new int[]{this.getHeight() - 3, this.getHeight() - 3, this.getHeight() - 11};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(this.getWidth() - 11, this.getHeight() - 11, this.getWidth() - 11, this.getHeight() - 4);
            }
            if (this.bottomActive) {
                nArray2 = new int[]{this.getWidth() - 3, this.getWidth() - 11, this.getWidth() - 3};
                nArray = new int[]{this.getHeight() - 14, this.getHeight() - 11, this.getHeight() - 8};
                graphics.fillPolygon(nArray2, nArray, 3);
            } else {
                graphics.drawLine(this.getWidth() - 11, this.getHeight() - 11, this.getWidth() - 4, this.getHeight() - 11);
            }
            if (BorderPane.this.insideMode) {
                graphics.drawLine(this.getWidth() / 2 - 3, this.getHeight() - 11, this.getWidth() / 2 + 3, this.getHeight() - 11);
                if (this.verticalActive) {
                    nArray2 = new int[]{this.getWidth() / 2 - 3, this.getWidth() / 2 + 3, this.getWidth() / 2};
                    nArray = new int[]{this.getHeight() - 3, this.getHeight() - 3, this.getHeight() - 11};
                    graphics.fillPolygon(nArray2, nArray, 3);
                } else {
                    graphics.drawLine(this.getWidth() / 2, this.getHeight() - 11, this.getWidth() / 2, this.getHeight() - 4);
                }
            }
            if (BorderPane.this.insideMode) {
                int n = 4;
                int n2 = this.getWidth() / 2 - 20 - n;
                int n3 = this.getHeight() / 2 - 20 - n;
                graphics.setColor(Color.lightGray);
                graphics.fillRect(20, 20, n2, n3);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(this.getWidth() / 2 + n + 1, 20, n2, n3);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(20, this.getHeight() / 2 + n + 1, n2, n3);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(this.getWidth() / 2 + n + 1, this.getHeight() / 2 + n + 1, n2, n3);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(20, 20, this.getWidth() - 40, this.getHeight() - 40);
            }
            this.updateBorders(graphics);
        }

        public void addBorderChangeListener(ChangeListener changeListener) {
            this.borderChangeListenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BorderPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void fireBorderStateChanged() {
            Object[] objectArray = this.borderChangeListenerList.getListenerList();
            ChangeEvent changeEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? BorderPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }

        private void updateBorders(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            BorderPane.this.currentLineColorPane.getColor();
            if (BorderPane.this.cellBorderStyle.getTopColor() != null && BorderPane.this.cellBorderStyle.getTopStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getTopColor());
                GraphHelper.drawLine(graphics2D, 15.0, 15.0, this.getWidth() - 15, 15.0, BorderPane.this.cellBorderStyle.getTopStyle());
            }
            if (BorderPane.this.cellBorderStyle.getLeftColor() != null && BorderPane.this.cellBorderStyle.getLeftStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getLeftColor());
                GraphHelper.drawLine(graphics2D, 15.0, 15.0, 15.0, this.getHeight() - 15, BorderPane.this.cellBorderStyle.getLeftStyle());
            }
            if (BorderPane.this.cellBorderStyle.getBottomColor() != null && BorderPane.this.cellBorderStyle.getBottomStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getBottomColor());
                GraphHelper.drawLine(graphics2D, 15.0, this.getHeight() - 15, this.getWidth() - 15, this.getHeight() - 15, BorderPane.this.cellBorderStyle.getBottomStyle());
            }
            if (BorderPane.this.cellBorderStyle.getRightColor() != null && BorderPane.this.cellBorderStyle.getRightStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getRightColor());
                GraphHelper.drawLine(graphics2D, this.getWidth() - 15, 15.0, this.getWidth() - 15, this.getHeight() - 15, BorderPane.this.cellBorderStyle.getRightStyle());
            }
            if (BorderPane.this.cellBorderStyle.getVerticalColor() != null && BorderPane.this.cellBorderStyle.getVerticalStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getVerticalColor());
                GraphHelper.drawLine(graphics2D, this.getWidth() / 2, 16.0, this.getWidth() / 2, this.getHeight() - 16, BorderPane.this.cellBorderStyle.getVerticalStyle());
            }
            if (BorderPane.this.cellBorderStyle.getHorizontalColor() != null && BorderPane.this.cellBorderStyle.getHorizontalStyle() != 0) {
                graphics2D.setColor(BorderPane.this.cellBorderStyle.getHorizontalColor());
                GraphHelper.drawLine(graphics2D, 16.0, this.getHeight() / 2, this.getWidth() - 16, this.getHeight() / 2, BorderPane.this.cellBorderStyle.getHorizontalStyle());
            }
            this.fireBorderStateChanged();
        }

        private void setActiveBorders(int n) {
            switch (n) {
                case 0: {
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                    break;
                }
                case 1: {
                    this.rightActive = true;
                    this.bottomActive = true;
                    this.leftActive = true;
                    this.topActive = true;
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    break;
                }
                case 2: {
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                    this.horizontalActive = true;
                    this.verticalActive = true;
                    break;
                }
                case 3: {
                    this.topActive = true;
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    break;
                }
                case 4: {
                    this.leftActive = true;
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.topActive = false;
                    break;
                }
                case 5: {
                    this.bottomActive = true;
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    this.rightActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                    break;
                }
                case 6: {
                    this.rightActive = true;
                    this.horizontalActive = false;
                    this.verticalActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                    break;
                }
                case 7: {
                    this.verticalActive = true;
                    this.horizontalActive = false;
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                    break;
                }
                case 8: {
                    this.horizontalActive = true;
                    this.verticalActive = false;
                    this.rightActive = false;
                    this.bottomActive = false;
                    this.leftActive = false;
                    this.topActive = false;
                }
            }
        }

        static /* synthetic */ BorderPane access$900(BorderComponent borderComponent) {
            return borderComponent.BorderPane.this;
        }
    }

    private class BorderButtonIcon
    implements Icon {
        private int display;

        private BorderButtonIcon(int n) {
            this.display = n;
        }

        public int getIconWidth() {
            return 32;
        }

        public int getIconHeight() {
            return 32;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.display == 1) {
                graphics.setColor(Color.black);
                graphics.drawRect(3, 3, this.getIconWidth() - 7, this.getIconHeight() - 7);
            } else if (this.display == 2) {
                graphics.setColor(Color.black);
                graphics.drawLine(this.getIconWidth() / 2, 3, this.getIconWidth() / 2, this.getIconHeight() - 4);
                graphics.drawLine(3, this.getIconHeight() / 2, this.getIconWidth() - 4, this.getIconHeight() / 2);
                graphics.setColor(Color.lightGray);
                graphics.drawRect(3, 3, this.getIconWidth() - 7, this.getIconHeight() - 7);
            }
        }
    }

    private class BorderButton
    extends JButton {
        private BorderButton(Icon icon) {
            super(icon);
            this.setPreferredSize(new Dimension(32, 32));
            this.setFocusPainted(false);
        }
    }

    private class ToggleButton
    extends JToggleButton
    implements ActionListener {
        private int borderType = 0;

        public ToggleButton(Icon icon, int n) {
            super(icon);
            this.borderType = n;
            this.setPreferredSize(new Dimension(32, 32));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                BorderPane.this.borderComponent.setActiveBorders(this.borderType);
            } else {
                BorderPane.this.borderComponent.setActiveBorders(0);
            }
            switch (this.borderType) {
                case 3: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getTopStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getTopColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setTopStyle(0);
                            BorderPane.this.cellBorderStyle.setTopColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setTopColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setTopStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getTopStyle() == 0 && BorderPane.this.cellBorderStyle.getTopColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setTopStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setTopColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setTopColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setTopStyle(0);
                    break;
                }
                case 8: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getHorizontalStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getHorizontalColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setHorizontalStyle(0);
                            BorderPane.this.cellBorderStyle.setHorizontalColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setHorizontalColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setHorizontalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getHorizontalStyle() == 0 && BorderPane.this.cellBorderStyle.getHorizontalColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setHorizontalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setHorizontalColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setHorizontalColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setHorizontalStyle(0);
                    break;
                }
                case 5: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getBottomStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getBottomColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setBottomStyle(0);
                            BorderPane.this.cellBorderStyle.setBottomColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setBottomColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setBottomStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getBottomStyle() == 0 && BorderPane.this.cellBorderStyle.getBottomColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setBottomStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setBottomColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setBottomColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setBottomStyle(0);
                    break;
                }
                case 4: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getLeftStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getLeftColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setLeftStyle(0);
                            BorderPane.this.cellBorderStyle.setLeftColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setLeftColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setLeftStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getLeftStyle() == 0 && BorderPane.this.cellBorderStyle.getLeftColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setLeftStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setLeftColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setLeftColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setLeftStyle(0);
                    break;
                }
                case 7: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getVerticalStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getVerticalColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setVerticalStyle(0);
                            BorderPane.this.cellBorderStyle.setVerticalColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setVerticalColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setVerticalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getVerticalStyle() == 0 && BorderPane.this.cellBorderStyle.getVerticalColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setVerticalStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setVerticalColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setVerticalColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setVerticalStyle(0);
                    break;
                }
                case 6: {
                    if (this.isSelected()) {
                        if (BorderPane.this.cellBorderStyle.getRightStyle() == BorderPane.this.currentLineCombo.getSelectedLineStyle() && BorderPane.this.cellBorderStyle.getRightColor() == BorderPane.this.currentLineColorPane.getColor()) {
                            BorderPane.this.cellBorderStyle.setRightStyle(0);
                            BorderPane.this.cellBorderStyle.setRightColor(Color.WHITE);
                            break;
                        }
                        BorderPane.this.cellBorderStyle.setRightColor(BorderPane.this.currentLineColorPane.getColor());
                        BorderPane.this.cellBorderStyle.setRightStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        break;
                    }
                    if (BorderPane.this.cellBorderStyle.getRightStyle() == 0 && BorderPane.this.cellBorderStyle.getRightColor() == Color.WHITE) {
                        BorderPane.this.cellBorderStyle.setRightStyle(BorderPane.this.currentLineCombo.getSelectedLineStyle());
                        BorderPane.this.cellBorderStyle.setRightColor(BorderPane.this.currentLineColorPane.getColor());
                        break;
                    }
                    BorderPane.this.cellBorderStyle.setRightColor(Color.BLACK);
                    BorderPane.this.cellBorderStyle.setRightStyle(0);
                }
            }
            BorderPane.this.borderComponent.repaint();
        }
    }

    public static class BorderStyleColor {
        private int style;
        private Color color;

        public BorderStyleColor(int n, Color color) {
            this.setStyle(n);
            this.setColor(color);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int n) {
            this.style = n;
        }

        public boolean equals(Object object) {
            if (object instanceof BorderStyleColor) {
                BorderStyleColor borderStyleColor = (BorderStyleColor)object;
                if (this.getStyle() == borderStyleColor.getStyle() && ComparatorUtils.equals(this.getColor(), borderStyleColor.getColor())) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ColumnRow {
        private int column = -1;
        private int row = -1;
        private boolean isVertical = true;

        public ColumnRow() {
            this(-1, -1, true);
        }

        public ColumnRow(int n, int n2, boolean bl) {
            this.column = n;
            this.row = n2;
            this.isVertical = bl;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int n) {
            this.column = n;
        }

        public void setRow(int n) {
            this.row = n;
        }

        public int getRow() {
            return this.row;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ColumnRow) {
                ColumnRow columnRow = (ColumnRow)object;
                if (this.getColumn() == columnRow.getColumn() && this.getRow() == columnRow.getRow()) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            if (this.isVertical) {
                return "ColumnRow[" + this.getColumn() + ", " + this.getRow() + ", vertical]";
            }
            return "ColumnRow[" + this.getColumn() + ", " + this.getRow() + ", horizontal]";
        }
    }
}

